/**
 ********************************************************************************
 *** MultiOpDialogMailTemplatesAction.java                                    ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import net.anotheria.util.NumberUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.asresourcedata.data.MailTemplateFactory;
import net.anotheria.anosite.gen.asresourcedata.data.MailTemplate;
import net.anotheria.anosite.gen.asresourcedata.bean.EditMailTemplateFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import net.anotheria.asg.data.MultilingualObject;

public class MultiOpDialogMailTemplatesAction extends BaseMailTemplateAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asresourcedataMailTemplateDelete"))
			return asresourcedataMailTemplateDelete(mapping, req, res);
		if (path.equals("asresourcedataMailTemplateDuplicate"))
			return asresourcedataMailTemplateDuplicate(mapping, req, res);
		if (path.equals("asresourcedataMailTemplateUpdate"))
			return asresourcedataMailTemplateUpdate(mapping, req, res);
		if (path.equals("asresourcedataMailTemplateClose"))
			return asresourcedataMailTemplateClose(mapping, req, res);
		if (path.equals("asresourcedataMailTemplateCopyLang"))
			return asresourcedataMailTemplateCopyLang(mapping, req, res);
		if (path.equals("asresourcedataMailTemplateSwitchMultilang"))
			return asresourcedataMailTemplateSwitchMultilang(mapping, req, res);
		if (path.equals("asresourcedataMailTemplateLock"))
			return asresourcedataMailTemplateLock(mapping, req, res);
		if (path.equals("asresourcedataMailTemplateUnLock"))
			return asresourcedataMailTemplateUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand asresourcedataMailTemplateDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			MailTemplate mailtemplateCurr = getASResourceDataService().getMailTemplate(id);
			if (mailtemplateCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)mailtemplateCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASResourceDataService().deleteMailTemplate(id);
		}
		res.sendRedirect("asresourcedataMailTemplateShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand asresourcedataMailTemplateDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		MailTemplate mailtemplateSrc = getASResourceDataService().getMailTemplate(id);
		MailTemplate mailtemplateDest = MailTemplateFactory.createMailTemplate(mailtemplateSrc);



		MailTemplate mailtemplateCreated = getASResourceDataService().createMailTemplate(mailtemplateDest);
		res.sendRedirect("asresourcedataMailTemplateEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+mailtemplateCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand asresourcedataMailTemplateUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditMailTemplateFB form = new EditMailTemplateFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		MailTemplate mailtemplate = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		mailtemplate = (MailTemplate)getASResourceDataService().getMailTemplate(form.getId()).clone();
	}else{
		mailtemplate = MailTemplateFactory.createMailTemplate();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	mailtemplate.setName(form.getName());
	mailtemplate.setSenderEN(form.getSenderEN());
	mailtemplate.setSenderDE(form.getSenderDE());
	mailtemplate.setSenderNameEN(form.getSenderNameEN());
	mailtemplate.setSenderNameDE(form.getSenderNameDE());
	mailtemplate.setSubjectEN(form.getSubjectEN());
	mailtemplate.setSubjectDE(form.getSubjectDE());
	mailtemplate.setMessageEN(form.getMessageEN());
	mailtemplate.setMessageDE(form.getMessageDE());
	mailtemplate.setMjmlEN(form.getMjmlEN());
	mailtemplate.setMjmlDE(form.getMjmlDE());
	mailtemplate.setPlainMessageEN(form.getPlainMessageEN());
	mailtemplate.setPlainMessageDE(form.getPlainMessageDE());
	// skipped container localizations

	MailTemplate updatedCopy = null;
	if (create){
		updatedCopy = getASResourceDataService().createMailTemplate(mailtemplate);
	}else{
		canUpdateMailTemplates(mailtemplate, req);
		checkMailTemplates(mailtemplate, req);
		updatedCopy = getASResourceDataService().updateMailTemplate(mailtemplate);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("asresourcedataMailTemplateEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(mailtemplate, req);
		res.sendRedirect("asresourcedataMailTemplateShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(MailTemplate mailtemplate, HttpServletRequest req) throws Exception{
	if(((LockableObject)mailtemplate).isLocked())
		unLockMailTemplates(mailtemplate, req, false);
}

public ActionCommand asresourcedataMailTemplateCopyLang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String sourceLanguage = req.getParameter("pSrcLang");
	if (sourceLanguage==null || sourceLanguage.length()==0)
		throw new RuntimeException("No source language");

	String destLanguage = req.getParameter("pDestLang");
	if (destLanguage==null || destLanguage.length()==0)
		throw new RuntimeException("No destination language");

	String id = getStringParameter(req, PARAM_ID);
	MailTemplate mailtemplate = getASResourceDataService().getMailTemplate(id);
	canUpdateMailTemplates(mailtemplate, req);
	checkMailTemplates(mailtemplate, req);
	mailtemplate.copyLANG2LANG(sourceLanguage, destLanguage);
	getASResourceDataService().updateMailTemplate(mailtemplate);
	res.sendRedirect("asresourcedataMailTemplateEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand asresourcedataMailTemplateSwitchMultilang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	String value = getStringParameter(req, "value");
	MailTemplate mailtemplate = getASResourceDataService().getMailTemplate(id);
	canUpdateMailTemplates(mailtemplate, req);
	checkMailTemplates(mailtemplate, req);
	((MultilingualObject)mailtemplate).setMultilingualDisabledInstance(Boolean.valueOf(value));
	getASResourceDataService().updateMailTemplate(mailtemplate);
	res.sendRedirect("asresourcedataMailTemplateEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand asresourcedataMailTemplateLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	MailTemplate mailtemplateCurr = id != null && !id.equals("") ? getASResourceDataService().getMailTemplate(id) : null;
	if(mailtemplateCurr != null && mailtemplateCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)mailtemplateCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockMailTemplates(mailtemplateCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, mailtemplateCurr));
	return null;
}

public ActionCommand asresourcedataMailTemplateUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	MailTemplate mailtemplateCurr = id != null && !id.equals("") ? getASResourceDataService().getMailTemplate(id) : null;
	if(mailtemplateCurr != null && mailtemplateCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)mailtemplateCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockMailTemplates(mailtemplateCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, mailtemplateCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, MailTemplate item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "asresourcedataMailTemplateShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "asresourcedataMailTemplateEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "asresourcedataMailTemplateShow?ts="+System.currentTimeMillis();
}

public ActionCommand asresourcedataMailTemplateClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	MailTemplate mailtemplateCurr = id != null && !id.equals("") ? getASResourceDataService().getMailTemplate(id) : null;
	if(mailtemplateCurr != null && mailtemplateCurr instanceof LockableObject && ((LockableObject)mailtemplateCurr).isLocked()) 
		unLockMailTemplates(mailtemplateCurr, req, false);
	res.sendRedirect("asresourcedataMailTemplateShow?ts="+System.currentTimeMillis());
	return null;
}

}
