/**
 ********************************************************************************
 *** MultiOpDialogPdfTemplatesAction.java                                     ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import net.anotheria.util.NumberUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.asresourcedata.data.PdfTemplateFactory;
import net.anotheria.anosite.gen.asresourcedata.data.PdfTemplate;
import net.anotheria.anosite.gen.asresourcedata.bean.EditPdfTemplateFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import net.anotheria.asg.data.MultilingualObject;

public class MultiOpDialogPdfTemplatesAction extends BasePdfTemplateAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asresourcedataPdfTemplateDelete"))
			return asresourcedataPdfTemplateDelete(mapping, req, res);
		if (path.equals("asresourcedataPdfTemplateDuplicate"))
			return asresourcedataPdfTemplateDuplicate(mapping, req, res);
		if (path.equals("asresourcedataPdfTemplateUpdate"))
			return asresourcedataPdfTemplateUpdate(mapping, req, res);
		if (path.equals("asresourcedataPdfTemplateClose"))
			return asresourcedataPdfTemplateClose(mapping, req, res);
		if (path.equals("asresourcedataPdfTemplateCopyLang"))
			return asresourcedataPdfTemplateCopyLang(mapping, req, res);
		if (path.equals("asresourcedataPdfTemplateSwitchMultilang"))
			return asresourcedataPdfTemplateSwitchMultilang(mapping, req, res);
		if (path.equals("asresourcedataPdfTemplateLock"))
			return asresourcedataPdfTemplateLock(mapping, req, res);
		if (path.equals("asresourcedataPdfTemplateUnLock"))
			return asresourcedataPdfTemplateUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand asresourcedataPdfTemplateDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			PdfTemplate pdftemplateCurr = getASResourceDataService().getPdfTemplate(id);
			if (pdftemplateCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)pdftemplateCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASResourceDataService().deletePdfTemplate(id);
		}
		res.sendRedirect("asresourcedataPdfTemplateShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand asresourcedataPdfTemplateDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		PdfTemplate pdftemplateSrc = getASResourceDataService().getPdfTemplate(id);
		PdfTemplate pdftemplateDest = PdfTemplateFactory.createPdfTemplate(pdftemplateSrc);



		PdfTemplate pdftemplateCreated = getASResourceDataService().createPdfTemplate(pdftemplateDest);
		res.sendRedirect("asresourcedataPdfTemplateEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+pdftemplateCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand asresourcedataPdfTemplateUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditPdfTemplateFB form = new EditPdfTemplateFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		PdfTemplate pdftemplate = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		pdftemplate = (PdfTemplate)getASResourceDataService().getPdfTemplate(form.getId()).clone();
	}else{
		pdftemplate = PdfTemplateFactory.createPdfTemplate();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	pdftemplate.setName(form.getName());
	pdftemplate.setShowPageNumbers(form.isShowPageNumbers());
	pdftemplate.setApplyBackgroundStyles(form.isApplyBackgroundStyles());
	pdftemplate.setHeaderMargin(form.getHeaderMargin());
	pdftemplate.setHeaderTemplateEN(form.getHeaderTemplateEN());
	pdftemplate.setHeaderTemplateDE(form.getHeaderTemplateDE());
	pdftemplate.setFooterMargin(form.getFooterMargin());
	pdftemplate.setFooterTemplateEN(form.getFooterTemplateEN());
	pdftemplate.setFooterTemplateDE(form.getFooterTemplateDE());
	pdftemplate.setContentTemplateEN(form.getContentTemplateEN());
	pdftemplate.setContentTemplateDE(form.getContentTemplateDE());
	// skipped container localizations

	PdfTemplate updatedCopy = null;
	if (create){
		updatedCopy = getASResourceDataService().createPdfTemplate(pdftemplate);
	}else{
		canUpdatePdfTemplates(pdftemplate, req);
		checkPdfTemplates(pdftemplate, req);
		updatedCopy = getASResourceDataService().updatePdfTemplate(pdftemplate);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("asresourcedataPdfTemplateEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(pdftemplate, req);
		res.sendRedirect("asresourcedataPdfTemplateShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(PdfTemplate pdftemplate, HttpServletRequest req) throws Exception{
	if(((LockableObject)pdftemplate).isLocked())
		unLockPdfTemplates(pdftemplate, req, false);
}

public ActionCommand asresourcedataPdfTemplateCopyLang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String sourceLanguage = req.getParameter("pSrcLang");
	if (sourceLanguage==null || sourceLanguage.length()==0)
		throw new RuntimeException("No source language");

	String destLanguage = req.getParameter("pDestLang");
	if (destLanguage==null || destLanguage.length()==0)
		throw new RuntimeException("No destination language");

	String id = getStringParameter(req, PARAM_ID);
	PdfTemplate pdftemplate = getASResourceDataService().getPdfTemplate(id);
	canUpdatePdfTemplates(pdftemplate, req);
	checkPdfTemplates(pdftemplate, req);
	pdftemplate.copyLANG2LANG(sourceLanguage, destLanguage);
	getASResourceDataService().updatePdfTemplate(pdftemplate);
	res.sendRedirect("asresourcedataPdfTemplateEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand asresourcedataPdfTemplateSwitchMultilang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	String value = getStringParameter(req, "value");
	PdfTemplate pdftemplate = getASResourceDataService().getPdfTemplate(id);
	canUpdatePdfTemplates(pdftemplate, req);
	checkPdfTemplates(pdftemplate, req);
	((MultilingualObject)pdftemplate).setMultilingualDisabledInstance(Boolean.valueOf(value));
	getASResourceDataService().updatePdfTemplate(pdftemplate);
	res.sendRedirect("asresourcedataPdfTemplateEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand asresourcedataPdfTemplateLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	PdfTemplate pdftemplateCurr = id != null && !id.equals("") ? getASResourceDataService().getPdfTemplate(id) : null;
	if(pdftemplateCurr != null && pdftemplateCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)pdftemplateCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockPdfTemplates(pdftemplateCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, pdftemplateCurr));
	return null;
}

public ActionCommand asresourcedataPdfTemplateUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	PdfTemplate pdftemplateCurr = id != null && !id.equals("") ? getASResourceDataService().getPdfTemplate(id) : null;
	if(pdftemplateCurr != null && pdftemplateCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)pdftemplateCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockPdfTemplates(pdftemplateCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, pdftemplateCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, PdfTemplate item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "asresourcedataPdfTemplateShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "asresourcedataPdfTemplateEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "asresourcedataPdfTemplateShow?ts="+System.currentTimeMillis();
}

public ActionCommand asresourcedataPdfTemplateClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	PdfTemplate pdftemplateCurr = id != null && !id.equals("") ? getASResourceDataService().getPdfTemplate(id) : null;
	if(pdftemplateCurr != null && pdftemplateCurr instanceof LockableObject && ((LockableObject)pdftemplateCurr).isLocked()) 
		unLockPdfTemplates(pdftemplateCurr, req, false);
	res.sendRedirect("asresourcedataPdfTemplateShow?ts="+System.currentTimeMillis());
	return null;
}

}
