/**
 ********************************************************************************
 *** LocalizationBundleDocument.java                                          ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.data;

import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.anodoc.util.context.ContextManager;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.anodoc.data.BooleanProperty;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;
import net.anotheria.asg.data.MultilingualObject;

public class LocalizationBundleDocument extends AbstractASGDocument implements LocalizationBundle, IComparable, MultilingualObject{

	public LocalizationBundleDocument() {
		super("");
	}

	public LocalizationBundleDocument(String id){
		super(id);
	}

	public LocalizationBundleDocument(LocalizationBundleDocument toClone){
		super(toClone);
	}

	LocalizationBundleDocument(LocalizationBundleBuilder builder){
		super("");
		setName(builder.name);
		setMessages(builder.messages);
		setParentBundle(builder.parentBundle);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public String getMessagesEN(){
		return getString(PROP_MESSAGES_EN);
	}

	public String getMessagesDE(){
		return getString(PROP_MESSAGES_DE);
	}

	public String getMessages(){
		return getString("messages_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setMessagesEN(String value){
		setString(PROP_MESSAGES_EN, value);
	}

	public void setMessagesDE(String value){
		setString(PROP_MESSAGES_DE, value);
	}

	public void setMessages(String value){
		setString(("messages_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}


	public String getParentBundle(){
		return getString(LINK_PROP_PARENT_BUNDLE);
	}

	public void setParentBundle(String value){
		setString(LINK_PROP_PARENT_BUNDLE, value);
	}


	public String toString(){
		String ret = "LocalizationBundle ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "messages: "+getMessages();
		return ret;
	}


	public int compareTo(LocalizationBundle comparable){
		return compareTo(comparable, LocalizationBundleSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		LocalizationBundleDocument anotherDoc = (LocalizationBundleDocument) anotherComparable;
		switch(method){
			case LocalizationBundleSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case LocalizationBundleSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case LocalizationBundleSortType.SORT_BY_MESSAGES:
				return BasicComparable.compareString(getMessages(), anotherDoc.getMessages());
			case LocalizationBundleSortType.SORT_BY_PARENTBUNDLE:
				return BasicComparable.compareString(getParentBundle(), anotherDoc.getParentBundle());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "LocalizationBundle";
	}

	public String getDefinedParentName(){
		return "ASResourceData";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getMessagesEN());
		footprint.append(getMessagesDE());
		footprint.append(getParentBundle());
		return MD5Util.getMD5Hash(footprint);
	}
	public void copyLANG2LANG(String sourceLanguage, String destLanguage){
		if (sourceLanguage.equals("EN") && destLanguage.equals("DE"))
			copyEN2DE();
		if (sourceLanguage.equals("DE") && destLanguage.equals("EN"))
			copyDE2EN();
	}

	/**
	 * Copies all multilingual properties from language EN to language DE
	 */
	public void copyEN2DE(){
		setMessagesDE(getMessagesEN());
	}

	/**
	 * Copies all multilingual properties from language DE to language EN
	 */
	public void copyDE2EN(){
		setMessagesEN(getMessagesDE());
	}


	public boolean isMultilingualDisabledInstance(){
		try{
			return ((BooleanProperty)getInternalProperty(INT_PROPERTY_MULTILINGUAL_DISABLED)).getboolean();
		}catch(NoSuchPropertyException e){
			return false;
		}
	}

	public void setMultilingualDisabledInstance(boolean value){
		setInternalProperty(new BooleanProperty(INT_PROPERTY_MULTILINGUAL_DISABLED, value));
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof LocalizationBundleDocument) && ((LocalizationBundleDocument)o).getId().equals(getId()));
	}
}
