/**
 ********************************************************************************
 *** TextResourceDocument.java                                                ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.data;

import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.anodoc.util.context.ContextManager;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.anodoc.data.BooleanProperty;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;
import net.anotheria.asg.data.MultilingualObject;

public class TextResourceDocument extends AbstractASGDocument implements TextResource, IComparable, MultilingualObject{

	public TextResourceDocument() {
		super("");
	}

	public TextResourceDocument(String id){
		super(id);
	}

	public TextResourceDocument(TextResourceDocument toClone){
		super(toClone);
	}

	TextResourceDocument(TextResourceBuilder builder){
		super("");
		setName(builder.name);
		setValue(builder.value);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public String getValueEN(){
		return getString(PROP_VALUE_EN);
	}

	public String getValueDE(){
		return getString(PROP_VALUE_DE);
	}

	public String getValue(){
		return getString("value_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setValueEN(String value){
		setString(PROP_VALUE_EN, value);
	}

	public void setValueDE(String value){
		setString(PROP_VALUE_DE, value);
	}

	public void setValue(String value){
		setString(("value_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}



	public String toString(){
		String ret = "TextResource ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "value: "+getValue();
		return ret;
	}


	public int compareTo(TextResource comparable){
		return compareTo(comparable, TextResourceSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		TextResourceDocument anotherDoc = (TextResourceDocument) anotherComparable;
		switch(method){
			case TextResourceSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case TextResourceSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case TextResourceSortType.SORT_BY_VALUE:
				return BasicComparable.compareString(getValue(), anotherDoc.getValue());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "TextResource";
	}

	public String getDefinedParentName(){
		return "ASResourceData";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getValueEN());
		footprint.append(getValueDE());
		return MD5Util.getMD5Hash(footprint);
	}
	public void copyLANG2LANG(String sourceLanguage, String destLanguage){
		if (sourceLanguage.equals("EN") && destLanguage.equals("DE"))
			copyEN2DE();
		if (sourceLanguage.equals("DE") && destLanguage.equals("EN"))
			copyDE2EN();
	}

	/**
	 * Copies all multilingual properties from language EN to language DE
	 */
	public void copyEN2DE(){
		setValueDE(getValueEN());
	}

	/**
	 * Copies all multilingual properties from language DE to language EN
	 */
	public void copyDE2EN(){
		setValueEN(getValueDE());
	}


	public boolean isMultilingualDisabledInstance(){
		try{
			return ((BooleanProperty)getInternalProperty(INT_PROPERTY_MULTILINGUAL_DISABLED)).getboolean();
		}catch(NoSuchPropertyException e){
			return false;
		}
	}

	public void setMultilingualDisabledInstance(boolean value){
		setInternalProperty(new BooleanProperty(INT_PROPERTY_MULTILINGUAL_DISABLED, value));
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof TextResourceDocument) && ((TextResourceDocument)o).getId().equals(getId()));
	}
}
