/**
 ********************************************************************************
 *** IASSiteConfigService.java                                                ***
 *** Generator: net.anotheria.asg.generator.model.ServiceGenerator            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assiteconfig.service;

import java.util.List;
import net.anotheria.util.sorter.SortType;
import net.anotheria.anosite.gen.assiteconfig.data.FilteredIP;
import java.util.Set;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.slicer.Segment;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.asg.service.ASGService;

public interface IASSiteConfigService extends ASGService{

// Generated by: class net.anotheria.asg.generator.model.ServiceGenerator.generateInterface

	/**
	 * Returns all FilteredIPs objects stored.
	 */
	List<FilteredIP> getFilteredIPs() throws ASSiteConfigServiceException;

	/**
	 * Returns all FilteredIPs objects sorted by given sortType.
	 */
	List<FilteredIP> getFilteredIPs(SortType sortType) throws ASSiteConfigServiceException;

	/**
	 * Deletes a FilteredIP object by id.
	 */
	void deleteFilteredIP(String id) throws ASSiteConfigServiceException;

	/**
	 * Deletes a FilteredIP object.
	 */
	void deleteFilteredIP(FilteredIP filteredip) throws ASSiteConfigServiceException;

	/**
	 * Deletes multiple FilteredIP object.
	 */
	void deleteFilteredIPs(List<FilteredIP> list) throws ASSiteConfigServiceException;

	/**
	 * Returns the FilteredIP object with the specified id.
	 */
	FilteredIP getFilteredIP(String id) throws ASSiteConfigServiceException;

	/**
	 * Imports a new FilteredIP object.
	 * Returns the created version.
	 */
	FilteredIP importFilteredIP(FilteredIP filteredip) throws ASSiteConfigServiceException;

	/**
	 * Imports multiple new  FilteredIP object.
	 * Returns the created versions.
	 */
	List<FilteredIP> importFilteredIPs(List<FilteredIP> list) throws ASSiteConfigServiceException;

	/**
	 * Creates a new FilteredIP object.
	 * Returns the created version.
	 */
	FilteredIP createFilteredIP(FilteredIP filteredip) throws ASSiteConfigServiceException;

	/**
	 * Creates multiple new FilteredIP objects.
	 * Returns the created versions.
	 */
	List<FilteredIP> createFilteredIPs(List<FilteredIP> list) throws ASSiteConfigServiceException;

	/**
	 * Updates a FilteredIP object.
	 * Returns the updated version.
	 */
	FilteredIP updateFilteredIP(FilteredIP filteredip) throws ASSiteConfigServiceException;

	/**
	 * Updates multiple FilteredIP objects.
	 * Returns the updated versions.
	 */
	List<FilteredIP> updateFilteredIPs(List<FilteredIP> list) throws ASSiteConfigServiceException;

	/**
	 * Returns all FilteredIP objects, where property with given name equals object.
	 */
	List<FilteredIP> getFilteredIPsByProperty(String propertyName, Object value) throws ASSiteConfigServiceException;

	/**
	 * Returns all FilteredIP objects, where property with given name equals object, sorted.
	 */
	List<FilteredIP> getFilteredIPsByProperty(String propertyName, Object value, SortType sortType) throws ASSiteConfigServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnFilteredIPs(DocumentQuery query) throws ASSiteConfigServiceException;

	/**
	 * Returns all FilteredIP objects, where property matches.
	 */
	List<FilteredIP> getFilteredIPsByProperty(QueryProperty... property) throws ASSiteConfigServiceException;

	/**
	 * Returns all FilteredIP objects, where property matches, sorted.
	 */
	List<FilteredIP> getFilteredIPsByProperty(SortType sortType, QueryProperty... property) throws ASSiteConfigServiceException;

	/**
	 * Returns all FilteredIPs count.
	 */
	int getFilteredIPsCount() throws ASSiteConfigServiceException;

	/**
	 * Returns FilteredIPs objects segment.
	 */
	List<FilteredIP> getFilteredIPs(Segment aSegment) throws ASSiteConfigServiceException;

	/**
	 * Returns FilteredIP objects segment, where property matches.
	 */
	List<FilteredIP> getFilteredIPsByProperty(Segment aSegment, QueryProperty... aProperty) throws ASSiteConfigServiceException;

	/**
	 * Returns FilteredIP objects segment, where property matches, sorted.
	 */
	List<FilteredIP> getFilteredIPsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASSiteConfigServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportFilteredIPsToXML(List<FilteredIP> listFilteredIPs)  throws ASSiteConfigServiceException;

	/**
	 * Create json object list dependencies for this FilteredIP document.
	 */
	void fetchFilteredIP(String id, Set<String> addedDocuments, JSONArray data) throws ASSiteConfigServiceException;

	/**
	 * Save transferred document by its own type.
	 */
	void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASSiteConfigServiceException;
	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service.
	 */
	QueryResult executeQueryOnAllObjects(DocumentQuery query) throws ASSiteConfigServiceException;
	/**
	 * creates an xml element with all contained data.
	 */
	XMLNode exportToXML() throws ASSiteConfigServiceException;

}
