/**
 ********************************************************************************
 *** MultiOpPageTemplatesMediaLinksAction.java                                ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.assitedata.data.PageTemplateFactory;
import net.anotheria.anosite.gen.assitedata.data.PageTemplate;
import net.anotheria.anosite.gen.assitedata.bean.MediaLinksElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.assitedata.bean.MediaLinksQuickAddFB;
import net.anotheria.anosite.gen.assitedata.data.MediaLink;
import net.anotheria.anosite.gen.assitedata.data.MediaLinkSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpPageTemplatesMediaLinksAction extends BasePageTemplateAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("assitedataPageTemplateMediaLinksShow"))
			return assitedataPageTemplateMediaLinksShow(mapping, req, res);
		if (path.equals("assitedataPageTemplateMediaLinksAdd"))
			return assitedataPageTemplateMediaLinksAdd(mapping, req, res);
		if (path.equals("assitedataPageTemplateMediaLinksDelete"))
			return assitedataPageTemplateMediaLinksDelete(mapping, req, res);
		if (path.equals("assitedataPageTemplateMediaLinksMove"))
			return assitedataPageTemplateMediaLinksMove(mapping, req, res);
		if (path.equals("assitedataPageTemplateMediaLinksQuickAdd"))
			return assitedataPageTemplateMediaLinksQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand assitedataPageTemplateMediaLinksShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		PageTemplate pagetemplate = getASSiteDataService().getPageTemplate(id);
		addBeanToRequest(req, "ownerId", id);
		checkPageTemplates(pagetemplate, req);

		MediaLinksElementFB form = new MediaLinksElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(pagetemplate.getId());
		addBeanToRequest(req, "assitedataPageTemplateMediaLinksElementForm", form);

		MediaLinksQuickAddFB quickAddForm = new MediaLinksQuickAddFB() ;
		quickAddForm.setOwnerId(pagetemplate.getId());
		addBeanToRequest(req, "assitedataPageTemplateMediaLinksQuickAddForm", quickAddForm);


		//link mediaLinks to ASSiteData.MediaLink
		List<MediaLink> medialinks = getASSiteDataService().getMediaLinks(new MediaLinkSortType(MediaLinkSortType.SORT_BY_NAME));
		List<LabelValueBean> medialinksValues = new ArrayList<LabelValueBean>(medialinks.size());
		for (int i=0; i<medialinks.size(); i++){
			net.anotheria.anosite.gen.assitedata.data.MediaLink tmp_medialink = (net.anotheria.anosite.gen.assitedata.data.MediaLink) medialinks.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_medialink.getId(), tmp_medialink.getName()+" ["+tmp_medialink.getId()+"]" );
			medialinksValues.add(bean);
		}
		addBeanToRequest(req, "medialinksValuesCollection", medialinksValues);
		// generate list ...
		int size = pagetemplate.getMediaLinksSize();
		List<MediaLinksElementFB> beans = new ArrayList<MediaLinksElementFB>(size);
		for (int i=0; i<size; i++){
			String value = pagetemplate.getMediaLinksElement(i);
			MediaLinksElementFB bean = new MediaLinksElementFB();
			bean.setOwnerId(pagetemplate.getId());
			bean.setPosition(i);
			bean.setMediaLinks(value);
			try{
				MediaLink tmp_medialink = getASSiteDataService().getMediaLink(value);
				bean.setDescription(tmp_medialink.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand assitedataPageTemplateMediaLinksDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		PageTemplate pagetemplateCurr = getASSiteDataService().getPageTemplate(id);
		canUpdatePageTemplates(pagetemplateCurr, req);
		checkPageTemplates(pagetemplateCurr, req);
		int position = getIntParameter(req, "pPosition");
		PageTemplate pagetemplate = getASSiteDataService().getPageTemplate(id);
		pagetemplate.removeMediaLinksElement(position);
		getASSiteDataService().updatePageTemplate(pagetemplate);
		return assitedataPageTemplateMediaLinksShow(mapping, req, res);
	}

	public ActionCommand assitedataPageTemplateMediaLinksMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		PageTemplate pagetemplate = getASSiteDataService().getPageTemplate(id);
		canUpdatePageTemplates(pagetemplate, req);
		checkPageTemplates(pagetemplate, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(pagetemplate, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(pagetemplate, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(pagetemplate, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(pagetemplate, position);
		return assitedataPageTemplateMediaLinksShow(mapping, req, res);
	}

	private void moveUp(PageTemplate pagetemplate, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		pagetemplate.swapMediaLinksElement(position, position-1);
		getASSiteDataService().updatePageTemplate(pagetemplate);
	}

	private void moveTop(PageTemplate pagetemplate, int position) throws ASGRuntimeException {
		List<String> targetList = pagetemplate.getMediaLinks();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		pagetemplate.setMediaLinks(targetList);
		getASSiteDataService().updatePageTemplate(pagetemplate);
	}

	private void moveDown(PageTemplate pagetemplate, int position) throws ASGRuntimeException {
		if (position<pagetemplate.getMediaLinksSize()-1){
			pagetemplate.swapMediaLinksElement(position, position+1);
			getASSiteDataService().updatePageTemplate(pagetemplate);
		}
	}

	private void moveBottom(PageTemplate pagetemplate, int position) throws ASGRuntimeException {
		List<String> targetList = pagetemplate.getMediaLinks();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		pagetemplate.setMediaLinks(targetList);
		getASSiteDataService().updatePageTemplate(pagetemplate);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand assitedataPageTemplateMediaLinksAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		MediaLinksElementFB form = new MediaLinksElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		PageTemplate pagetemplate;
		pagetemplate = getASSiteDataService().getPageTemplate(id);
		canUpdatePageTemplates(pagetemplate, req);
		checkPageTemplates(pagetemplate, req);
		pagetemplate.addMediaLinksElement(form.getMediaLinks());
		getASSiteDataService().updatePageTemplate(pagetemplate);
		return assitedataPageTemplateMediaLinksShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand assitedataPageTemplateMediaLinksQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		MediaLinksQuickAddFB form = new MediaLinksQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		PageTemplate pagetemplate;
		pagetemplate = getASSiteDataService().getPageTemplate(id);
		canUpdatePageTemplates(pagetemplate, req);
		checkPageTemplates(pagetemplate, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				pagetemplate.addMediaLinksElement(""+i);
			}
		}
		getASSiteDataService().updatePageTemplate(pagetemplate);
		return assitedataPageTemplateMediaLinksShow(mapping, req, res);
	}

}
