/**
 ********************************************************************************
 *** ShowEntryPointsAction.java                                               ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.assitedata.data.EntryPoint;
import net.anotheria.anosite.gen.assitedata.bean.EntryPointListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.shared.data.PageAliasTypeEnum;
import net.anotheria.anosite.gen.assitedata.bean.EntryPointListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;
import net.anotheria.asg.exception.ConstantNotFoundException;

public class ShowEntryPointsAction extends BaseEntryPointAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"EntryPoint";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"EntryPoint";
	private static Logger log = LoggerFactory.getLogger(ShowEntryPointsAction.class);
	private Sorter<EntryPointListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;
	private IAttributeDecorator startPageDecorator;
	private IAttributeDecorator startSiteDecorator;

	private DocumentFilter nameFilterAZ;

	public ShowEntryPointsAction(){
		sorter = new QuickSorter<EntryPointListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
			startPageDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.LinkTargetNameDecorator").newInstance();
			startSiteDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.LinkTargetNameDecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = EntryPointListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = EntryPointListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		EntryPointListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new EntryPointListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (EntryPointListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new EntryPointListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<EntryPoint> _unfiltered_entrypoints = getASSiteDataService().getEntryPoints();
		List<EntryPoint> entrypoints = new ArrayList<EntryPoint>();
		for (int i=0; i<_unfiltered_entrypoints.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_entrypoints.get(i), "name", filterParameter0));
			if (mayPass)
				entrypoints.add(_unfiltered_entrypoints.get(i));
		}
		List<EntryPointListItemBean> beans = new ArrayList<EntryPointListItemBean>(entrypoints.size());
		for (EntryPoint entrypoint : entrypoints){
			checkEntryPoints(entrypoint, req);
			EntryPointListItemBean bean = makeEntryPointListItemBean(entrypoint);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "entrypoints", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected EntryPointListItemBean makeEntryPointListItemBean(EntryPoint entrypoint) {
		EntryPointListItemBean bean = new EntryPointListItemBean();
		bean.setPlainId(entrypoint.getId());
		bean.setIdForSorting(entrypoint.getId());
		bean.setId(idDecorator.decorate(entrypoint, "id", "3"));
		bean.setNameForSorting(entrypoint.getName());
		bean.setName(nameDecorator.decorate(entrypoint, "name", "null"));
		bean.setStartPageForSorting(entrypoint.getStartPage());
		bean.setStartPage(startPageDecorator.decorate(entrypoint, "startPage", "null"));
		bean.setStartSiteForSorting(entrypoint.getStartSite());
		bean.setStartSite(startSiteDecorator.decorate(entrypoint, "startSite", "null"));
		try {
			bean.setType(PageAliasTypeEnum.getConstantByValue(entrypoint.getType()).name());
		}catch(net.anotheria.asg.exception.ConstantNotFoundException e){
			bean.setType("-----");
		} //try
		bean.setDefaultEntry(entrypoint.getDefaultEntry());
		bean.setDomains(entrypoint.getDomains());
		bean.setLocked(((LockableObject)entrypoint).isLocked());
		bean.setLockerId(((LockableObject)entrypoint).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)entrypoint).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)entrypoint).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(entrypoint.getLastUpdateTimestamp()));
		return bean;
	}
}
