/**
 ********************************************************************************
 *** NaviItemDocument.java                                                    ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.data;

import net.anotheria.asg.data.AbstractASGDocument;
import java.util.List;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.anodoc.util.context.ContextManager;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.anodoc.data.BooleanProperty;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;
import net.anotheria.asg.data.MultilingualObject;

public class NaviItemDocument extends AbstractASGDocument implements NaviItem, IComparable, MultilingualObject{

	public NaviItemDocument() {
		super("");
	}

	public NaviItemDocument(String id){
		super(id);
	}

	public NaviItemDocument(NaviItemDocument toClone){
		super(toClone);
	}

	NaviItemDocument(NaviItemBuilder builder){
		super("");
		setName(builder.name);
		setTitle(builder.title);
		setIcon(builder.icon);
		setExternalLink(builder.externalLink);
		setPopup(builder.popup);
		setClassName(builder.className);
		setSubNavi(builder.subNavi);
		setGuards(builder.guards);
		setInternalLink(builder.internalLink);
		setPageAlias(builder.pageAlias);
		setAccessOperation(builder.accessOperation);
	}

	public String getNameEN(){
		return getString(PROP_NAME_EN);
	}

	public String getNameDE(){
		return getString(PROP_NAME_DE);
	}

	public String getName(){
		return getString("name_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setNameEN(String value){
		setString(PROP_NAME_EN, value);
	}

	public void setNameDE(String value){
		setString(PROP_NAME_DE, value);
	}

	public void setName(String value){
		setString(("name_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}


	public String getTitleEN(){
		return getString(PROP_TITLE_EN);
	}

	public String getTitleDE(){
		return getString(PROP_TITLE_DE);
	}

	public String getTitle(){
		return getString("title_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setTitleEN(String value){
		setString(PROP_TITLE_EN, value);
	}

	public void setTitleDE(String value){
		setString(PROP_TITLE_DE, value);
	}

	public void setTitle(String value){
		setString(("title_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}


	public String getIcon(){
		return getString(PROP_ICON);
	}

	public void setIcon(String value){
		setString(PROP_ICON, value);
	}

	public String getExternalLink(){
		return getString(PROP_EXTERNAL_LINK);
	}

	public void setExternalLink(String value){
		setString(PROP_EXTERNAL_LINK, value);
	}

	public boolean getPopup(){
		return getBoolean(PROP_POPUP);
	}

	public void setPopup(boolean value){
		setBoolean(PROP_POPUP, value);
	}

	public String getClassName(){
		return getString(PROP_CLASS_NAME);
	}

	public void setClassName(String value){
		setString(PROP_CLASS_NAME, value);
	}

	public List<String> getSubNavi(){
		return copyToStringList(getList(PROP_SUB_NAVI));
	}

	public void setSubNavi(List<String> value){
		setList(PROP_SUB_NAVI, copyFromStringList(value));
	}

	public List<String> getGuards(){
		return copyToStringList(getList(PROP_GUARDS));
	}

	public void setGuards(List<String> value){
		setList(PROP_GUARDS, copyFromStringList(value));
	}

	public String getInternalLink(){
		return getString(LINK_PROP_INTERNAL_LINK);
	}

	public void setInternalLink(String value){
		setString(LINK_PROP_INTERNAL_LINK, value);
	}

	public String getPageAlias(){
		return getString(LINK_PROP_PAGE_ALIAS);
	}

	public void setPageAlias(String value){
		setString(LINK_PROP_PAGE_ALIAS, value);
	}

	public String getAccessOperation(){
		return getString(LINK_PROP_ACCESS_OPERATION);
	}

	public void setAccessOperation(String value){
		setString(LINK_PROP_ACCESS_OPERATION, value);
	}


	public String toString(){
		String ret = "NaviItem ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "title: "+getTitle();
		ret += ", ";
		ret += "icon: "+getIcon();
		ret += ", ";
		ret += "externalLink: "+getExternalLink();
		ret += ", ";
		ret += "popup: "+getPopup();
		ret += ", ";
		ret += "className: "+getClassName();
		ret += ", ";
		ret += "subNavi: "+getSubNavi();
		ret += ", ";
		ret += "guards: "+getGuards();
		return ret;
	}

	public int getSubNaviSize(){
		return getList(PROP_SUB_NAVI).size();
	}

	public void addSubNaviElement(String item){
		getListPropertyAnyCase(PROP_SUB_NAVI).add(new StringProperty("" + item, item));
	} //method

	public void removeSubNaviElement(int index){
		getListProperty(PROP_SUB_NAVI).remove(index);
	} //method

	public void swapSubNaviElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_SUB_NAVI).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_SUB_NAVI).get(index2)).getString();
		((StringProperty)getList(PROP_SUB_NAVI).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_SUB_NAVI).get(index2)).setString(tmp1);
	} //method

	public String getSubNaviElement(int index){
		StringProperty p = (StringProperty)getList(PROP_SUB_NAVI).get(index);
		return p.getString();
	} //method

	public int getGuardsSize(){
		return getList(PROP_GUARDS).size();
	}

	public void addGuardsElement(String guard){
		getListPropertyAnyCase(PROP_GUARDS).add(new StringProperty("" + guard, guard));
	} //method

	public void removeGuardsElement(int index){
		getListProperty(PROP_GUARDS).remove(index);
	} //method

	public void swapGuardsElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_GUARDS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_GUARDS).get(index2)).getString();
		((StringProperty)getList(PROP_GUARDS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_GUARDS).get(index2)).setString(tmp1);
	} //method

	public String getGuardsElement(int index){
		StringProperty p = (StringProperty)getList(PROP_GUARDS).get(index);
		return p.getString();
	} //method


	public int compareTo(NaviItem comparable){
		return compareTo(comparable, NaviItemSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		NaviItemDocument anotherDoc = (NaviItemDocument) anotherComparable;
		switch(method){
			case NaviItemSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case NaviItemSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case NaviItemSortType.SORT_BY_TITLE:
				return BasicComparable.compareString(getTitle(), anotherDoc.getTitle());
			case NaviItemSortType.SORT_BY_ICON:
				return BasicComparable.compareString(getIcon(), anotherDoc.getIcon());
			case NaviItemSortType.SORT_BY_EXTERNALLINK:
				return BasicComparable.compareString(getExternalLink(), anotherDoc.getExternalLink());
			case NaviItemSortType.SORT_BY_POPUP:
				return BasicComparable.compareBoolean(getPopup(), anotherDoc.getPopup());
			case NaviItemSortType.SORT_BY_CLASSNAME:
				return BasicComparable.compareString(getClassName(), anotherDoc.getClassName());
			case NaviItemSortType.SORT_BY_INTERNALLINK:
				return BasicComparable.compareString(getInternalLink(), anotherDoc.getInternalLink());
			case NaviItemSortType.SORT_BY_PAGEALIAS:
				return BasicComparable.compareString(getPageAlias(), anotherDoc.getPageAlias());
			case NaviItemSortType.SORT_BY_ACCESSOPERATION:
				return BasicComparable.compareString(getAccessOperation(), anotherDoc.getAccessOperation());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "NaviItem";
	}

	public String getDefinedParentName(){
		return "ASSiteData";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getNameEN());
		footprint.append(getNameDE());
		footprint.append(getTitleEN());
		footprint.append(getTitleDE());
		footprint.append(getIcon());
		footprint.append(getExternalLink());
		footprint.append(getPopup());
		footprint.append(getClassName());
		footprint.append(getSubNavi());
		footprint.append(getGuards());
		footprint.append(getInternalLink());
		footprint.append(getPageAlias());
		footprint.append(getAccessOperation());
		return MD5Util.getMD5Hash(footprint);
	}
	public void copyLANG2LANG(String sourceLanguage, String destLanguage){
		if (sourceLanguage.equals("EN") && destLanguage.equals("DE"))
			copyEN2DE();
		if (sourceLanguage.equals("DE") && destLanguage.equals("EN"))
			copyDE2EN();
	}

	/**
	 * Copies all multilingual properties from language EN to language DE
	 */
	public void copyEN2DE(){
		setNameDE(getNameEN());
		setTitleDE(getTitleEN());
	}

	/**
	 * Copies all multilingual properties from language DE to language EN
	 */
	public void copyDE2EN(){
		setNameEN(getNameDE());
		setTitleEN(getTitleDE());
	}


	public boolean isMultilingualDisabledInstance(){
		try{
			return ((BooleanProperty)getInternalProperty(INT_PROPERTY_MULTILINGUAL_DISABLED)).getboolean();
		}catch(NoSuchPropertyException e){
			return false;
		}
	}

	public void setMultilingualDisabledInstance(boolean value){
		setInternalProperty(new BooleanProperty(INT_PROPERTY_MULTILINGUAL_DISABLED, value));
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof NaviItemDocument) && ((NaviItemDocument)o).getId().equals(getId()));
	}
}
