/**
 ********************************************************************************
 *** ScriptDocument.java                                                      ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.data;

import net.anotheria.asg.data.AbstractASGDocument;
import java.util.List;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;

public class ScriptDocument extends AbstractASGDocument implements Script, IComparable{

	public ScriptDocument() {
		super("");
	}

	public ScriptDocument(String id){
		super(id);
	}

	public ScriptDocument(ScriptDocument toClone){
		super(toClone);
	}

	ScriptDocument(ScriptBuilder builder){
		super("");
		setName(builder.name);
		setLink(builder.link);
		setContent(builder.content);
		setBrowserFiltering(builder.browserFiltering);
		setGuards(builder.guards);
		setFile(builder.file);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public String getLink(){
		return getString(PROP_LINK);
	}

	public void setLink(String value){
		setString(PROP_LINK, value);
	}

	public String getContent(){
		return getString(PROP_CONTENT);
	}

	public void setContent(String value){
		setString(PROP_CONTENT, value);
	}

	public String getBrowserFiltering(){
		return getString(PROP_BROWSER_FILTERING);
	}

	public void setBrowserFiltering(String value){
		setString(PROP_BROWSER_FILTERING, value);
	}

	public List<String> getGuards(){
		return copyToStringList(getList(PROP_GUARDS));
	}

	public void setGuards(List<String> value){
		setList(PROP_GUARDS, copyFromStringList(value));
	}

	public String getFile(){
		return getString(LINK_PROP_FILE);
	}

	public void setFile(String value){
		setString(LINK_PROP_FILE, value);
	}


	public String toString(){
		String ret = "Script ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "link: "+getLink();
		ret += ", ";
		ret += "content: "+getContent();
		ret += ", ";
		ret += "browserFiltering: "+getBrowserFiltering();
		ret += ", ";
		ret += "guards: "+getGuards();
		return ret;
	}

	public int getGuardsSize(){
		return getList(PROP_GUARDS).size();
	}

	public void addGuardsElement(String guard){
		getListPropertyAnyCase(PROP_GUARDS).add(new StringProperty("" + guard, guard));
	} //method

	public void removeGuardsElement(int index){
		getListProperty(PROP_GUARDS).remove(index);
	} //method

	public void swapGuardsElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_GUARDS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_GUARDS).get(index2)).getString();
		((StringProperty)getList(PROP_GUARDS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_GUARDS).get(index2)).setString(tmp1);
	} //method

	public String getGuardsElement(int index){
		StringProperty p = (StringProperty)getList(PROP_GUARDS).get(index);
		return p.getString();
	} //method


	public int compareTo(Script comparable){
		return compareTo(comparable, ScriptSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		ScriptDocument anotherDoc = (ScriptDocument) anotherComparable;
		switch(method){
			case ScriptSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case ScriptSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case ScriptSortType.SORT_BY_LINK:
				return BasicComparable.compareString(getLink(), anotherDoc.getLink());
			case ScriptSortType.SORT_BY_CONTENT:
				return BasicComparable.compareString(getContent(), anotherDoc.getContent());
			case ScriptSortType.SORT_BY_BROWSERFILTERING:
				return BasicComparable.compareString(getBrowserFiltering(), anotherDoc.getBrowserFiltering());
			case ScriptSortType.SORT_BY_FILE:
				return BasicComparable.compareString(getFile(), anotherDoc.getFile());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "Script";
	}

	public String getDefinedParentName(){
		return "ASSiteData";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getLink());
		footprint.append(getContent());
		footprint.append(getBrowserFiltering());
		footprint.append(getGuards());
		footprint.append(getFile());
		return MD5Util.getMD5Hash(footprint);
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof ScriptDocument) && ((ScriptDocument)o).getId().equals(getId()));
	}
}
