/**
 ********************************************************************************
 *** MultiOpUserDefsStatusAction.java                                         ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asuserdata.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asuserdata.data.UserDefFactory;
import net.anotheria.anosite.gen.asuserdata.data.UserDef;
import net.anotheria.anosite.gen.asuserdata.bean.StatusElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.asuserdata.bean.StatusQuickAddFB;
import net.anotheria.anosite.gen.asuserdata.data.RoleDef;
import net.anotheria.anosite.gen.asuserdata.data.RoleDefSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpUserDefsStatusAction extends BaseUserDefAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asuserdataUserDefStatusShow"))
			return asuserdataUserDefStatusShow(mapping, req, res);
		if (path.equals("asuserdataUserDefStatusAdd"))
			return asuserdataUserDefStatusAdd(mapping, req, res);
		if (path.equals("asuserdataUserDefStatusDelete"))
			return asuserdataUserDefStatusDelete(mapping, req, res);
		if (path.equals("asuserdataUserDefStatusMove"))
			return asuserdataUserDefStatusMove(mapping, req, res);
		if (path.equals("asuserdataUserDefStatusQuickAdd"))
			return asuserdataUserDefStatusQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand asuserdataUserDefStatusShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		UserDef userdef = getASUserDataService().getUserDef(id);
		addBeanToRequest(req, "ownerId", id);
		checkUserDefs(userdef, req);

		StatusElementFB form = new StatusElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(userdef.getId());
		addBeanToRequest(req, "asuserdataUserDefStatusElementForm", form);

		StatusQuickAddFB quickAddForm = new StatusQuickAddFB() ;
		quickAddForm.setOwnerId(userdef.getId());
		addBeanToRequest(req, "asuserdataUserDefStatusQuickAddForm", quickAddForm);


		//link statusLink to ASUserData.RoleDef
		List<RoleDef> roledefs = getASUserDataService().getRoleDefs(new RoleDefSortType(RoleDefSortType.SORT_BY_NAME));
		List<LabelValueBean> roledefsValues = new ArrayList<LabelValueBean>(roledefs.size());
		for (int i=0; i<roledefs.size(); i++){
			net.anotheria.anosite.gen.asuserdata.data.RoleDef tmp_roledef = (net.anotheria.anosite.gen.asuserdata.data.RoleDef) roledefs.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_roledef.getId(), tmp_roledef.getName()+" ["+tmp_roledef.getId()+"]" );
			roledefsValues.add(bean);
		}
		addBeanToRequest(req, "statuslinkValuesCollection", roledefsValues);
		// generate list ...
		int size = userdef.getStatusSize();
		List<StatusElementFB> beans = new ArrayList<StatusElementFB>(size);
		for (int i=0; i<size; i++){
			String value = userdef.getStatusElement(i);
			StatusElementFB bean = new StatusElementFB();
			bean.setOwnerId(userdef.getId());
			bean.setPosition(i);
			bean.setStatusLink(value);
			try{
				RoleDef tmp_roledef = getASUserDataService().getRoleDef(value);
				bean.setDescription(tmp_roledef.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand asuserdataUserDefStatusDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		UserDef userdefCurr = getASUserDataService().getUserDef(id);
		canUpdateUserDefs(userdefCurr, req);
		checkUserDefs(userdefCurr, req);
		int position = getIntParameter(req, "pPosition");
		UserDef userdef = getASUserDataService().getUserDef(id);
		userdef.removeStatusElement(position);
		getASUserDataService().updateUserDef(userdef);
		return asuserdataUserDefStatusShow(mapping, req, res);
	}

	public ActionCommand asuserdataUserDefStatusMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		UserDef userdef = getASUserDataService().getUserDef(id);
		canUpdateUserDefs(userdef, req);
		checkUserDefs(userdef, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(userdef, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(userdef, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(userdef, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(userdef, position);
		return asuserdataUserDefStatusShow(mapping, req, res);
	}

	private void moveUp(UserDef userdef, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		userdef.swapStatusElement(position, position-1);
		getASUserDataService().updateUserDef(userdef);
	}

	private void moveTop(UserDef userdef, int position) throws ASGRuntimeException {
		List<String> targetList = userdef.getStatus();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		userdef.setStatus(targetList);
		getASUserDataService().updateUserDef(userdef);
	}

	private void moveDown(UserDef userdef, int position) throws ASGRuntimeException {
		if (position<userdef.getStatusSize()-1){
			userdef.swapStatusElement(position, position+1);
			getASUserDataService().updateUserDef(userdef);
		}
	}

	private void moveBottom(UserDef userdef, int position) throws ASGRuntimeException {
		List<String> targetList = userdef.getStatus();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		userdef.setStatus(targetList);
		getASUserDataService().updateUserDef(userdef);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand asuserdataUserDefStatusAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		StatusElementFB form = new StatusElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		UserDef userdef;
		userdef = getASUserDataService().getUserDef(id);
		canUpdateUserDefs(userdef, req);
		checkUserDefs(userdef, req);
		userdef.addStatusElement(form.getStatusLink());
		getASUserDataService().updateUserDef(userdef);
		return asuserdataUserDefStatusShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand asuserdataUserDefStatusQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		StatusQuickAddFB form = new StatusQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		UserDef userdef;
		userdef = getASUserDataService().getUserDef(id);
		canUpdateUserDefs(userdef, req);
		checkUserDefs(userdef, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				userdef.addStatusElement(""+i);
			}
		}
		getASUserDataService().updateUserDef(userdef);
		return asuserdataUserDefStatusShow(mapping, req, res);
	}

}
