/**
 ********************************************************************************
 *** UserDefRestResource.java                                                 ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asuserdata.rest;

import java.util.List;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.codehaus.jettison.json.JSONArray;
import net.anotheria.anosite.gen.shared.util.ParserUtilService;
import net.anotheria.anosite.gen.asuserdata.data.UserDef;
import net.anotheria.anosite.gen.asuserdata.service.IASUserDataService;
import net.anotheria.anosite.gen.asuserdata.service.ASUserDataServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path("/userdef")
public class UserDefRestResource{

	private static final Logger LOGGER = LoggerFactory.getLogger(UserDefRestResource.class);
	private IASUserDataService asuserdataService;
	private Gson gson;
	private GsonBuilder builder;

	public UserDefRestResource() {
		builder = new GsonBuilder();
		builder.setPrettyPrinting();
		gson = builder.create();

		try {
			asuserdataService = MetaFactory.get(IASUserDataService.class);
		}catch(MetaFactoryException e){
			LOGGER.error("Unable to create service: I ASUserDataService", e);
			throw new RuntimeException("Unable to create service", e);
		}
	}

	@GET
	@Produces("application/json;charset=utf-8")
	public Response getObjects() {

		List<UserDef> result = null;
		try {
			result = asuserdataService.getUserDefs();
		}catch(ASUserDataServiceException e){
			LOGGER.error("Unable to getUserDefs", e);
			return Response.status(500).build();
		}

		return Response.status(201).entity(gson.toJson(result)).build();
	}

	@GET
	@Path("/{id}")
	@Produces("application/json;charset=utf-8")
	public Response getObject(@PathParam("id") String id) {

		UserDef result = null;
		try {
			result = asuserdataService.getUserDef(id);
		}catch(ASUserDataServiceException e){
			LOGGER.error("Unable to getUserDef by id", e);
			return Response.status(500).build();
		}

		return Response.status(201).entity(gson.toJson(result)).build();
	}

	@POST
	@Consumes("application/json;charset=utf-8")
	public Response createTransferredObject(String input) {

		try {
			JSONArray array = new JSONArray(input);
			ParserUtilService.getInstance().addToQueueParsingDocuments(array);
		}catch(Exception e){
			LOGGER.error("Unable to parsing transferred objects", e);
			return Response.status(500).build();
		}
		return Response.status(201).build();
	}
}
