/**
 ********************************************************************************
 *** MultiOpBoxsSubboxesAction.java                                           ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aswebdata.data.BoxFactory;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.gen.aswebdata.bean.SubboxesElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.aswebdata.bean.SubboxesQuickAddFB;
import net.anotheria.anosite.gen.aswebdata.data.BoxSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpBoxsSubboxesAction extends BaseBoxAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("aswebdataBoxSubboxesShow"))
			return aswebdataBoxSubboxesShow(mapping, req, res);
		if (path.equals("aswebdataBoxSubboxesAdd"))
			return aswebdataBoxSubboxesAdd(mapping, req, res);
		if (path.equals("aswebdataBoxSubboxesDelete"))
			return aswebdataBoxSubboxesDelete(mapping, req, res);
		if (path.equals("aswebdataBoxSubboxesMove"))
			return aswebdataBoxSubboxesMove(mapping, req, res);
		if (path.equals("aswebdataBoxSubboxesQuickAdd"))
			return aswebdataBoxSubboxesQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand aswebdataBoxSubboxesShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Box box = getASWebDataService().getBox(id);
		addBeanToRequest(req, "ownerId", id);
		checkBoxs(box, req);

		SubboxesElementFB form = new SubboxesElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(box.getId());
		addBeanToRequest(req, "aswebdataBoxSubboxesElementForm", form);

		SubboxesQuickAddFB quickAddForm = new SubboxesQuickAddFB() ;
		quickAddForm.setOwnerId(box.getId());
		addBeanToRequest(req, "aswebdataBoxSubboxesQuickAddForm", quickAddForm);


		//link subbox to Box
		List<Box> boxs = getASWebDataService().getBoxs(new BoxSortType(BoxSortType.SORT_BY_NAME));
		List<LabelValueBean> boxsValues = new ArrayList<LabelValueBean>(boxs.size());
		for (int i=0; i<boxs.size(); i++){
			net.anotheria.anosite.gen.aswebdata.data.Box tmp_box = (net.anotheria.anosite.gen.aswebdata.data.Box) boxs.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_box.getId(), tmp_box.getName()+" ["+tmp_box.getId()+"]" );
			boxsValues.add(bean);
		}
		addBeanToRequest(req, "subboxValuesCollection", boxsValues);
		// generate list ...
		int size = box.getSubboxesSize();
		List<SubboxesElementFB> beans = new ArrayList<SubboxesElementFB>(size);
		for (int i=0; i<size; i++){
			String value = box.getSubboxesElement(i);
			SubboxesElementFB bean = new SubboxesElementFB();
			bean.setOwnerId(box.getId());
			bean.setPosition(i);
			bean.setSubbox(value);
			try{
				Box tmp_box = getASWebDataService().getBox(value);
				bean.setDescription(tmp_box.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand aswebdataBoxSubboxesDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Box boxCurr = getASWebDataService().getBox(id);
		canUpdateBoxs(boxCurr, req);
		checkBoxs(boxCurr, req);
		int position = getIntParameter(req, "pPosition");
		Box box = getASWebDataService().getBox(id);
		box.removeSubboxesElement(position);
		getASWebDataService().updateBox(box);
		return aswebdataBoxSubboxesShow(mapping, req, res);
	}

	public ActionCommand aswebdataBoxSubboxesMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Box box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(box, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(box, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(box, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(box, position);
		return aswebdataBoxSubboxesShow(mapping, req, res);
	}

	private void moveUp(Box box, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		box.swapSubboxesElement(position, position-1);
		getASWebDataService().updateBox(box);
	}

	private void moveTop(Box box, int position) throws ASGRuntimeException {
		List<String> targetList = box.getSubboxes();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		box.setSubboxes(targetList);
		getASWebDataService().updateBox(box);
	}

	private void moveDown(Box box, int position) throws ASGRuntimeException {
		if (position<box.getSubboxesSize()-1){
			box.swapSubboxesElement(position, position+1);
			getASWebDataService().updateBox(box);
		}
	}

	private void moveBottom(Box box, int position) throws ASGRuntimeException {
		List<String> targetList = box.getSubboxes();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		box.setSubboxes(targetList);
		getASWebDataService().updateBox(box);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand aswebdataBoxSubboxesAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		SubboxesElementFB form = new SubboxesElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Box box;
		box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		box.addSubboxesElement(form.getSubbox());
		getASWebDataService().updateBox(box);
		return aswebdataBoxSubboxesShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand aswebdataBoxSubboxesQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		SubboxesQuickAddFB form = new SubboxesQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Box box;
		box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				box.addSubboxesElement(""+i);
			}
		}
		getASWebDataService().updateBox(box);
		return aswebdataBoxSubboxesShow(mapping, req, res);
	}

}
