/**
 ********************************************************************************
 *** MultiOpDialogBoxsAction.java                                             ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import net.anotheria.util.NumberUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.aswebdata.data.BoxFactory;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.gen.aswebdata.bean.EditBoxFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import net.anotheria.asg.data.MultilingualObject;

public class MultiOpDialogBoxsAction extends BaseBoxAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("aswebdataBoxDelete"))
			return aswebdataBoxDelete(mapping, req, res);
		if (path.equals("aswebdataBoxDuplicate"))
			return aswebdataBoxDuplicate(mapping, req, res);
		if (path.equals("aswebdataBoxUpdate"))
			return aswebdataBoxUpdate(mapping, req, res);
		if (path.equals("aswebdataBoxClose"))
			return aswebdataBoxClose(mapping, req, res);
		if (path.equals("aswebdataBoxCopyLang"))
			return aswebdataBoxCopyLang(mapping, req, res);
		if (path.equals("aswebdataBoxSwitchMultilang"))
			return aswebdataBoxSwitchMultilang(mapping, req, res);
		if (path.equals("aswebdataBoxLock"))
			return aswebdataBoxLock(mapping, req, res);
		if (path.equals("aswebdataBoxUnLock"))
			return aswebdataBoxUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand aswebdataBoxDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			Box boxCurr = getASWebDataService().getBox(id);
			if (boxCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)boxCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASWebDataService().deleteBox(id);
		}
		res.sendRedirect("aswebdataBoxShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand aswebdataBoxDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		Box boxSrc = getASWebDataService().getBox(id);
		Box boxDest = BoxFactory.createBox(boxSrc);








		Box boxCreated = getASWebDataService().createBox(boxDest);
		res.sendRedirect("aswebdataBoxEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+boxCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand aswebdataBoxUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditBoxFB form = new EditBoxFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		Box box = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		box = (Box)getASWebDataService().getBox(form.getId()).clone();
	}else{
		box = BoxFactory.createBox();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	box.setName(form.getName());
	box.setType(form.getType());
	box.setHandler(form.getHandler());
	// skipped container mediaLinks
	// skipped container scripts
	// skipped container localizations
	// skipped container subboxes
	box.setCssClass(form.getCssClass());
	box.setContentEN(form.getContentEN());
	box.setContentDE(form.getContentDE());
	box.setParameter1(form.getParameter1());
	box.setParameter2(form.getParameter2());
	box.setParameter3(form.getParameter3());
	box.setParameter4(form.getParameter4());
	box.setParameter5(form.getParameter5());
	box.setParameter6(form.getParameter6());
	box.setParameter7(form.getParameter7());
	box.setParameter8(form.getParameter8());
	box.setParameter9(form.getParameter9());
	box.setParameter10(form.getParameter10());
	// skipped container guards
	// skipped container attributes
	box.setAccessOperation(form.getAccessOperation());
	box.setFeature(form.getFeature());

	Box updatedCopy = null;
	if (create){
		updatedCopy = getASWebDataService().createBox(box);
	}else{
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		updatedCopy = getASWebDataService().updateBox(box);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("aswebdataBoxEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(box, req);
		res.sendRedirect("aswebdataBoxShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(Box box, HttpServletRequest req) throws Exception{
	if(((LockableObject)box).isLocked())
		unLockBoxs(box, req, false);
}

public ActionCommand aswebdataBoxCopyLang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String sourceLanguage = req.getParameter("pSrcLang");
	if (sourceLanguage==null || sourceLanguage.length()==0)
		throw new RuntimeException("No source language");

	String destLanguage = req.getParameter("pDestLang");
	if (destLanguage==null || destLanguage.length()==0)
		throw new RuntimeException("No destination language");

	String id = getStringParameter(req, PARAM_ID);
	Box box = getASWebDataService().getBox(id);
	canUpdateBoxs(box, req);
	checkBoxs(box, req);
	box.copyLANG2LANG(sourceLanguage, destLanguage);
	getASWebDataService().updateBox(box);
	res.sendRedirect("aswebdataBoxEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand aswebdataBoxSwitchMultilang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	String value = getStringParameter(req, "value");
	Box box = getASWebDataService().getBox(id);
	canUpdateBoxs(box, req);
	checkBoxs(box, req);
	((MultilingualObject)box).setMultilingualDisabledInstance(Boolean.valueOf(value));
	getASWebDataService().updateBox(box);
	res.sendRedirect("aswebdataBoxEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand aswebdataBoxLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Box boxCurr = id != null && !id.equals("") ? getASWebDataService().getBox(id) : null;
	if(boxCurr != null && boxCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)boxCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockBoxs(boxCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, boxCurr));
	return null;
}

public ActionCommand aswebdataBoxUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Box boxCurr = id != null && !id.equals("") ? getASWebDataService().getBox(id) : null;
	if(boxCurr != null && boxCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)boxCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockBoxs(boxCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, boxCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, Box item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "aswebdataBoxShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "aswebdataBoxEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "aswebdataBoxShow?ts="+System.currentTimeMillis();
}

public ActionCommand aswebdataBoxClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Box boxCurr = id != null && !id.equals("") ? getASWebDataService().getBox(id) : null;
	if(boxCurr != null && boxCurr instanceof LockableObject && ((LockableObject)boxCurr).isLocked()) 
		unLockBoxs(boxCurr, req, false);
	res.sendRedirect("aswebdataBoxShow?ts="+System.currentTimeMillis());
	return null;
}

}
