/**
 ********************************************************************************
 *** MultiOpPagexsScriptsAction.java                                          ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aswebdata.data.PagexFactory;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.bean.ScriptsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.aswebdata.bean.ScriptsQuickAddFB;
import net.anotheria.anosite.gen.assitedata.data.Script;
import net.anotheria.anosite.gen.assitedata.data.ScriptSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpPagexsScriptsAction extends BasePagexAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("aswebdataPagexScriptsShow"))
			return aswebdataPagexScriptsShow(mapping, req, res);
		if (path.equals("aswebdataPagexScriptsAdd"))
			return aswebdataPagexScriptsAdd(mapping, req, res);
		if (path.equals("aswebdataPagexScriptsDelete"))
			return aswebdataPagexScriptsDelete(mapping, req, res);
		if (path.equals("aswebdataPagexScriptsMove"))
			return aswebdataPagexScriptsMove(mapping, req, res);
		if (path.equals("aswebdataPagexScriptsQuickAdd"))
			return aswebdataPagexScriptsQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand aswebdataPagexScriptsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Pagex pagex = getASWebDataService().getPagex(id);
		addBeanToRequest(req, "ownerId", id);
		checkPagexs(pagex, req);

		ScriptsElementFB form = new ScriptsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(pagex.getId());
		addBeanToRequest(req, "aswebdataPagexScriptsElementForm", form);

		ScriptsQuickAddFB quickAddForm = new ScriptsQuickAddFB() ;
		quickAddForm.setOwnerId(pagex.getId());
		addBeanToRequest(req, "aswebdataPagexScriptsQuickAddForm", quickAddForm);


		//link script to ASSiteData.Script
		List<Script> scripts = getASSiteDataService().getScripts(new ScriptSortType(ScriptSortType.SORT_BY_NAME));
		List<LabelValueBean> scriptsValues = new ArrayList<LabelValueBean>(scripts.size());
		for (int i=0; i<scripts.size(); i++){
			net.anotheria.anosite.gen.assitedata.data.Script tmp_script = (net.anotheria.anosite.gen.assitedata.data.Script) scripts.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_script.getId(), tmp_script.getName()+" ["+tmp_script.getId()+"]" );
			scriptsValues.add(bean);
		}
		addBeanToRequest(req, "scriptValuesCollection", scriptsValues);
		// generate list ...
		int size = pagex.getScriptsSize();
		List<ScriptsElementFB> beans = new ArrayList<ScriptsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = pagex.getScriptsElement(i);
			ScriptsElementFB bean = new ScriptsElementFB();
			bean.setOwnerId(pagex.getId());
			bean.setPosition(i);
			bean.setScript(value);
			try{
				Script tmp_script = getASSiteDataService().getScript(value);
				bean.setDescription(tmp_script.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand aswebdataPagexScriptsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Pagex pagexCurr = getASWebDataService().getPagex(id);
		canUpdatePagexs(pagexCurr, req);
		checkPagexs(pagexCurr, req);
		int position = getIntParameter(req, "pPosition");
		Pagex pagex = getASWebDataService().getPagex(id);
		pagex.removeScriptsElement(position);
		getASWebDataService().updatePagex(pagex);
		return aswebdataPagexScriptsShow(mapping, req, res);
	}

	public ActionCommand aswebdataPagexScriptsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Pagex pagex = getASWebDataService().getPagex(id);
		canUpdatePagexs(pagex, req);
		checkPagexs(pagex, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(pagex, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(pagex, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(pagex, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(pagex, position);
		return aswebdataPagexScriptsShow(mapping, req, res);
	}

	private void moveUp(Pagex pagex, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		pagex.swapScriptsElement(position, position-1);
		getASWebDataService().updatePagex(pagex);
	}

	private void moveTop(Pagex pagex, int position) throws ASGRuntimeException {
		List<String> targetList = pagex.getScripts();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		pagex.setScripts(targetList);
		getASWebDataService().updatePagex(pagex);
	}

	private void moveDown(Pagex pagex, int position) throws ASGRuntimeException {
		if (position<pagex.getScriptsSize()-1){
			pagex.swapScriptsElement(position, position+1);
			getASWebDataService().updatePagex(pagex);
		}
	}

	private void moveBottom(Pagex pagex, int position) throws ASGRuntimeException {
		List<String> targetList = pagex.getScripts();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		pagex.setScripts(targetList);
		getASWebDataService().updatePagex(pagex);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand aswebdataPagexScriptsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		ScriptsElementFB form = new ScriptsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Pagex pagex;
		pagex = getASWebDataService().getPagex(id);
		canUpdatePagexs(pagex, req);
		checkPagexs(pagex, req);
		pagex.addScriptsElement(form.getScript());
		getASWebDataService().updatePagex(pagex);
		return aswebdataPagexScriptsShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand aswebdataPagexScriptsQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		ScriptsQuickAddFB form = new ScriptsQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Pagex pagex;
		pagex = getASWebDataService().getPagex(id);
		canUpdatePagexs(pagex, req);
		checkPagexs(pagex, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				pagex.addScriptsElement(""+i);
			}
		}
		getASWebDataService().updatePagex(pagex);
		return aswebdataPagexScriptsShow(mapping, req, res);
	}

}
