/**
 ********************************************************************************
 *** ShowPagexsAction.java                                                    ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.bean.PagexListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.aswebdata.bean.PagexListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowPagexsAction extends BasePagexAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"Pagex";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"Pagex";
	private static Logger log = LoggerFactory.getLogger(ShowPagexsAction.class);
	private Sorter<PagexListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;
	private IAttributeDecorator localizedNameDecorator;
	private IAttributeDecorator c1Decorator;
	private IAttributeDecorator c2Decorator;
	private IAttributeDecorator c3Decorator;
	private IAttributeDecorator headerDecorator;
	private IAttributeDecorator footerDecorator;
	private IAttributeDecorator mediaLinksDecorator;
	private IAttributeDecorator scriptsDecorator;
	private IAttributeDecorator localizationsDecorator;

	private DocumentFilter nameFilterAZ;
	private DocumentFilter AnyFilterMissingTranslation;

	public ShowPagexsAction(){
		sorter = new QuickSorter<PagexListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
			localizedNameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
			c1Decorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.BoxCMS2Decorator").newInstance();
			c2Decorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.BoxCMS2Decorator").newInstance();
			c3Decorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.BoxCMS2Decorator").newInstance();
			headerDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.BoxCMS2Decorator").newInstance();
			footerDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.BoxCMS2Decorator").newInstance();
			mediaLinksDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.MediaLinksListCMS2Decorator").newInstance();
			scriptsDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.ScriptsListCMS2Decorator").newInstance();
			localizationsDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.LocalizationsListCMS2Decorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
			AnyFilterMissingTranslation = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.MissingAnyTranslationFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		String filterParameter1 = "";
		try{ 
			filterParameter1 = getStringParameter(req, "pFilter1");
			addBeanToSession(req, SA_FILTER+"1", filterParameter1);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter1 = (String)getBeanFromSession(req, SA_FILTER+"1");
			if (filterParameter1==null)
				filterParameter1 = "";
		}
		req.setAttribute("currentFilterParameter1", filterParameter1);

		int sortMethod = PagexListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = PagexListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		PagexListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new PagexListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (PagexListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new PagexListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<Pagex> _unfiltered_pagexs = getASWebDataService().getPagexs();
		List<Pagex> pagexs = new ArrayList<Pagex>();
		for (int i=0; i<_unfiltered_pagexs.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_pagexs.get(i), "name", filterParameter0));
			mayPass = mayPass && (AnyFilterMissingTranslation.mayPass(_unfiltered_pagexs.get(i), "Any", filterParameter1));
			if (mayPass)
				pagexs.add(_unfiltered_pagexs.get(i));
		}
		List<PagexListItemBean> beans = new ArrayList<PagexListItemBean>(pagexs.size());
		for (Pagex pagex : pagexs){
			checkPagexs(pagex, req);
			PagexListItemBean bean = makePagexListItemBean(pagex);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "pagexs", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		addBeanToRequest(req, "AnyFilterMissingTranslation", AnyFilterMissingTranslation.getTriggerer("Any"));
		return mapping.success();
	}

	protected PagexListItemBean makePagexListItemBean(Pagex pagex) {
		PagexListItemBean bean = new PagexListItemBean();
		bean.setPlainId(pagex.getId());
		bean.setIdForSorting(pagex.getId());
		bean.setId(idDecorator.decorate(pagex, "id", "3"));
		bean.setNameForSorting(pagex.getName());
		bean.setName(nameDecorator.decorate(pagex, "name", "null"));
		bean.setLocalizedNameForSortingEN(pagex.getLocalizedNameEN());
		bean.setLocalizedNameEN(localizedNameDecorator.decorate(pagex, "localizedName_EN", "null"));
		bean.setLocalizedNameForSortingDE(pagex.getLocalizedNameDE());
		bean.setLocalizedNameDE(localizedNameDecorator.decorate(pagex, "localizedName_DE", "null"));
		bean.setTemplate(pagex.getTemplate());
		bean.setC1ForSorting(pagex.getC1());
		bean.setC1(c1Decorator.decorate(pagex, "c1", "null"));
		bean.setC2ForSorting(pagex.getC2());
		bean.setC2(c2Decorator.decorate(pagex, "c2", "null"));
		bean.setC3ForSorting(pagex.getC3());
		bean.setC3(c3Decorator.decorate(pagex, "c3", "null"));
		bean.setHeaderForSorting(pagex.getHeader());
		bean.setHeader(headerDecorator.decorate(pagex, "header", "null"));
		bean.setFooterForSorting(pagex.getFooter());
		bean.setFooter(footerDecorator.decorate(pagex, "footer", "null"));
		bean.setMediaLinksForSorting(pagex.getMediaLinks());
		bean.setMediaLinks(mediaLinksDecorator.decorate(pagex, "mediaLinks", "null"));
		bean.setScriptsForSorting(pagex.getScripts());
		bean.setScripts(scriptsDecorator.decorate(pagex, "scripts", "null"));
		bean.setLocalizationsForSorting(pagex.getLocalizations());
		bean.setLocalizations(localizationsDecorator.decorate(pagex, "localizations", "null"));
		bean.setHttpsonly(pagex.getHttpsonly());
		bean.setLocked(((LockableObject)pagex).isLocked());
		bean.setLockerId(((LockableObject)pagex).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)pagex).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)pagex).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(pagex.getLastUpdateTimestamp()));
		return bean;
	}
}
