/**
 ********************************************************************************
 *** IASWebDataService.java                                                   ***
 *** Generator: net.anotheria.asg.generator.model.ServiceGenerator            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.service;

import java.util.List;
import net.anotheria.util.sorter.SortType;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.gen.aswebdata.data.Attribute;
import java.util.Set;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.slicer.Segment;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.asg.service.ASGService;

public interface IASWebDataService extends ASGService{

// Generated by: class net.anotheria.asg.generator.model.ServiceGenerator.generateInterface

	/**
	 * Returns all Pagexs objects stored.
	 */
	List<Pagex> getPagexs() throws ASWebDataServiceException;

	/**
	 * Returns all Pagexs objects sorted by given sortType.
	 */
	List<Pagex> getPagexs(SortType sortType) throws ASWebDataServiceException;

	/**
	 * Deletes a Pagex object by id.
	 */
	void deletePagex(String id) throws ASWebDataServiceException;

	/**
	 * Deletes a Pagex object.
	 */
	void deletePagex(Pagex pagex) throws ASWebDataServiceException;

	/**
	 * Deletes multiple Pagex object.
	 */
	void deletePagexs(List<Pagex> list) throws ASWebDataServiceException;

	/**
	 * Returns the Pagex object with the specified id.
	 */
	Pagex getPagex(String id) throws ASWebDataServiceException;

	/**
	 * Imports a new Pagex object.
	 * Returns the created version.
	 */
	Pagex importPagex(Pagex pagex) throws ASWebDataServiceException;

	/**
	 * Imports multiple new  Pagex object.
	 * Returns the created versions.
	 */
	List<Pagex> importPagexs(List<Pagex> list) throws ASWebDataServiceException;

	/**
	 * Creates a new Pagex object.
	 * Returns the created version.
	 */
	Pagex createPagex(Pagex pagex) throws ASWebDataServiceException;

	/**
	 * Creates multiple new Pagex objects.
	 * Returns the created versions.
	 */
	List<Pagex> createPagexs(List<Pagex> list) throws ASWebDataServiceException;

	/**
	 * Updates a Pagex object.
	 * Returns the updated version.
	 */
	Pagex updatePagex(Pagex pagex) throws ASWebDataServiceException;

	/**
	 * Updates multiple Pagex objects.
	 * Returns the updated versions.
	 */
	List<Pagex> updatePagexs(List<Pagex> list) throws ASWebDataServiceException;

	/**
	 * Returns all Pagex objects, where property with given name equals object.
	 */
	List<Pagex> getPagexsByProperty(String propertyName, Object value) throws ASWebDataServiceException;

	/**
	 * Returns all Pagex objects, where property with given name equals object, sorted.
	 */
	List<Pagex> getPagexsByProperty(String propertyName, Object value, SortType sortType) throws ASWebDataServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnPagexs(DocumentQuery query) throws ASWebDataServiceException;

	/**
	 * Returns all Pagex objects, where property matches.
	 */
	List<Pagex> getPagexsByProperty(QueryProperty... property) throws ASWebDataServiceException;

	/**
	 * Returns all Pagex objects, where property matches, sorted.
	 */
	List<Pagex> getPagexsByProperty(SortType sortType, QueryProperty... property) throws ASWebDataServiceException;

	/**
	 * Returns all Pagexs count.
	 */
	int getPagexsCount() throws ASWebDataServiceException;

	/**
	 * Returns Pagexs objects segment.
	 */
	List<Pagex> getPagexs(Segment aSegment) throws ASWebDataServiceException;

	/**
	 * Returns Pagex objects segment, where property matches.
	 */
	List<Pagex> getPagexsByProperty(Segment aSegment, QueryProperty... aProperty) throws ASWebDataServiceException;

	/**
	 * Returns Pagex objects segment, where property matches, sorted.
	 */
	List<Pagex> getPagexsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASWebDataServiceException;

	/**
	 * In all documents of type Pagex copies all multilingual fields from sourceLanguage to targetLanguage.
	 */
	void copyMultilingualAttributesInAllPagexs(String sourceLanguage, String targetLanguage) throws ASWebDataServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportPagexsToXML(List<Pagex> listPagexs)  throws ASWebDataServiceException;
	/**
	 * creates an xml element with selected contained data but only selected languages in multilingual attributes
	 */
	XMLNode exportPagexsToXML(String[] languages,List<Pagex> listPagexs) throws ASWebDataServiceException;

	/**
	 * Create json object list dependencies for this Pagex document.
	 */
	void fetchPagex(String id, Set<String> addedDocuments, JSONArray data) throws ASWebDataServiceException;

	/**
	 * Returns all Boxs objects stored.
	 */
	List<Box> getBoxs() throws ASWebDataServiceException;

	/**
	 * Returns all Boxs objects sorted by given sortType.
	 */
	List<Box> getBoxs(SortType sortType) throws ASWebDataServiceException;

	/**
	 * Deletes a Box object by id.
	 */
	void deleteBox(String id) throws ASWebDataServiceException;

	/**
	 * Deletes a Box object.
	 */
	void deleteBox(Box box) throws ASWebDataServiceException;

	/**
	 * Deletes multiple Box object.
	 */
	void deleteBoxs(List<Box> list) throws ASWebDataServiceException;

	/**
	 * Returns the Box object with the specified id.
	 */
	Box getBox(String id) throws ASWebDataServiceException;

	/**
	 * Imports a new Box object.
	 * Returns the created version.
	 */
	Box importBox(Box box) throws ASWebDataServiceException;

	/**
	 * Imports multiple new  Box object.
	 * Returns the created versions.
	 */
	List<Box> importBoxs(List<Box> list) throws ASWebDataServiceException;

	/**
	 * Creates a new Box object.
	 * Returns the created version.
	 */
	Box createBox(Box box) throws ASWebDataServiceException;

	/**
	 * Creates multiple new Box objects.
	 * Returns the created versions.
	 */
	List<Box> createBoxs(List<Box> list) throws ASWebDataServiceException;

	/**
	 * Updates a Box object.
	 * Returns the updated version.
	 */
	Box updateBox(Box box) throws ASWebDataServiceException;

	/**
	 * Updates multiple Box objects.
	 * Returns the updated versions.
	 */
	List<Box> updateBoxs(List<Box> list) throws ASWebDataServiceException;

	/**
	 * Returns all Box objects, where property with given name equals object.
	 */
	List<Box> getBoxsByProperty(String propertyName, Object value) throws ASWebDataServiceException;

	/**
	 * Returns all Box objects, where property with given name equals object, sorted.
	 */
	List<Box> getBoxsByProperty(String propertyName, Object value, SortType sortType) throws ASWebDataServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnBoxs(DocumentQuery query) throws ASWebDataServiceException;

	/**
	 * Returns all Box objects, where property matches.
	 */
	List<Box> getBoxsByProperty(QueryProperty... property) throws ASWebDataServiceException;

	/**
	 * Returns all Box objects, where property matches, sorted.
	 */
	List<Box> getBoxsByProperty(SortType sortType, QueryProperty... property) throws ASWebDataServiceException;

	/**
	 * Returns all Boxs count.
	 */
	int getBoxsCount() throws ASWebDataServiceException;

	/**
	 * Returns Boxs objects segment.
	 */
	List<Box> getBoxs(Segment aSegment) throws ASWebDataServiceException;

	/**
	 * Returns Box objects segment, where property matches.
	 */
	List<Box> getBoxsByProperty(Segment aSegment, QueryProperty... aProperty) throws ASWebDataServiceException;

	/**
	 * Returns Box objects segment, where property matches, sorted.
	 */
	List<Box> getBoxsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASWebDataServiceException;

	/**
	 * In all documents of type Box copies all multilingual fields from sourceLanguage to targetLanguage.
	 */
	void copyMultilingualAttributesInAllBoxs(String sourceLanguage, String targetLanguage) throws ASWebDataServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportBoxsToXML(List<Box> listBoxs)  throws ASWebDataServiceException;
	/**
	 * creates an xml element with selected contained data but only selected languages in multilingual attributes
	 */
	XMLNode exportBoxsToXML(String[] languages,List<Box> listBoxs) throws ASWebDataServiceException;

	/**
	 * Create json object list dependencies for this Box document.
	 */
	void fetchBox(String id, Set<String> addedDocuments, JSONArray data) throws ASWebDataServiceException;

	/**
	 * Returns all Attributes objects stored.
	 */
	List<Attribute> getAttributes() throws ASWebDataServiceException;

	/**
	 * Returns all Attributes objects sorted by given sortType.
	 */
	List<Attribute> getAttributes(SortType sortType) throws ASWebDataServiceException;

	/**
	 * Deletes a Attribute object by id.
	 */
	void deleteAttribute(String id) throws ASWebDataServiceException;

	/**
	 * Deletes a Attribute object.
	 */
	void deleteAttribute(Attribute attribute) throws ASWebDataServiceException;

	/**
	 * Deletes multiple Attribute object.
	 */
	void deleteAttributes(List<Attribute> list) throws ASWebDataServiceException;

	/**
	 * Returns the Attribute object with the specified id.
	 */
	Attribute getAttribute(String id) throws ASWebDataServiceException;

	/**
	 * Imports a new Attribute object.
	 * Returns the created version.
	 */
	Attribute importAttribute(Attribute attribute) throws ASWebDataServiceException;

	/**
	 * Imports multiple new  Attribute object.
	 * Returns the created versions.
	 */
	List<Attribute> importAttributes(List<Attribute> list) throws ASWebDataServiceException;

	/**
	 * Creates a new Attribute object.
	 * Returns the created version.
	 */
	Attribute createAttribute(Attribute attribute) throws ASWebDataServiceException;

	/**
	 * Creates multiple new Attribute objects.
	 * Returns the created versions.
	 */
	List<Attribute> createAttributes(List<Attribute> list) throws ASWebDataServiceException;

	/**
	 * Updates a Attribute object.
	 * Returns the updated version.
	 */
	Attribute updateAttribute(Attribute attribute) throws ASWebDataServiceException;

	/**
	 * Updates multiple Attribute objects.
	 * Returns the updated versions.
	 */
	List<Attribute> updateAttributes(List<Attribute> list) throws ASWebDataServiceException;

	/**
	 * Returns all Attribute objects, where property with given name equals object.
	 */
	List<Attribute> getAttributesByProperty(String propertyName, Object value) throws ASWebDataServiceException;

	/**
	 * Returns all Attribute objects, where property with given name equals object, sorted.
	 */
	List<Attribute> getAttributesByProperty(String propertyName, Object value, SortType sortType) throws ASWebDataServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnAttributes(DocumentQuery query) throws ASWebDataServiceException;

	/**
	 * Returns all Attribute objects, where property matches.
	 */
	List<Attribute> getAttributesByProperty(QueryProperty... property) throws ASWebDataServiceException;

	/**
	 * Returns all Attribute objects, where property matches, sorted.
	 */
	List<Attribute> getAttributesByProperty(SortType sortType, QueryProperty... property) throws ASWebDataServiceException;

	/**
	 * Returns all Attributes count.
	 */
	int getAttributesCount() throws ASWebDataServiceException;

	/**
	 * Returns Attributes objects segment.
	 */
	List<Attribute> getAttributes(Segment aSegment) throws ASWebDataServiceException;

	/**
	 * Returns Attribute objects segment, where property matches.
	 */
	List<Attribute> getAttributesByProperty(Segment aSegment, QueryProperty... aProperty) throws ASWebDataServiceException;

	/**
	 * Returns Attribute objects segment, where property matches, sorted.
	 */
	List<Attribute> getAttributesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASWebDataServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportAttributesToXML(List<Attribute> listAttributes)  throws ASWebDataServiceException;
	/**
	 * creates an xml element with selected contained data but only selected languages in multilingual attributes
	 */
	XMLNode exportAttributesToXML(String[] languages,List<Attribute> listAttributes) throws ASWebDataServiceException;

	/**
	 * Create json object list dependencies for this Attribute document.
	 */
	void fetchAttribute(String id, Set<String> addedDocuments, JSONArray data) throws ASWebDataServiceException;

	/**
	 * Save transferred document by its own type.
	 */
	void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASWebDataServiceException;
	/**
	 * Copies all multilingual fields from sourceLanguage to targetLanguage in all data objects (documents, vo) which are part of this module and managed by this service.
	 */
	 void copyMultilingualAttributesInAllObjects(String sourceLanguage, String targetLanguage) throws ASWebDataServiceException;

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service.
	 */
	QueryResult executeQueryOnAllObjects(DocumentQuery query) throws ASWebDataServiceException;
	/**
	 * creates an xml element with all contained data.
	 */
	XMLNode exportToXML() throws ASWebDataServiceException;

	/**
	 * creates an xml element with all contained data but only selected languages in multilingual attributes.
	 */
	XMLNode exportToXML(String[] languages) throws ASWebDataServiceException;
}
