/**
 ********************************************************************************
 *** BaseWizardDefAction.java                                                 ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswizarddata.action;

import net.anotheria.anosite.gen.shared.action.BaseWizardAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.aswizarddata.data.WizardDef;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseWizardDefAction extends BaseWizardAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "WizardDef";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASWizardData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "WizardDef";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, WizardDef wizarddef) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASWizardData.WizardDef").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWizardData.WizardDef", wizarddef, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWizardData.WizardDef", wizarddef, "wizardSteps");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.wizardSteps", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWizardData.WizardDef", wizarddef, "wizardCancelRedirectUrl");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.wizardCancelRedirectUrl", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWizardData.WizardDef", wizarddef, "wizardFinishRedirectUrl");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.wizardFinishRedirectUrl", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockWizardDefs(WizardDef wizarddef, HttpServletRequest req) throws Exception{
		if(wizarddef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)wizarddef;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASWizardDataService().updateWizardDef( wizarddef);
			logger.info("Lock-OPERATION, document with id : ["+wizarddef.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockWizardDefs(WizardDef wizarddef, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(wizarddef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)wizarddef;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASWizardDataService().updateWizardDef( wizarddef);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+wizarddef.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+wizarddef.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkWizardDefs(WizardDef wizarddef, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = wizarddef instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)wizarddef).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)wizarddef).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockWizardDefs(wizarddef, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateWizardDefs(WizardDef wizarddef, HttpServletRequest req) throws Exception{
		if(wizarddef instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)wizarddef, false, getUserId(req));
		}
		if (isTimeoutReached(wizarddef)) {
			checkWizardDefs(wizarddef, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(wizarddef, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(WizardDef wizarddef){
		if (wizarddef instanceof LockableObject) {
			LockableObject lock = (LockableObject)wizarddef;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(WizardDef wizarddef, HttpServletRequest req){
		if (wizarddef instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)wizarddef;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
