/**
 ********************************************************************************
 *** ASWizardDataServiceImpl.java                                             ***
 *** The implementation of the IASWizardDataService.                          ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswizarddata.service;

import java.nio.charset.Charset;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anosite.gen.aswizarddata.data.ModuleASWizardData;
import net.anotheria.anosite.gen.shared.service.BasicCMSService;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.StringUtils;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.asg.util.listener.IModuleListener;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import net.anotheria.anodoc.util.mapper.ObjectMapperUtil;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.aswizarddata.data.WizardDef;
import net.anotheria.anosite.gen.aswizarddata.data.WizardDefXMLHelper;
import net.anotheria.anosite.gen.aswizarddata.data.WizardDefDocument;
import net.anotheria.anosite.gen.aswebdata.service.ASWebDataServiceException;
import net.anotheria.anosite.gen.anoaccessconfiguration.service.AnoAccessConfigurationServiceException;
import net.anotheria.anosite.gen.aswizarddata.service.ASWizardDataServiceException;
import net.anotheria.anosite.gen.aswizarddata.data.WizardHandlerDef;
import net.anotheria.anosite.gen.aswizarddata.data.WizardHandlerDefXMLHelper;
import net.anotheria.anosite.gen.aswizarddata.data.WizardHandlerDefDocument;

public class ASWizardDataServiceImpl extends BasicCMSService implements IASWizardDataService, IModuleListener{

	// Generated by: class net.anotheria.asg.generator.model.docs.CMSBasedServiceGenerator.generateImplementation

	private static ASWizardDataServiceImpl instance;

	private ASWizardDataServiceImpl(){
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.AutoTransferWizardDataListener());
		addModuleListener(ModuleASWizardData.MODULE_ID, this);
	}

	static final ASWizardDataServiceImpl getInstance(){
		if (instance==null){
			instance = new ASWizardDataServiceImpl();
		}
		return instance;
	}

	private ModuleASWizardData _getModuleASWizardData(){
		return (ModuleASWizardData) getModule(ModuleASWizardData.MODULE_ID);
	}

	@Override
	public void moduleLoaded(Module module){
		firePersistenceChangedEvent();
	}

	@Override
	public List<WizardDef> getWizardDefs(){
		List<WizardDef> wizarddefs = new ArrayList<>();
		wizarddefs.addAll(_getModuleASWizardData().getWizardDefs());
		return wizarddefs;
	}

	@Override
	public List<WizardDef> getWizardDefs(SortType sortType){
		return StaticQuickSorter.sort(getWizardDefs(), sortType);
	}

	/**
	 * Returns the WizardDef objects with the specified ids.
	 */
	public List<WizardDef> getWizardDefs(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<WizardDef> all = getWizardDefs();
		List<WizardDef> ret = new ArrayList<>();
		for (WizardDef wizarddef : all){
			if(ids.contains(wizarddef.getId())){
				ret.add(wizarddef);
			}
		}
		return ret;
	}

	/**
	 * Returns the WizardDef objects with the specified ids, sorted by given sorttype.
	 */
	public List<WizardDef> getWizardDefs(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getWizardDefs(ids), sortType);
	}

	@Override
	public void deleteWizardDef(WizardDef wizarddef){
		deleteWizardDef(wizarddef.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(wizarddef);
		}
	}

	@Override
	public void deleteWizardDef(String id){
		ModuleASWizardData module = _getModuleASWizardData();
		WizardDef varValue = hasServiceListeners()?module.getWizardDef(id):null;
		module.deleteWizardDef(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteWizardDefs(List<WizardDef> list){
		ModuleASWizardData module = _getModuleASWizardData();
		for (WizardDef wizarddef : list){
			module.deleteWizardDef(wizarddef.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public WizardDef getWizardDef(String id){
		return _getModuleASWizardData().getWizardDef(id);
	}

	@Override
	public WizardDef importWizardDef(WizardDef wizarddef){
		ModuleASWizardData module = _getModuleASWizardData();
		module.importWizardDef((WizardDefDocument)wizarddef);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(wizarddef);
		}
		return wizarddef;
	}

	@Override
	public List<WizardDef> importWizardDefs(List<WizardDef> list){
		ModuleASWizardData module = _getModuleASWizardData();
		List<WizardDef> ret = new ArrayList<>();
		for (WizardDef wizarddef : list){
			WizardDef imported = module.importWizardDef((WizardDefDocument)wizarddef);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (WizardDef wizarddef : ret)
				fireObjectImportedEvent(wizarddef);
		}
		return ret;
	}

	@Override
	public WizardDef createWizardDef(WizardDef wizarddef){
		ModuleASWizardData module = _getModuleASWizardData();
		module.createWizardDef((WizardDefDocument)wizarddef);
		updateModule(module);
		fireObjectCreatedEvent(wizarddef);
		return wizarddef;
	}

	@Override
	/**
	 * Creates multiple new WizardDef objects.
	 * Returns the created versions.
	 */
	public List<WizardDef> createWizardDefs(List<WizardDef> list){
		ModuleASWizardData module = _getModuleASWizardData();
		List<WizardDef> ret = new ArrayList<>();
		for (WizardDef wizarddef : list){
			WizardDef created = module.createWizardDef((WizardDefDocument)wizarddef);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (WizardDef wizarddef : ret)
				fireObjectCreatedEvent(wizarddef);
		}
		return ret;
	}

	@Override
	public WizardDef updateWizardDef(WizardDef wizarddef){
		WizardDef oldVersion = null;
		ModuleASWizardData module = _getModuleASWizardData();
		if (hasServiceListeners())
			oldVersion = module.getWizardDef(wizarddef.getId());
		module.updateWizardDef((WizardDefDocument)wizarddef);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, wizarddef);
		}
		return wizarddef;
	}

	@Override
	public List<WizardDef> updateWizardDefs(List<WizardDef> list){
		List<WizardDef> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASWizardData module = _getModuleASWizardData();
		for (WizardDef wizarddef : list){
			if (oldList!=null)
				oldList.add(module.getWizardDef(wizarddef.getId()));
			module.updateWizardDef((WizardDefDocument)wizarddef);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<WizardDef> getWizardDefsByProperty(String propertyName, Object value){
		List<WizardDef> allWizardDefs = getWizardDefs();
		List<WizardDef> ret = new ArrayList<>();
		for (int i=0; i<allWizardDefs.size(); i++){
			WizardDef wizarddef = allWizardDefs.get(i);
			try{
				Property property = ((WizardDefDocument)wizarddef).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(wizarddef);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(wizarddef);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(wizarddef);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<WizardDef> getWizardDefsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getWizardDefsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on WizardDefs
	 */
	public QueryResult executeQueryOnWizardDefs(DocumentQuery query){
		List<WizardDef> allWizardDefs = getWizardDefs();
		QueryResult result = new QueryResult();
		for (int i=0; i<allWizardDefs.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allWizardDefs.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all WizardDef objects, where property matches.
	 */
	public List<WizardDef> getWizardDefsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<WizardDef> ret = new ArrayList<>();
		List<WizardDef> src = getWizardDefs();
		for ( WizardDef wizarddef : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(wizarddef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(wizarddef);
		}
		return ret;
	}

	/**
	 * Returns all WizardDef objects, where property matches, sorted
	 */
	public List<WizardDef> getWizardDefsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getWizardDefsByProperty(property), sortType);
	}

	/**
	 * Returns WizardDef objects count.
	 */
	public int getWizardDefsCount() {
		return _getModuleASWizardData().getWizardDefs().size();
	}

	/**
	 * Returns WizardDef objects segment.
	 */
	public List<WizardDef> getWizardDefs(Segment aSegment) {
		return Slicer.slice(aSegment, getWizardDefs()).getSliceData();
	}

	/**
	 * Returns WizardDef objects segment, where property matched.
	 */
	public List<WizardDef> getWizardDefsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<WizardDef> ret = new ArrayList<>();
		List<WizardDef> src = getWizardDefs();
		for (WizardDef wizarddef : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(wizarddef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(wizarddef);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns WizardDef objects segment, where property matched, sorted.
	 */
	public List<WizardDef> getWizardDefsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getWizardDefsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchWizardDef(final String id, Set<String> addedDocuments, JSONArray data) throws ASWizardDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("WizardDef" + id))
			return;

		try {
			final WizardDefDocument wizarddef = _getModuleASWizardData().getWizardDef(id);
			addedDocuments.add("WizardDef" + id);

			if (!StringUtils.isEmpty(wizarddef.getHandler()))
				getASWizardDataService().fetchWizardHandlerDef(wizarddef.getHandler(), addedDocuments, data);
			if (!StringUtils.isEmpty(wizarddef.getAccessOperation()))
				getAnoAccessConfigurationService().fetchAccessOperation(wizarddef.getAccessOperation(), addedDocuments, data);

			if (!wizarddef.getWizardSteps().isEmpty()) {
				for (String aWizardStepsId: wizarddef.getWizardSteps()) {
					getASWebDataService().fetchPagex(aWizardStepsId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(wizarddef);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASWizardData");
			dataObject.put("document", "ASWizardData_WizardDef");

			data.put(dataObject);

		}catch(ASWebDataServiceException e){
			throw new ASWizardDataServiceException("Problem with getting document from ASWebData" + e.getMessage());
		}catch(AnoAccessConfigurationServiceException e){
			throw new ASWizardDataServiceException("Problem with getting document from AnoAccessConfiguration" + e.getMessage());
		}catch(ASWizardDataServiceException e){
			throw new ASWizardDataServiceException("Problem with getting document from ASWizardData" + e.getMessage());
		}catch(IOException e){
			throw new ASWizardDataServiceException ("Problem with fetching data for this WizardDef instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASWizardDataServiceException ("Problem with fetching data for this WizardDef instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredWizardDef(final JSONObject data) throws ASWizardDataServiceException {
		try {
			String objectData = data.getString("object");
			WizardDef wizarddef = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), WizardDefDocument.class);

			try {
				updateWizardDef(wizarddef);
			}catch(Exception e){
				importWizardDef(wizarddef);
			}
		}catch(JSONException e){
			throw new ASWizardDataServiceException("Problem with getting data from json WizardDef instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASWizardDataServiceException("Problem with parsing data for this WizardDef instance :" + e.getMessage());
		}
	}

	@Override
	public List<WizardHandlerDef> getWizardHandlerDefs(){
		List<WizardHandlerDef> wizardhandlerdefs = new ArrayList<>();
		wizardhandlerdefs.addAll(_getModuleASWizardData().getWizardHandlerDefs());
		return wizardhandlerdefs;
	}

	@Override
	public List<WizardHandlerDef> getWizardHandlerDefs(SortType sortType){
		return StaticQuickSorter.sort(getWizardHandlerDefs(), sortType);
	}

	/**
	 * Returns the WizardHandlerDef objects with the specified ids.
	 */
	public List<WizardHandlerDef> getWizardHandlerDefs(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<WizardHandlerDef> all = getWizardHandlerDefs();
		List<WizardHandlerDef> ret = new ArrayList<>();
		for (WizardHandlerDef wizardhandlerdef : all){
			if(ids.contains(wizardhandlerdef.getId())){
				ret.add(wizardhandlerdef);
			}
		}
		return ret;
	}

	/**
	 * Returns the WizardHandlerDef objects with the specified ids, sorted by given sorttype.
	 */
	public List<WizardHandlerDef> getWizardHandlerDefs(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getWizardHandlerDefs(ids), sortType);
	}

	@Override
	public void deleteWizardHandlerDef(WizardHandlerDef wizardhandlerdef){
		deleteWizardHandlerDef(wizardhandlerdef.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(wizardhandlerdef);
		}
	}

	@Override
	public void deleteWizardHandlerDef(String id){
		ModuleASWizardData module = _getModuleASWizardData();
		WizardHandlerDef varValue = hasServiceListeners()?module.getWizardHandlerDef(id):null;
		module.deleteWizardHandlerDef(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteWizardHandlerDefs(List<WizardHandlerDef> list){
		ModuleASWizardData module = _getModuleASWizardData();
		for (WizardHandlerDef wizardhandlerdef : list){
			module.deleteWizardHandlerDef(wizardhandlerdef.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public WizardHandlerDef getWizardHandlerDef(String id){
		return _getModuleASWizardData().getWizardHandlerDef(id);
	}

	@Override
	public WizardHandlerDef importWizardHandlerDef(WizardHandlerDef wizardhandlerdef){
		ModuleASWizardData module = _getModuleASWizardData();
		module.importWizardHandlerDef((WizardHandlerDefDocument)wizardhandlerdef);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(wizardhandlerdef);
		}
		return wizardhandlerdef;
	}

	@Override
	public List<WizardHandlerDef> importWizardHandlerDefs(List<WizardHandlerDef> list){
		ModuleASWizardData module = _getModuleASWizardData();
		List<WizardHandlerDef> ret = new ArrayList<>();
		for (WizardHandlerDef wizardhandlerdef : list){
			WizardHandlerDef imported = module.importWizardHandlerDef((WizardHandlerDefDocument)wizardhandlerdef);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (WizardHandlerDef wizardhandlerdef : ret)
				fireObjectImportedEvent(wizardhandlerdef);
		}
		return ret;
	}

	@Override
	public WizardHandlerDef createWizardHandlerDef(WizardHandlerDef wizardhandlerdef){
		ModuleASWizardData module = _getModuleASWizardData();
		module.createWizardHandlerDef((WizardHandlerDefDocument)wizardhandlerdef);
		updateModule(module);
		fireObjectCreatedEvent(wizardhandlerdef);
		return wizardhandlerdef;
	}

	@Override
	/**
	 * Creates multiple new WizardHandlerDef objects.
	 * Returns the created versions.
	 */
	public List<WizardHandlerDef> createWizardHandlerDefs(List<WizardHandlerDef> list){
		ModuleASWizardData module = _getModuleASWizardData();
		List<WizardHandlerDef> ret = new ArrayList<>();
		for (WizardHandlerDef wizardhandlerdef : list){
			WizardHandlerDef created = module.createWizardHandlerDef((WizardHandlerDefDocument)wizardhandlerdef);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (WizardHandlerDef wizardhandlerdef : ret)
				fireObjectCreatedEvent(wizardhandlerdef);
		}
		return ret;
	}

	@Override
	public WizardHandlerDef updateWizardHandlerDef(WizardHandlerDef wizardhandlerdef){
		WizardHandlerDef oldVersion = null;
		ModuleASWizardData module = _getModuleASWizardData();
		if (hasServiceListeners())
			oldVersion = module.getWizardHandlerDef(wizardhandlerdef.getId());
		module.updateWizardHandlerDef((WizardHandlerDefDocument)wizardhandlerdef);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, wizardhandlerdef);
		}
		return wizardhandlerdef;
	}

	@Override
	public List<WizardHandlerDef> updateWizardHandlerDefs(List<WizardHandlerDef> list){
		List<WizardHandlerDef> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASWizardData module = _getModuleASWizardData();
		for (WizardHandlerDef wizardhandlerdef : list){
			if (oldList!=null)
				oldList.add(module.getWizardHandlerDef(wizardhandlerdef.getId()));
			module.updateWizardHandlerDef((WizardHandlerDefDocument)wizardhandlerdef);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<WizardHandlerDef> getWizardHandlerDefsByProperty(String propertyName, Object value){
		List<WizardHandlerDef> allWizardHandlerDefs = getWizardHandlerDefs();
		List<WizardHandlerDef> ret = new ArrayList<>();
		for (int i=0; i<allWizardHandlerDefs.size(); i++){
			WizardHandlerDef wizardhandlerdef = allWizardHandlerDefs.get(i);
			try{
				Property property = ((WizardHandlerDefDocument)wizardhandlerdef).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(wizardhandlerdef);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(wizardhandlerdef);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(wizardhandlerdef);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<WizardHandlerDef> getWizardHandlerDefsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getWizardHandlerDefsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on WizardHandlerDefs
	 */
	public QueryResult executeQueryOnWizardHandlerDefs(DocumentQuery query){
		List<WizardHandlerDef> allWizardHandlerDefs = getWizardHandlerDefs();
		QueryResult result = new QueryResult();
		for (int i=0; i<allWizardHandlerDefs.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allWizardHandlerDefs.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all WizardHandlerDef objects, where property matches.
	 */
	public List<WizardHandlerDef> getWizardHandlerDefsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<WizardHandlerDef> ret = new ArrayList<>();
		List<WizardHandlerDef> src = getWizardHandlerDefs();
		for ( WizardHandlerDef wizardhandlerdef : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(wizardhandlerdef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(wizardhandlerdef);
		}
		return ret;
	}

	/**
	 * Returns all WizardHandlerDef objects, where property matches, sorted
	 */
	public List<WizardHandlerDef> getWizardHandlerDefsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getWizardHandlerDefsByProperty(property), sortType);
	}

	/**
	 * Returns WizardHandlerDef objects count.
	 */
	public int getWizardHandlerDefsCount() {
		return _getModuleASWizardData().getWizardHandlerDefs().size();
	}

	/**
	 * Returns WizardHandlerDef objects segment.
	 */
	public List<WizardHandlerDef> getWizardHandlerDefs(Segment aSegment) {
		return Slicer.slice(aSegment, getWizardHandlerDefs()).getSliceData();
	}

	/**
	 * Returns WizardHandlerDef objects segment, where property matched.
	 */
	public List<WizardHandlerDef> getWizardHandlerDefsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<WizardHandlerDef> ret = new ArrayList<>();
		List<WizardHandlerDef> src = getWizardHandlerDefs();
		for (WizardHandlerDef wizardhandlerdef : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(wizardhandlerdef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(wizardhandlerdef);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns WizardHandlerDef objects segment, where property matched, sorted.
	 */
	public List<WizardHandlerDef> getWizardHandlerDefsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getWizardHandlerDefsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchWizardHandlerDef(final String id, Set<String> addedDocuments, JSONArray data) throws ASWizardDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("WizardHandlerDef" + id))
			return;

		try {
			final WizardHandlerDefDocument wizardhandlerdef = _getModuleASWizardData().getWizardHandlerDef(id);
			addedDocuments.add("WizardHandlerDef" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(wizardhandlerdef);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASWizardData");
			dataObject.put("document", "ASWizardData_WizardHandlerDef");

			data.put(dataObject);

		}catch(IOException e){
			throw new ASWizardDataServiceException ("Problem with fetching data for this WizardHandlerDef instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASWizardDataServiceException ("Problem with fetching data for this WizardHandlerDef instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredWizardHandlerDef(final JSONObject data) throws ASWizardDataServiceException {
		try {
			String objectData = data.getString("object");
			WizardHandlerDef wizardhandlerdef = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), WizardHandlerDefDocument.class);

			try {
				updateWizardHandlerDef(wizardhandlerdef);
			}catch(Exception e){
				importWizardHandlerDef(wizardhandlerdef);
			}
		}catch(JSONException e){
			throw new ASWizardDataServiceException("Problem with getting data from json WizardHandlerDef instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASWizardDataServiceException("Problem with parsing data for this WizardHandlerDef instance :" + e.getMessage());
		}
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASWizardDataServiceException {
		switch(documentName) {
			case DOCUMENT_ASWIZARDDATA_WIZARDDEF:
				saveTransferredWizardDef(data);
				break;
			case DOCUMENT_ASWIZARDDATA_WIZARDHANDLERDEF:
				saveTransferredWizardHandlerDef(data);
				break;
			default:
				log.info("There is no correct document: " + documentName + "in this service");
				throw new ASWizardDataServiceException("No such document");
		}
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query){
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnWizardDefs(query).getEntries());
		ret.add(executeQueryOnWizardHandlerDefs(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects


	public XMLNode exportWizardDefsToXML(){
		XMLNode ret = new XMLNode("WizardDefs");
		List<WizardDef> list = getWizardDefs();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (WizardDef object : list)
			ret.addChildNode(WizardDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportWizardDefsToXML(List<WizardDef> list){
		XMLNode ret = new XMLNode("WizardDefs");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (WizardDef object : list)
			ret.addChildNode(WizardDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportWizardHandlerDefsToXML(){
		XMLNode ret = new XMLNode("WizardHandlerDefs");
		List<WizardHandlerDef> list = getWizardHandlerDefs();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (WizardHandlerDef object : list)
			ret.addChildNode(WizardHandlerDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportWizardHandlerDefsToXML(List<WizardHandlerDef> list){
		XMLNode ret = new XMLNode("WizardHandlerDefs");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (WizardHandlerDef object : list)
			ret.addChildNode(WizardHandlerDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("ASWizardData");

		ret.addChildNode(exportWizardDefsToXML());
		ret.addChildNode(exportWizardHandlerDefsToXML());

		return ret;
	}
}
