/**
 ********************************************************************************
 *** ImagesServiceImpl.java                                                   ***
 *** The implementation of the IImagesService.                                ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.images.service;

import java.nio.charset.Charset;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anosite.gen.images.data.ModuleImages;
import net.anotheria.anosite.gen.shared.service.BasicCMSService;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.StringUtils;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.asg.util.listener.IModuleListener;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import net.anotheria.anodoc.util.mapper.ObjectMapperUtil;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.images.data.Image;
import net.anotheria.anosite.gen.images.data.ImageXMLHelper;
import net.anotheria.anosite.gen.images.data.ImageDocument;
import net.anotheria.webutils.filehandling.actions.FileStorage;
import java.io.File;
import java.io.FileNotFoundException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import net.anotheria.anosite.util.staticutil.JerseyClientUtil;
import net.anotheria.anosite.config.DocumentTransferConfig;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;

public class ImagesServiceImpl extends BasicCMSService implements IImagesService, IModuleListener{

	// Generated by: class net.anotheria.asg.generator.model.docs.CMSBasedServiceGenerator.generateImplementation

	private static ImagesServiceImpl instance;

	private ImagesServiceImpl(){
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.AutoTransferImagesListener());
		addModuleListener(ModuleImages.MODULE_ID, this);
	}

	static final ImagesServiceImpl getInstance(){
		if (instance==null){
			instance = new ImagesServiceImpl();
		}
		return instance;
	}

	private ModuleImages _getModuleImages(){
		return (ModuleImages) getModule(ModuleImages.MODULE_ID);
	}

	@Override
	public void moduleLoaded(Module module){
		firePersistenceChangedEvent();
	}

	@Override
	public List<Image> getImages(){
		List<Image> images = new ArrayList<>();
		images.addAll(_getModuleImages().getImages());
		return images;
	}

	@Override
	public List<Image> getImages(SortType sortType){
		return StaticQuickSorter.sort(getImages(), sortType);
	}

	/**
	 * Returns the Image objects with the specified ids.
	 */
	public List<Image> getImages(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<Image> all = getImages();
		List<Image> ret = new ArrayList<>();
		for (Image image : all){
			if(ids.contains(image.getId())){
				ret.add(image);
			}
		}
		return ret;
	}

	/**
	 * Returns the Image objects with the specified ids, sorted by given sorttype.
	 */
	public List<Image> getImages(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getImages(ids), sortType);
	}

	@Override
	public void deleteImage(Image image){
		deleteImage(image.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(image);
		}
	}

	@Override
	public void deleteImage(String id){
		ModuleImages module = _getModuleImages();
		Image varValue = hasServiceListeners()?module.getImage(id):null;
		module.deleteImage(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteImages(List<Image> list){
		ModuleImages module = _getModuleImages();
		for (Image image : list){
			module.deleteImage(image.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public Image getImage(String id){
		return _getModuleImages().getImage(id);
	}

	@Override
	public Image importImage(Image image){
		ModuleImages module = _getModuleImages();
		module.importImage((ImageDocument)image);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(image);
		}
		return image;
	}

	@Override
	public List<Image> importImages(List<Image> list){
		ModuleImages module = _getModuleImages();
		List<Image> ret = new ArrayList<>();
		for (Image image : list){
			Image imported = module.importImage((ImageDocument)image);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Image image : ret)
				fireObjectImportedEvent(image);
		}
		return ret;
	}

	@Override
	public Image createImage(Image image){
		ModuleImages module = _getModuleImages();
		module.createImage((ImageDocument)image);
		updateModule(module);
		fireObjectCreatedEvent(image);
		return image;
	}

	@Override
	/**
	 * Creates multiple new Image objects.
	 * Returns the created versions.
	 */
	public List<Image> createImages(List<Image> list){
		ModuleImages module = _getModuleImages();
		List<Image> ret = new ArrayList<>();
		for (Image image : list){
			Image created = module.createImage((ImageDocument)image);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Image image : ret)
				fireObjectCreatedEvent(image);
		}
		return ret;
	}

	@Override
	public Image updateImage(Image image){
		Image oldVersion = null;
		ModuleImages module = _getModuleImages();
		if (hasServiceListeners())
			oldVersion = module.getImage(image.getId());
		module.updateImage((ImageDocument)image);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, image);
		}
		return image;
	}

	@Override
	public List<Image> updateImages(List<Image> list){
		List<Image> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleImages module = _getModuleImages();
		for (Image image : list){
			if (oldList!=null)
				oldList.add(module.getImage(image.getId()));
			module.updateImage((ImageDocument)image);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<Image> getImagesByProperty(String propertyName, Object value){
		List<Image> allImages = getImages();
		List<Image> ret = new ArrayList<>();
		for (int i=0; i<allImages.size(); i++){
			Image image = allImages.get(i);
			try{
				Property property = ((ImageDocument)image).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(image);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(image);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(image);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<Image> getImagesByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getImagesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on Images
	 */
	public QueryResult executeQueryOnImages(DocumentQuery query){
		List<Image> allImages = getImages();
		QueryResult result = new QueryResult();
		for (int i=0; i<allImages.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allImages.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all Image objects, where property matches.
	 */
	public List<Image> getImagesByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<Image> ret = new ArrayList<>();
		List<Image> src = getImages();
		for ( Image image : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(image.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(image);
		}
		return ret;
	}

	/**
	 * Returns all Image objects, where property matches, sorted
	 */
	public List<Image> getImagesByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getImagesByProperty(property), sortType);
	}

	/**
	 * Returns Image objects count.
	 */
	public int getImagesCount() {
		return _getModuleImages().getImages().size();
	}

	/**
	 * Returns Image objects segment.
	 */
	public List<Image> getImages(Segment aSegment) {
		return Slicer.slice(aSegment, getImages()).getSliceData();
	}

	/**
	 * Returns Image objects segment, where property matched.
	 */
	public List<Image> getImagesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<Image> ret = new ArrayList<>();
		List<Image> src = getImages();
		for (Image image : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(image.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(image);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns Image objects segment, where property matched, sorted.
	 */
	public List<Image> getImagesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getImagesByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchImage(final String id, Set<String> addedDocuments, JSONArray data) throws ImagesServiceException {
		if (id.isEmpty() || addedDocuments.contains("Image" + id))
			return;

		try {
			final ImageDocument image = _getModuleImages().getImage(id);
			addedDocuments.add("Image" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(image);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "Images");
			dataObject.put("document", "Images_Image");

			data.put(dataObject);

			File imageFile = FileStorage.getFile(image.getImage());
			Client client = JerseyClientUtil.getClientInstance();
			for (String domain :DocumentTransferConfig.getInstance().getDomains()) {
				final FileDataBodyPart filePart = new FileDataBodyPart("file", imageFile);
				FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
				final FormDataMultiPart multipart = (FormDataMultiPart) formDataMultiPart.bodyPart(filePart);
				final WebTarget target = client.target(domain + "/api/asgimage/upload");
				final Response response = target.request().post(Entity.entity(multipart, multipart.getMediaType()));
				String responseResult = response.readEntity(String.class);
				log.info(responseResult);
				formDataMultiPart.close();
				multipart.close();
			}
		}catch(FileNotFoundException e){
			throw new ImagesServiceException ("Problem with getting image file for Image" + e.getMessage());
		}catch(IOException e){
			throw new ImagesServiceException ("Problem with fetching data for this Image instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ImagesServiceException ("Problem with fetching data for this Image instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredImage(final JSONObject data) throws ImagesServiceException {
		try {
			String objectData = data.getString("object");
			Image image = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), ImageDocument.class);

			try {
				updateImage(image);
			}catch(Exception e){
				importImage(image);
			}
		}catch(JSONException e){
			throw new ImagesServiceException("Problem with getting data from json Image instance :" + e.getMessage());
		}catch(IOException e){
			throw new ImagesServiceException("Problem with parsing data for this Image instance :" + e.getMessage());
		}
	}

	// This method is not very fast, since it makes an update (eff. save) after each doc.
	public void copyMultilingualAttributesInAllImages(String sourceLanguage, String targetLanguage){
		List<Image> allDocumentsSrc = getImages();
		List<Image> allDocuments = new ArrayList<>(allDocumentsSrc.size());
		allDocuments.addAll(allDocumentsSrc);
		for (Image document : allDocuments){
			document.copyLANG2LANG(sourceLanguage, targetLanguage);
		}
		updateImages(allDocuments);
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ImagesServiceException {
		switch(documentName) {
			case DOCUMENT_IMAGES_IMAGE:
				saveTransferredImage(data);
				break;
			default:
				log.info("There is no correct document: " + documentName + "in this service");
				throw new ImagesServiceException("No such document");
		}
	}

	/**
	 * Copies all multilingual fields from sourceLanguage to targetLanguage in all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public void copyMultilingualAttributesInAllObjects(String sourceLanguage, String targetLanguage){
		copyMultilingualAttributesInAllImages(sourceLanguage, targetLanguage);
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query){
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnImages(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects


	public XMLNode exportImagesToXML(){
		XMLNode ret = new XMLNode("Images");
		List<Image> list = getImages();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Image object : list)
			ret.addChildNode(ImageXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportImagesToXML(List<Image> list){
		XMLNode ret = new XMLNode("Images");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Image object : list)
			ret.addChildNode(ImageXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportImagesToXML(String[] languages){
		XMLNode ret = new XMLNode("Images");
		List<Image> list = getImages();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Image object : list)
			ret.addChildNode(ImageXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportImagesToXML(String[] languages, List<Image> list){
		XMLNode ret = new XMLNode("Images");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Image object : list)
			ret.addChildNode(ImageXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("Images");

		ret.addChildNode(exportImagesToXML());

		return ret;
	}
	public XMLNode exportToXML(String[] languages){
		XMLNode ret = new XMLNode("Images");

		ret.addChildNode(exportImagesToXML(languages));

		return ret;
	}
}
