/**
 ********************************************************************************
 *** AnoDocConfigurator.java                                                  ***
 *** Generator: net.anotheria.asg.generator.ConfiguratorGenerator             ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.shared.service;

import net.anotheria.anodoc.service.IModuleFactory;
import net.anotheria.anodoc.service.IModuleService;
import net.anotheria.anodoc.service.ModuleServiceFactory;
import net.anotheria.anodoc.util.CommonHashtableModuleStorage;
import net.anotheria.anosite.gen.asgenericdata.data.*;
import net.anotheria.anosite.gen.ascustomdata.data.*;
import net.anotheria.anosite.gen.asfederateddata.data.*;
import net.anotheria.anosite.gen.images.data.*;
import net.anotheria.anosite.gen.aslayoutdata.data.*;
import net.anotheria.anosite.gen.assitedata.data.*;
import net.anotheria.anosite.gen.assiteconfig.data.*;
import net.anotheria.anosite.gen.aswebdata.data.*;
import net.anotheria.anosite.gen.asresourcedata.data.*;
import net.anotheria.anosite.gen.asgenericaction.data.*;
import net.anotheria.anosite.gen.ascustomaction.data.*;
import net.anotheria.anosite.gen.asaction.data.*;
import net.anotheria.anosite.gen.aswizarddata.data.*;
import net.anotheria.anosite.gen.asuserdata.data.*;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.*;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.*;
import net.anotheria.anosite.gen.asfeature.data.*;
import net.anotheria.anosite.gen.asexperiment.data.*;
import net.anotheria.anosite.gen.asbrand.data.*;

public class AnoDocConfigurator{

	/**
	 * Returns the selected encoding. Using method instead of constant to prevent compilation dependencies
	 */
	public static final String getEncoding(){ return "UTF-8"; }

	private static void addCommonStorage(String moduleId, IModuleService service, IModuleFactory factory, String storageDirConfigKey){
		service.attachModuleFactory(moduleId, factory );
		if (storageDirConfigKey==null)
			service.attachModuleStorage(moduleId, new CommonHashtableModuleStorage(moduleId+".dat", factory));
		else
			service.attachModuleStorage(moduleId, new CommonHashtableModuleStorage(moduleId+".dat", factory, storageDirConfigKey));
	}

	private static volatile boolean configured;

	public static void configure(){
		if (configured)
			return;
		configured = true;
		net.anotheria.anodoc.util.context.ContextManager.setFactory(new net.anotheria.anosite.gen.util.AnositeCallContextFactory());
		IModuleService service = ModuleServiceFactory.createModuleService();
		addCommonStorage(ModuleASGenericData.MODULE_ID, service, new ModuleASGenericDataFactory(), null);
		addCommonStorage(ModuleASCustomData.MODULE_ID, service, new ModuleASCustomDataFactory(), null);
		addCommonStorage(ModuleImages.MODULE_ID, service, new ModuleImagesFactory(), null);
		addCommonStorage(ModuleASLayoutData.MODULE_ID, service, new ModuleASLayoutDataFactory(), null);
		addCommonStorage(ModuleASSiteData.MODULE_ID, service, new ModuleASSiteDataFactory(), null);
		addCommonStorage(ModuleASSiteConfig.MODULE_ID, service, new ModuleASSiteConfigFactory(), null);
		addCommonStorage(ModuleASWebData.MODULE_ID, service, new ModuleASWebDataFactory(), null);
		addCommonStorage(ModuleASResourceData.MODULE_ID, service, new ModuleASResourceDataFactory(), null);
		addCommonStorage(ModuleASGenericAction.MODULE_ID, service, new ModuleASGenericActionFactory(), null);
		addCommonStorage(ModuleASCustomAction.MODULE_ID, service, new ModuleASCustomActionFactory(), null);
		addCommonStorage(ModuleASWizardData.MODULE_ID, service, new ModuleASWizardDataFactory(), null);
		addCommonStorage(ModuleASUserData.MODULE_ID, service, new ModuleASUserDataFactory(), null);
		addCommonStorage(ModuleAnoAccessConfiguration.MODULE_ID, service, new ModuleAnoAccessConfigurationFactory(), null);
		addCommonStorage(ModuleAnoAccessApplicationData.MODULE_ID, service, new ModuleAnoAccessApplicationDataFactory(), null);
		addCommonStorage(ModuleASFeature.MODULE_ID, service, new ModuleASFeatureFactory(), null);
		addCommonStorage(ModuleASExperiment.MODULE_ID, service, new ModuleASExperimentFactory(), null);
		addCommonStorage(ModuleASBrand.MODULE_ID, service, new ModuleASBrandFactory(), null);
		MetaFactoryConfigurator.configure();
	}
}
