package net.anotheria.anosite.handler;

import net.anotheria.anosite.shared.InternalResponseCode;

/**
 * Basic class for a response generated by a boxhandler submit or process method.
 * @author lrosenberg
 *
 */
public abstract class BoxHandlerResponse {
	/**
	 * Returns the response code of the response. Classes react on the response accordingly to the response code.
	 * @return the response code.
	 */
	public abstract InternalResponseCode getResponseCode();
	
	@Override public String toString(){
		return getResponseCode().toString();
	}
}
