/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.access;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.anotheria.access.AccessService;
import net.anotheria.access.AccessServiceException;
import net.anotheria.access.Permission;
import net.anotheria.access.Role;
import net.anotheria.access.SOAttribute;
import net.anotheria.access.SecurityObject;
import net.anotheria.access.impl.PermissionCollection;
import net.anotheria.access.impl.PermissionImpl;
import net.anotheria.access.impl.SecurityBox;
import net.anotheria.access.impl.StaticRole;
import net.anotheria.access.storage.persistence.SecurityBoxPersistenceService;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.anoplass.api.APIException;
import net.anotheria.anoplass.api.APIFinder;
import net.anotheria.anoplass.api.APIInitException;
import net.anotheria.anoplass.api.generic.login.LoginAPI;
import net.anotheria.anoprise.dualcrud.CrudServiceException;
import net.anotheria.anoprise.dualcrud.SaveableID;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.access.AccessOperationNotFoundAPIException;
import net.anotheria.anosite.access.AnoSiteAccessAPI;
import net.anotheria.anosite.access.AnoSiteAccessAPIConfig;
import net.anotheria.anosite.access.AnoSiteAccessAPIException;
import net.anotheria.anosite.access.constraint.ParametrizedConstraint;
import net.anotheria.anosite.access.context.SecurityContextInitializer;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserData;
import net.anotheria.anosite.gen.anoaccessapplicationdata.service.AnoAccessApplicationDataServiceException;
import net.anotheria.anosite.gen.anoaccessapplicationdata.service.IAnoAccessApplicationDataService;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.AccessOperation;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Constraint;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ContextInitializer;
import net.anotheria.anosite.gen.anoaccessconfiguration.service.AccessOperationNotFoundInAnoAccessConfigurationServiceException;
import net.anotheria.anosite.gen.anoaccessconfiguration.service.AnoAccessConfigurationServiceException;
import net.anotheria.anosite.gen.anoaccessconfiguration.service.IAnoAccessConfigurationService;
import net.anotheria.anosite.gen.ascustomaction.data.CustomActionDef;
import net.anotheria.anosite.gen.ascustomaction.service.ASCustomActionServiceException;
import net.anotheria.anosite.gen.ascustomaction.service.IASCustomActionService;
import net.anotheria.anosite.gen.assitedata.data.NaviItem;
import net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException;
import net.anotheria.anosite.gen.assitedata.service.IASSiteDataService;
import net.anotheria.anosite.gen.asuserdata.data.UserDef;
import net.anotheria.anosite.gen.asuserdata.service.ASUserDataServiceException;
import net.anotheria.anosite.gen.asuserdata.service.IASUserDataService;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.service.ASWebDataServiceException;
import net.anotheria.anosite.gen.aswebdata.service.IASWebDataService;
import net.anotheria.anosite.gen.aswizarddata.data.WizardDef;
import net.anotheria.anosite.gen.aswizarddata.service.ASWizardDataServiceException;
import net.anotheria.anosite.gen.aswizarddata.service.IASWizardDataService;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.util.listener.IServiceListener;
import net.anotheria.util.StringUtils;
import net.anotheria.util.log.LogMessageUtil;
import net.anotheria.util.sorter.SortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class AnoSiteAccessAPIImpl
implements AnoSiteAccessAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnoSiteAccessAPIImpl.class);
    private AccessService accessService;
    private IAnoAccessConfigurationService accessConfigurationService;
    private IAnoAccessApplicationDataService accessApplicationDataService;
    private IASWebDataService pagesConfigurationPersistence;
    private IASSiteDataService siteDataService;
    private IASCustomActionService customActionsConfigurationPersistence;
    private IASWizardDataService wizardConfigurationPersistence;
    private IASUserDataService userDataService;
    private SecurityBoxPersistenceService securityBoxPersistenceService;
    private LoginAPI loginAPI;

    public void init() throws APIInitException {
        try {
            this.accessService = (AccessService)MetaFactory.get(AccessService.class);
            this.accessConfigurationService = (IAnoAccessConfigurationService)MetaFactory.get(IAnoAccessConfigurationService.class);
            this.accessApplicationDataService = (IAnoAccessApplicationDataService)MetaFactory.get(IAnoAccessApplicationDataService.class);
            this.pagesConfigurationPersistence = (IASWebDataService)MetaFactory.get(IASWebDataService.class);
            this.siteDataService = (IASSiteDataService)MetaFactory.get(IASSiteDataService.class);
            this.customActionsConfigurationPersistence = (IASCustomActionService)MetaFactory.get(IASCustomActionService.class);
            this.wizardConfigurationPersistence = (IASWizardDataService)MetaFactory.get(IASWizardDataService.class);
            this.userDataService = (IASUserDataService)MetaFactory.get(IASUserDataService.class);
            this.securityBoxPersistenceService = (SecurityBoxPersistenceService)MetaFactory.get(SecurityBoxPersistenceService.class);
        }
        catch (MetaFactoryException e) {
            String message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[0]) + " Can't initialize required services.";
            LOGGER.error(MarkerFactory.getMarker((String)"FATAL"), message, (Throwable)e);
            throw new APIInitException(message, (Exception)((Object)e));
        }
        this.loginAPI = (LoginAPI)APIFinder.findAPI(LoginAPI.class);
        try {
            this.configureAccessService();
        }
        catch (AnoSiteAccessAPIException e) {
            String message = LogMessageUtil.failMsg((Throwable)((Object)e), (Object[])new Object[0]) + " Can't initialize access service with current configuration.";
            LOGGER.error(MarkerFactory.getMarker((String)"FATAL"), message, (Throwable)((Object)e));
            throw new APIInitException(message, (Exception)((Object)e));
        }
        this.accessConfigurationService.addServiceListener((IServiceListener)new AccessConfigurationChangeListener());
        this.accessApplicationDataService.addServiceListener((IServiceListener)new AccessUserDataChangeListener());
    }

    public void deInit() {
    }

    @Override
    public boolean isAllowedForPage(String pageId) throws AnoSiteAccessAPIException {
        if (!AnoSiteAccessAPIConfig.getInstance().isEnabled()) {
            return true;
        }
        try {
            Pagex page = this.pagesConfigurationPersistence.getPagex(pageId);
            return this.isAllowed(page.getAccessOperation());
        }
        catch (ASWebDataServiceException e) {
            String message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{pageId});
            LOGGER.error(message, (Throwable)e);
            throw new AnoSiteAccessAPIException(message, (Exception)((Object)e));
        }
    }

    @Override
    public boolean isAllowedForBox(String boxId) throws AnoSiteAccessAPIException {
        if (!AnoSiteAccessAPIConfig.getInstance().isEnabled()) {
            return true;
        }
        try {
            Box box = this.pagesConfigurationPersistence.getBox(boxId);
            return this.isAllowed(box.getAccessOperation());
        }
        catch (ASWebDataServiceException e) {
            String message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{boxId});
            LOGGER.error(message, (Throwable)e);
            throw new AnoSiteAccessAPIException(message, (Exception)((Object)e));
        }
    }

    @Override
    public boolean isAllowedForNaviItem(String naviItemId) throws AnoSiteAccessAPIException {
        if (!AnoSiteAccessAPIConfig.getInstance().isEnabled()) {
            return true;
        }
        try {
            NaviItem naviItem = this.siteDataService.getNaviItem(naviItemId);
            return this.isAllowed(naviItem.getAccessOperation());
        }
        catch (ASSiteDataServiceException e) {
            String message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{naviItemId});
            LOGGER.error(message, (Throwable)e);
            throw new AnoSiteAccessAPIException(message, (Exception)((Object)e));
        }
    }

    @Override
    public boolean isAllowedForAction(String actionId) throws AnoSiteAccessAPIException {
        if (!AnoSiteAccessAPIConfig.getInstance().isEnabled()) {
            return true;
        }
        try {
            CustomActionDef action = this.customActionsConfigurationPersistence.getCustomActionDef(actionId);
            return this.isAllowed(action.getAccessOperation());
        }
        catch (ASCustomActionServiceException e) {
            String message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{actionId});
            LOGGER.error(message, (Throwable)e);
            throw new AnoSiteAccessAPIException(message, (Exception)((Object)e));
        }
    }

    @Override
    public boolean isAllowedForWizard(String wizardId) throws AnoSiteAccessAPIException {
        if (!AnoSiteAccessAPIConfig.getInstance().isEnabled()) {
            return true;
        }
        try {
            WizardDef wizard = this.wizardConfigurationPersistence.getWizardDef(wizardId);
            return this.isAllowed(wizard.getAccessOperation());
        }
        catch (ASWizardDataServiceException e) {
            String message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{wizardId});
            LOGGER.error(message, (Throwable)e);
            throw new AnoSiteAccessAPIException(message, (Exception)((Object)e));
        }
    }

    private boolean isAllowed(String accessOperationId) throws AnoSiteAccessAPIException {
        if (StringUtils.isEmpty((String)accessOperationId)) {
            return true;
        }
        AccessOperation accessOperation = null;
        try {
            accessOperation = this.getAccessOperation(accessOperationId);
        }
        catch (AccessOperationNotFoundAPIException e) {
            LOGGER.warn(LogMessageUtil.failMsg((Throwable)((Object)e), (Object[])new Object[]{accessOperationId}) + " AccessOperation not found. Skipping security check.");
            return true;
        }
        if (accessOperation == null) {
            LOGGER.warn(LogMessageUtil.failMsg((Throwable)new RuntimeException(), (Object[])new Object[]{accessOperationId}) + " AccessOperation not found. Skipping security check.");
            return true;
        }
        if (!this.isLoggedIn()) {
            return false;
        }
        HashSet<String> initializers = new HashSet<String>();
        for (net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission permission : this.getPermissions(accessOperationId)) {
            for (Constraint constraint : this.getConstraint(permission.getConstraints())) {
                for (ContextInitializer contextInitializer : this.getContextInitializers(constraint.getContextInitializers())) {
                    if (contextInitializer == null || StringUtils.isEmpty((String)contextInitializer.getClassName())) continue;
                    initializers.add(contextInitializer.getClassName());
                }
            }
        }
        SecurityObject securityObject = new SecurityObject(this.getCurrentUserId());
        for (String clazz : initializers) {
            String message;
            try {
                Class<?> undefinedClass = Class.forName(clazz);
                if (!SecurityContextInitializer.class.isAssignableFrom(undefinedClass)) {
                    message = LogMessageUtil.failMsg((Throwable)new RuntimeException(), (Object[])new Object[]{accessOperationId}) + " Wrong security context class[" + clazz + "] type.";
                    LOGGER.warn(message);
                    throw new AnoSiteAccessAPIException(message);
                }
                Class<?> initializerClass = undefinedClass;
                SecurityContextInitializer initializer = (SecurityContextInitializer)initializerClass.newInstance();
                Map<String, String> initializedValues = initializer.initialize();
                for (String key : initializedValues.keySet()) {
                    SOAttribute attr = new SOAttribute(key, initializedValues.get(key));
                    securityObject.addAttribute(attr);
                }
            }
            catch (ClassNotFoundException e) {
                message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{accessOperationId}) + " Wrong security context class[" + clazz + "].";
                LOGGER.warn(message, (Throwable)e);
                throw new AnoSiteAccessAPIException(message, e);
            }
            catch (InstantiationException e) {
                message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{accessOperationId}) + " Can't instantiate security context class[" + clazz + "].";
                LOGGER.warn(message, (Throwable)e);
                throw new AnoSiteAccessAPIException(message, e);
            }
            catch (IllegalAccessException e) {
                message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{accessOperationId}) + " Can't instantiate security context class[" + clazz + "].";
                LOGGER.warn(message, (Throwable)e);
                throw new AnoSiteAccessAPIException(message, e);
            }
        }
        try {
            return this.accessService.isAllowed(accessOperation.getId(), securityObject, null).isAllowed();
        }
        catch (AccessServiceException accessServiceException) {
            LOGGER.warn(LogMessageUtil.failMsg((Throwable)accessServiceException, (Object[])new Object[]{accessOperationId}) + " Skipping exception and don't allow execution.", (Throwable)accessServiceException);
            return false;
        }
    }

    private boolean isLoggedIn() {
        return this.loginAPI.isLogedIn();
    }

    private String getCurrentUserId() throws AnoSiteAccessAPIException {
        try {
            return this.loginAPI.getLogedUserId();
        }
        catch (APIException e) {
            throw new AnoSiteAccessAPIException("No logged user.");
        }
    }

    private AccessOperation getAccessOperation(String id) throws AnoSiteAccessAPIException {
        try {
            return this.accessConfigurationService.getAccessOperation(id);
        }
        catch (AccessOperationNotFoundInAnoAccessConfigurationServiceException e) {
            throw new AccessOperationNotFoundAPIException("Access operation with given id[" + id + "] not found.", (Exception)((Object)e));
        }
        catch (AnoAccessConfigurationServiceException e) {
            throw new AnoSiteAccessAPIException(LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{id}), (Exception)((Object)e));
        }
    }

    private List<net.anotheria.anosite.gen.anoaccessconfiguration.data.Role> getRoles() throws AnoSiteAccessAPIException {
        ArrayList<net.anotheria.anosite.gen.anoaccessconfiguration.data.Role> result = new ArrayList<net.anotheria.anosite.gen.anoaccessconfiguration.data.Role>();
        try {
            SortType sorting = new SortType(1, true);
            List loaded = this.accessConfigurationService.getRoles(sorting);
            if (loaded != null && !loaded.isEmpty()) {
                result.addAll(loaded);
            }
            return result;
        }
        catch (AnoAccessConfigurationServiceException e) {
            String message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[0]) + " Can't load roles.";
            LOGGER.error(message, (Throwable)e);
            throw new AnoSiteAccessAPIException(message, (Exception)((Object)e));
        }
    }

    private List<net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission> getPermissions(String accessOperationId) throws AnoSiteAccessAPIException {
        ArrayList<net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission> result = new ArrayList<net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission>();
        try {
            SortType sorting = new SortType(3, false);
            List loaded = this.accessConfigurationService.getPermissionsByProperty("accessOperation", (Object)accessOperationId, sorting);
            if (loaded != null && !loaded.isEmpty()) {
                result.addAll(loaded);
            }
            return result;
        }
        catch (AnoAccessConfigurationServiceException e) {
            String message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{accessOperationId}) + " Can't load permissions.";
            LOGGER.error(message, (Throwable)e);
            throw new AnoSiteAccessAPIException(message, (Exception)((Object)e));
        }
    }

    private List<net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission> getPermissions(List<String> ids) throws AnoSiteAccessAPIException {
        ArrayList<net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission> result = new ArrayList<net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission>();
        if (ids == null || ids.isEmpty()) {
            return result;
        }
        try {
            for (String id : ids) {
                result.add(this.accessConfigurationService.getPermission(id));
            }
            return result;
        }
        catch (AnoAccessConfigurationServiceException e) {
            String message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{ids}) + " Can't load permissions.";
            LOGGER.error(message, (Throwable)e);
            throw new AnoSiteAccessAPIException(message, (Exception)((Object)e));
        }
    }

    private List<Constraint> getConstraint(List<String> ids) throws AnoSiteAccessAPIException {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        if (ids == null || ids.isEmpty()) {
            return result;
        }
        try {
            for (String id : ids) {
                result.add(this.accessConfigurationService.getConstraint(id));
            }
            return result;
        }
        catch (AnoAccessConfigurationServiceException e) {
            String message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{ids}) + " Can't load constraints.";
            LOGGER.error(message, (Throwable)e);
            throw new AnoSiteAccessAPIException(message, (Exception)((Object)e));
        }
    }

    private List<ContextInitializer> getContextInitializers(List<String> ids) throws AnoSiteAccessAPIException {
        ArrayList<ContextInitializer> result = new ArrayList<ContextInitializer>();
        if (ids == null || ids.isEmpty()) {
            return result;
        }
        try {
            for (String id : ids) {
                result.add(this.accessConfigurationService.getContextInitializer(id));
            }
            return result;
        }
        catch (AnoAccessConfigurationServiceException e) {
            String message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{ids}) + " Can't load context initializers.";
            LOGGER.error(message, (Throwable)e);
            throw new AnoSiteAccessAPIException(message, (Exception)((Object)e));
        }
    }

    private synchronized void configureAccessService() throws AnoSiteAccessAPIException {
        this.accessService.reset();
        for (net.anotheria.anosite.gen.anoaccessconfiguration.data.Role role : this.getRoles()) {
            StaticRole configuredRole = new StaticRole(role.getId());
            PermissionCollection permissionCollection = new PermissionCollection(configuredRole.getName());
            for (net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission permission : this.getPermissions(role.getPermissions())) {
                PermissionImpl configuredPermission = new PermissionImpl();
                configuredPermission.setName(permission.getId());
                configuredPermission.setAction(permission.getAccessOperation());
                configuredPermission.setAllow(!permission.getDeny());
                for (Constraint constraint : this.getConstraint(permission.getConstraints())) {
                    String message;
                    if (StringUtils.isEmpty((String)constraint.getClassName())) continue;
                    String clazz = constraint.getClassName();
                    try {
                        Class<?> undefinedClass = Class.forName(clazz);
                        if (!net.anotheria.access.impl.Constraint.class.isAssignableFrom(undefinedClass)) {
                            message = LogMessageUtil.failMsg((Throwable)new RuntimeException(), (Object[])new Object[0]) + " Wrong constraint class[" + clazz + "] type.";
                            LOGGER.warn(message);
                            throw new AnoSiteAccessAPIException(message);
                        }
                        Class<?> constraintClass = undefinedClass;
                        net.anotheria.access.impl.Constraint instance = (net.anotheria.access.impl.Constraint)constraintClass.newInstance();
                        if (instance instanceof ParametrizedConstraint) {
                            ParametrizedConstraint parametrizedInstance = (ParametrizedConstraint)ParametrizedConstraint.class.cast(instance);
                            parametrizedInstance.setParameter1(constraint.getParameter1());
                            parametrizedInstance.setParameter2(constraint.getParameter2());
                            parametrizedInstance.setParameter3(constraint.getParameter3());
                            parametrizedInstance.setParameter4(constraint.getParameter4());
                            parametrizedInstance.setParameter5(constraint.getParameter5());
                        }
                        configuredPermission.addConstraint(instance, new net.anotheria.access.impl.Constraint[0]);
                    }
                    catch (ClassNotFoundException e) {
                        message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[0]) + " Wrong constraint class[" + clazz + "].";
                        LOGGER.warn(message, (Throwable)e);
                        throw new AnoSiteAccessAPIException(message, e);
                    }
                    catch (InstantiationException e) {
                        message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[0]) + " Can't instantiate constraint class[" + clazz + "].";
                        LOGGER.warn(message, (Throwable)e);
                        throw new AnoSiteAccessAPIException(message, e);
                    }
                    catch (IllegalAccessException e) {
                        message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[0]) + " Can't instantiate constraint class[" + clazz + "].";
                        LOGGER.warn(message, (Throwable)e);
                        throw new AnoSiteAccessAPIException(message, e);
                    }
                }
                permissionCollection.add((Permission)configuredPermission, new Permission[0]);
            }
            this.accessService.addPermissionCollection(permissionCollection);
            configuredRole.setPermissionSetId(permissionCollection.getId());
            this.accessService.addRole((Role)configuredRole);
        }
        this.createSecureBoxes();
    }

    private void createSecureBoxes() {
        List userDatas = null;
        SecurityBox securityBox = null;
        UserDef user = null;
        try {
            userDatas = this.accessApplicationDataService.getUserDatas();
        }
        catch (AnoAccessApplicationDataServiceException e) {
            LOGGER.error("Error occurred while getting UserDef by id", (Throwable)e);
            throw new RuntimeException("Error occurred while getting UserDef by id");
        }
        for (UserData userData : userDatas) {
            try {
                user = this.userDataService.getUserDef(userData.getUserId());
            }
            catch (NoSuchDocumentException e1) {
                LOGGER.warn("Couldn't get user by id " + userData.getUserId() + ", {" + userData + "}", (Throwable)e1);
                continue;
            }
            catch (ASUserDataServiceException e) {
                LOGGER.error("Error occurred while getting UserDef by id", (Throwable)e);
                throw new RuntimeException("Error occurred while getting UserDef by id");
            }
            try {
                SaveableID saveableID = new SaveableID();
                saveableID.setSaveableId(user.getLogin());
                saveableID.setOwnerId(user.getLogin());
                securityBox = (SecurityBox)this.securityBoxPersistenceService.read(saveableID);
            }
            catch (CrudServiceException e) {
                LOGGER.warn("SecurityBox with id=" + user.getLogin() + " not found. Creating new one");
            }
            if (securityBox == null) {
                securityBox = new SecurityBox(user.getLogin());
            }
            for (String roleId : userData.getRoles()) {
                if (securityBox.hasRole(roleId)) continue;
                Role role = this.accessService.getRole(roleId);
                try {
                    this.accessService.grantRole(new SecurityObject(user.getLogin()), role.getName());
                }
                catch (AccessServiceException e) {
                    LOGGER.error("Error occurred while granting role " + role.getName() + " to " + user.getLogin(), (Throwable)e);
                    throw new RuntimeException();
                }
            }
        }
    }

    public final class AccessUserDataChangeListener
    implements IServiceListener {
        private final Logger LOGGER = LoggerFactory.getLogger(AccessUserDataChangeListener.class);

        public void documentUpdated(DataObject oldVersion, DataObject newVersion) {
            this.update(oldVersion);
            this.update(newVersion);
        }

        public void documentDeleted(DataObject doc) {
            this.update(doc);
        }

        public void documentCreated(DataObject doc) {
            this.update(doc);
        }

        public void documentImported(DataObject doc) {
        }

        public void persistenceChanged() {
        }

        private void update(DataObject doc) {
            if (!(doc instanceof UserData)) {
                return;
            }
            UserData userData = (UserData)UserData.class.cast(doc);
            this.LOGGER.debug("Access user data changed. Clearing cached user[" + userData.getUserId() + "] data in AccessService...");
            AnoSiteAccessAPIImpl.this.accessService.reset(userData.getUserId());
            this.LOGGER.debug("Clearingfinished.");
        }
    }

    public final class AccessConfigurationChangeListener
    implements IServiceListener {
        private final Logger LOGGER = LoggerFactory.getLogger(AccessUserDataChangeListener.class);

        public void documentUpdated(DataObject oldVersion, DataObject newVersion) {
            this.updateConfiguration();
        }

        public void documentDeleted(DataObject doc) {
            this.updateConfiguration();
        }

        public void documentCreated(DataObject doc) {
            this.updateConfiguration();
        }

        public void documentImported(DataObject doc) {
            this.updateConfiguration();
        }

        public void persistenceChanged() {
            this.updateConfiguration();
        }

        private void updateConfiguration() {
            try {
                this.LOGGER.debug("Access configuration changed. Re-Configuring AccessService...");
                AnoSiteAccessAPIImpl.this.configureAccessService();
                this.LOGGER.debug("Re-Configuration of AccessService finished.");
            }
            catch (AnoSiteAccessAPIException e) {
                this.LOGGER.warn(LogMessageUtil.failMsg((Throwable)((Object)e), (Object[])new Object[0]), (Throwable)((Object)e));
            }
        }
    }
}

