/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.access.storage;

import java.util.List;
import net.anotheria.access.Role;
import net.anotheria.access.impl.MetaInfoStorage;
import net.anotheria.access.impl.SecurityBox;
import net.anotheria.access.storage.persistence.SecurityBoxPersistenceService;
import net.anotheria.anoprise.dualcrud.CrudServiceException;
import net.anotheria.anoprise.dualcrud.ItemNotFoundException;
import net.anotheria.anoprise.dualcrud.Query;
import net.anotheria.anoprise.dualcrud.SaveableID;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserData;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserDataBuilder;
import net.anotheria.anosite.gen.anoaccessapplicationdata.service.AnoAccessApplicationDataServiceException;
import net.anotheria.anosite.gen.anoaccessapplicationdata.service.IAnoAccessApplicationDataService;
import net.anotheria.util.log.LogMessageUtil;
import net.anotheria.util.sorter.SortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class ASGSecurityBoxPersistenceServiceImpl
implements SecurityBoxPersistenceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ASGSecurityBoxPersistenceServiceImpl.class);
    private final IAnoAccessApplicationDataService persistence;

    protected ASGSecurityBoxPersistenceServiceImpl() {
        try {
            this.persistence = (IAnoAccessApplicationDataService)MetaFactory.get(IAnoAccessApplicationDataService.class);
        }
        catch (MetaFactoryException e) {
            String message = "ASGSecurityBoxPersistenceServiceImpl() initialization fail. Can't initialize persistence service.";
            LOGGER.error(MarkerFactory.getMarker((String)"FATAL"), message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    public SecurityBox create(SecurityBox t) throws CrudServiceException {
        return this.save(t);
    }

    public SecurityBox read(SaveableID boxOwner) throws CrudServiceException {
        if (boxOwner == null) {
            throw new IllegalArgumentException("boxOwner argument is null");
        }
        try {
            SortType sorting = new SortType(1, false);
            List resultFromPersistence = this.persistence.getUserDatasByProperty("userId", (Object)boxOwner.getSaveableId(), sorting);
            if (resultFromPersistence == null || resultFromPersistence.isEmpty()) {
                throw new ItemNotFoundException(boxOwner.getSaveableId());
            }
            if (resultFromPersistence.size() > 1) {
                for (UserData toRemove : resultFromPersistence.subList(1, resultFromPersistence.size())) {
                    try {
                        LOGGER.warn("Removing not used data[" + toRemove + "] for box owner[" + boxOwner.getSaveableId() + "]");
                        this.persistence.deleteUserData(toRemove);
                    }
                    catch (AnoAccessApplicationDataServiceException e) {
                        LOGGER.warn("Removing fail and ignored.", (Throwable)e);
                    }
                }
            }
            UserData resultUserData = (UserData)resultFromPersistence.get(0);
            SecurityBox result = new SecurityBox();
            result.setOwnerId(resultUserData.getUserId());
            for (String roleName : resultUserData.getRoles()) {
                try {
                    Role role = MetaInfoStorage.INSTANCE.getRole(roleName);
                    if (role == null) continue;
                    result.addRole(role);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Skipping not exist user role[" + roleName + "] mapped to box owner[" + result.getOwnerId() + "].", (Throwable)e);
                }
            }
            return result;
        }
        catch (AnoAccessApplicationDataServiceException e) {
            String message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{boxOwner.getSaveableId()});
            LOGGER.error(message, (Throwable)e);
            throw new CrudServiceException(message, (Throwable)e);
        }
    }

    public SecurityBox update(SecurityBox box) throws CrudServiceException {
        if (box == null) {
            throw new IllegalArgumentException("box argument is null");
        }
        return this.save(box);
    }

    public void delete(SecurityBox box) throws CrudServiceException {
        if (box == null) {
            throw new IllegalArgumentException("box argument is null");
        }
        try {
            SortType sorting = new SortType(1, false);
            List resultFromPersistence = this.persistence.getUserDatasByProperty("userId", (Object)box.getOwnerId(), sorting);
            if (!resultFromPersistence.isEmpty()) {
                for (UserData toRemove : resultFromPersistence) {
                    this.persistence.deleteUserData(toRemove);
                }
            }
        }
        catch (AnoAccessApplicationDataServiceException e) {
            String message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{box});
            LOGGER.error(message, (Throwable)e);
            throw new CrudServiceException(message, (Throwable)e);
        }
    }

    public SecurityBox save(SecurityBox box) throws CrudServiceException {
        if (box == null) {
            throw new IllegalArgumentException("box argument is null");
        }
        String ownerId = box.getOwnerId();
        List roles = box.getOwnedRoles();
        UserData userData = new UserDataBuilder().userId(ownerId).roles(roles).build();
        try {
            this.delete(box);
            this.persistence.createUserData(userData);
            return box;
        }
        catch (AnoAccessApplicationDataServiceException e) {
            String message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{box});
            LOGGER.error(message, (Throwable)e);
            throw new CrudServiceException(message, (Throwable)e);
        }
    }

    public boolean exists(SecurityBox box) throws CrudServiceException {
        throw new UnsupportedOperationException("yet unimplemented");
    }

    public List<SecurityBox> query(Query q) throws CrudServiceException {
        throw new UnsupportedOperationException("yet unimplemented");
    }
}

