/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.action;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.anosite.action.Action;
import net.anotheria.anosite.action.ActionCommand;
import net.anotheria.anosite.action.ActionMapping;
import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;
import net.anotheria.moskito.core.calltrace.RunningTraceContainer;
import net.anotheria.moskito.core.calltrace.TraceStep;
import net.anotheria.moskito.core.calltrace.TracedCall;
import net.anotheria.moskito.core.context.CurrentMeasurement;
import net.anotheria.moskito.core.context.MoSKitoContext;
import net.anotheria.moskito.core.predefined.ActionStats;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;

public class ActionProducer
implements IStatsProducer {
    private String producerId;
    private final List<IStats> actionStats;
    private ActionStats executeStats;

    public ActionProducer(String id) {
        this.producerId = id;
        this.actionStats = new ArrayList<IStats>();
        this.executeStats = new ActionStats("execute", Constants.getDefaultIntervals());
        this.actionStats.add((IStats)this.executeStats);
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer((IStatsProducer)this);
    }

    public List<IStats> getStats() {
        return this.actionStats;
    }

    public String getProducerId() {
        return this.producerId;
    }

    public String getCategory() {
        return "action";
    }

    public String getSubsystem() {
        return "ano-site";
    }

    protected ActionCommand execute(HttpServletRequest req, HttpServletResponse resp, ActionMapping mapping, Action action) throws Exception {
        CurrentlyTracedCall currentlyTracedCall;
        MoSKitoContext moSKitoContext = MoSKitoContext.get();
        CurrentMeasurement cm = moSKitoContext.notifyProducerEntry((IStatsProducer)this);
        if (cm.isFirst()) {
            cm.setCallDescription("execute " + mapping.toString());
        }
        this.executeStats.addRequest();
        long startTime = System.nanoTime();
        TracedCall aRunningUseCase = RunningTraceContainer.getCurrentlyTracedCall();
        TraceStep currentStep = null;
        CurrentlyTracedCall currentlyTracedCall2 = currentlyTracedCall = aRunningUseCase.callTraced() ? (CurrentlyTracedCall)aRunningUseCase : null;
        if (currentlyTracedCall != null) {
            currentStep = currentlyTracedCall.startStep(this.getProducerId() + '.' + "execute", (IStatsProducer)this, "execute");
        }
        try {
            ActionCommand actionCommand = action.execute(req, resp, mapping);
            return actionCommand;
        }
        catch (Exception e) {
            this.executeStats.notifyError();
            throw e;
        }
        finally {
            long duration = System.nanoTime() - startTime;
            moSKitoContext.notifyProducerExit((IStatsProducer)this);
            cm.notifyProducerFinished();
            this.executeStats.addExecutionTime(duration);
            this.executeStats.notifyRequestFinished();
            if (currentStep != null) {
                currentStep.setDuration(duration);
            }
            if (currentlyTracedCall != null) {
                currentlyTracedCall.endStep();
            }
        }
    }
}

