/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.action.servlet;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.anotheria.anoplass.api.APIFinder;
import net.anotheria.anosite.access.AnoSiteAccessAPI;
import net.anotheria.anosite.action.Action;
import net.anotheria.anosite.action.ActionCommand;
import net.anotheria.anosite.action.ActionMapping;
import net.anotheria.anosite.action.servlet.cms.ActionFactory;
import net.anotheria.anosite.action.servlet.cms.ActionHelper;
import net.anotheria.anosite.gen.ascustomaction.data.ActionMappingDef;
import net.anotheria.anosite.shared.presentation.servlet.BaseAnoSiteServlet;
import net.anotheria.anosite.util.ModelObjectMapper;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionServlet
extends BaseAnoSiteServlet {
    private static Logger LOGGER = LoggerFactory.getLogger(ActionServlet.class);
    private static final long serialVersionUID = 1L;
    private AnoSiteAccessAPI accessAPI;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        LOGGER.info("Init ActionServlet");
        this.accessAPI = (AnoSiteAccessAPI)APIFinder.findAPI(AnoSiteAccessAPI.class);
    }

    protected void moskitoDoGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.execute(req, res);
    }

    protected void moskitoDoPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.execute(req, res);
    }

    private void execute(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String actionMappingName = this.getActionMappingName(req);
        this.out("Calling actionmapping: " + actionMappingName);
        ActionMappingDef def = ActionHelper.lookupActionMapping(actionMappingName);
        this.out("Found def: " + def);
        if (def == null) {
            LOGGER.warn("ActionMapping not found: " + actionMappingName);
            return;
        }
        try {
            if (!StringUtils.isEmpty((String)def.getAction()) && def.getAction().toLowerCase().startsWith("c-") && !this.accessAPI.isAllowedForAction(def.getAction().substring(2))) {
                res.setStatus(403);
                return;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error in AccessAPI. ActionMappingDef: " + def + ", actionMappingName: " + actionMappingName + ")", (Throwable)e);
        }
        ActionMapping mapping = new ActionMapping(def);
        Action action = ActionFactory.createAction(def);
        if (action == null) {
            LOGGER.warn("Couldn't create an action instance...");
            return;
        }
        ModelObjectMapper.map(req, action);
        try {
            ActionCommand ret = action.execute(req, res, mapping);
            this.out("Action returned: " + ret);
            if (ret == null) {
                return;
            }
            switch (ret.getType()) {
                case Forward: {
                    RequestDispatcher dispatcher = req.getRequestDispatcher(ret.getTarget());
                    dispatcher.forward((ServletRequest)req, (ServletResponse)res);
                }
                case Redirect: {
                    res.sendRedirect(ret.getTarget());
                    return;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("execute", (Throwable)e);
        }
    }

    private String getActionMappingName(HttpServletRequest req) {
        return ActionServlet.extractArtifactName(req);
    }

    private void out(Object o) {
        LOGGER.debug("[ActionServlet] " + o);
    }
}

