/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.action.servlet.cms;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.action.Action;
import net.anotheria.anosite.action.ActionProducer;
import net.anotheria.anosite.action.ActionWrapper;
import net.anotheria.anosite.gen.asaction.data.ActionDef;
import net.anotheria.anosite.gen.asaction.service.IASActionService;
import net.anotheria.anosite.gen.ascustomaction.data.ActionMappingDef;
import net.anotheria.util.concurrency.IdBasedLock;
import net.anotheria.util.concurrency.IdBasedLockManager;
import net.anotheria.util.concurrency.SafeIdBasedLockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class ActionFactory {
    private static Logger LOGGER = LoggerFactory.getLogger(ActionFactory.class);
    private static IASActionService service;
    private static Map<String, ActionProducer> producers;
    private static final IdBasedLockManager lockManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Action createAction(ActionMappingDef def) {
        String actionId = def.getAction();
        try {
            ActionDef ad = service.getActionDef(actionId);
            String clazz = ad.getClazz();
            String producerId = clazz + "-" + ad.getId();
            ActionProducer producer = producers.get(producerId);
            if (producer == null) {
                IdBasedLock lock = lockManager.obtainLock((Object)producerId);
                try {
                    lock.lock();
                    producer = new ActionProducer(producerId);
                    producers.put(producerId, producer);
                }
                finally {
                    lock.unlock();
                }
            }
            return new ActionWrapper((Action)Class.forName(clazz).newInstance(), producer);
        }
        catch (Exception e) {
            LOGGER.error("createAction(" + def + ")", (Throwable)e);
            return null;
        }
    }

    static {
        producers = new ConcurrentHashMap<String, ActionProducer>();
        lockManager = new SafeIdBasedLockManager();
        try {
            service = (IASActionService)MetaFactory.get(IASActionService.class);
        }
        catch (MetaFactoryException e) {
            LOGGER.error(MarkerFactory.getMarker((String)"FATAL"), "IASActionService init failure", (Throwable)e);
        }
    }
}

