/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.action.servlet.cms;

import java.util.List;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.ascustomaction.data.ActionMappingDef;
import net.anotheria.anosite.gen.ascustomaction.service.ASCustomActionServiceException;
import net.anotheria.anosite.gen.ascustomaction.service.IASCustomActionService;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.service.IASWebDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class ActionHelper {
    private static Logger LOGGER = LoggerFactory.getLogger(ActionHelper.class);
    private static IASCustomActionService actionService;
    private static IASWebDataService webDataService;

    public static ActionMappingDef lookupActionMapping(String name) {
        try {
            List defs = actionService.getActionMappingDefsByProperty("name", (Object)name);
            if (defs.size() > 1) {
                LOGGER.warn("Multiple mappings for name: " + name + ", returning first, (" + defs + ")");
                return (ActionMappingDef)defs.get(0);
            }
            return defs.size() > 0 ? (ActionMappingDef)defs.get(0) : null;
        }
        catch (ASCustomActionServiceException e) {
            LOGGER.error("lookupActionMapping(" + name + ")", (Throwable)e);
            return null;
        }
    }

    public static String getPageNameForAction(ActionMappingDef def) {
        try {
            Pagex page = webDataService.getPagex(def.getPage());
            return page.getName();
        }
        catch (Exception e) {
            LOGGER.error("getPageNameForAction(" + def + ")", (Throwable)e);
            return null;
        }
    }

    static {
        try {
            actionService = (IASCustomActionService)MetaFactory.get(IASCustomActionService.class);
            webDataService = (IASWebDataService)MetaFactory.get(IASWebDataService.class);
        }
        catch (MetaFactoryException e) {
            LOGGER.error(MarkerFactory.getMarker((String)"FATAL"), "Services init failure", (Throwable)e);
        }
    }
}

