/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.api.feature;

import java.util.List;
import net.anotheria.anodoc.util.context.BrandConfig;
import net.anotheria.anodoc.util.context.ContextManager;
import net.anotheria.anoplass.api.APIException;
import net.anotheria.anoplass.api.APIInitException;
import net.anotheria.anoplass.api.AbstractAPIImpl;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.api.feature.FeatureAPI;
import net.anotheria.anosite.gen.asbrand.data.Brand;
import net.anotheria.anosite.gen.asbrand.service.ASBrandServiceException;
import net.anotheria.anosite.gen.asbrand.service.IASBrandService;
import net.anotheria.anosite.gen.asfeature.data.BrandFeature;
import net.anotheria.anosite.gen.asfeature.data.Feature;
import net.anotheria.anosite.gen.asfeature.service.ASFeatureServiceException;
import net.anotheria.anosite.gen.asfeature.service.IASFeatureService;
import net.anotheria.anosite.guard.ConditionalGuard;
import net.anotheria.anosite.guard.GuardFactory;
import org.configureme.ConfigurationManager;
import org.configureme.Environment;
import org.configureme.GlobalEnvironment;

public class FeatureAPIImpl
extends AbstractAPIImpl
implements FeatureAPI {
    private IASFeatureService featureService;
    private IASBrandService brandService;

    @Override
    public boolean isFeatureActive(String name) throws APIException {
        return this.isSimpleFeature(name) || this.isBrandFeature(name);
    }

    private boolean isSimpleFeature(String name) throws APIException {
        try {
            List featuresList = this.featureService.getFeaturesByProperty("name", (Object)name);
            if (featuresList == null || featuresList.size() == 0) {
                return false;
            }
            if (featuresList.size() > 1) {
                this.log.warn("Found more than 1 feature with name " + name);
                return false;
            }
            Feature f = (Feature)featuresList.get(0);
            if (!f.getEnabled()) {
                return false;
            }
            if (this.getCurrentSystem().startsWith("PROD") && !f.getActiveInProduction()) {
                return false;
            }
            if (f.getObsolete()) {
                this.log.warn("Feature " + f.getName() + " is being used, though it is marked as 'OBSOLETE'");
            }
            return this.processByGuards(f.getGuards(), "Feature: " + name);
        }
        catch (ASFeatureServiceException e) {
            this.log.warn("Feature " + name + " not found, due ", (Throwable)e);
            return false;
        }
    }

    private boolean isBrandFeature(String name) throws APIException {
        try {
            List brandIds;
            List brandFeatureList = this.featureService.getBrandFeaturesByProperty("name", (Object)name);
            if (brandFeatureList == null || brandFeatureList.size() == 0) {
                return false;
            }
            if (brandFeatureList.size() > 1) {
                this.log.warn("Found more than 1 brand feature with name " + name);
                return false;
            }
            BrandFeature brandFeature = (BrandFeature)brandFeatureList.get(0);
            if (!brandFeature.getEnabled()) {
                return false;
            }
            if (this.getCurrentSystem().startsWith("PROD") && !brandFeature.getActiveInProduction()) {
                return false;
            }
            if (brandFeature.getObsolete()) {
                this.log.warn("Brand feature " + brandFeature.getName() + " is being used, though it is marked as 'OBSOLETE'");
            }
            if ((brandIds = brandFeature.getBrands()) == null || brandIds.size() == 0) {
                return true;
            }
            BrandConfig brandConfig = ContextManager.getCallContext().getBrandConfig();
            boolean isValidateByBrand = true;
            if (brandConfig != null) {
                isValidateByBrand = false;
                for (String brandId : brandIds) {
                    try {
                        Brand brand = this.brandService.getBrand(brandId);
                        if (!brand.getName().equals(brandConfig.getName())) continue;
                        isValidateByBrand = true;
                        break;
                    }
                    catch (ASBrandServiceException e) {
                        this.log.warn("Unable to check brand {} for brand feature {}. {}", new Object[]{brandId, name, e.getMessage()});
                    }
                }
            }
            return isValidateByBrand && this.processByGuards(brandFeature.getGuards(), "Brand feature: " + name);
        }
        catch (ASFeatureServiceException e) {
            this.log.warn("Brand feature " + name + " not found, due ", (Throwable)e);
            return false;
        }
    }

    private boolean processByGuards(List<String> gIds, String featureDataStr) {
        if (gIds == null || gIds.size() == 0) {
            return true;
        }
        for (String gid : gIds) {
            ConditionalGuard g = null;
            try {
                g = GuardFactory.getConditionalGuard(gid);
                if (g.isConditionFullfilled(null, null)) continue;
                return false;
            }
            catch (Exception e) {
                this.log.warn("Caught error in guard processing(" + featureDataStr + ", guard: " + g + ", gid: " + gid + ")", (Throwable)e);
            }
        }
        return true;
    }

    public void init() throws APIInitException {
        try {
            this.featureService = (IASFeatureService)MetaFactory.get(IASFeatureService.class);
            this.brandService = (IASBrandService)MetaFactory.get(IASBrandService.class);
        }
        catch (MetaFactoryException e) {
            throw new APIInitException("Feature service not found.");
        }
    }

    public void deInit() {
        this.featureService = null;
        this.brandService = null;
    }

    private String getCurrentSystem() {
        Environment environment;
        Environment resultEnviroment = environment = ConfigurationManager.INSTANCE.getDefaultEnvironment();
        while (environment.isReduceable() && (environment = environment.reduce()) != GlobalEnvironment.INSTANCE) {
            resultEnviroment = environment;
        }
        return resultEnviroment.expandedStringForm().toUpperCase();
    }
}

