/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.bredcrambs.action;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.anosite.bredcrambs.data.DocumentEnum;
import net.anotheria.asg.exception.ConstantNotFoundException;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.maf.json.JSONResponse;
import net.anotheria.util.StringUtils;
import net.anotheria.webutils.actions.BaseAction;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowUsagesOfDocumentAction
extends BaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowUsagesOfDocumentAction.class);
    private static final String UTF_8 = "UTF-8";
    private static final String TEXT_X_JSON = "application/json";
    private static final String DOC_PARAM = "doc";
    private static final String SEARCHED_ELEMENT_ID_PARAM = "pId";
    private static final String REFERENCES_ATTR = "references";

    public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception {
        JSONResponse response = new JSONResponse();
        String doc = req.getParameter(DOC_PARAM);
        String pId = req.getParameter(SEARCHED_ELEMENT_ID_PARAM);
        if (StringUtils.isEmpty((String)doc) || StringUtils.isEmpty((String)pId)) {
            LOGGER.warn("Incoming parameters doc[" + doc + "] or pId[" + pId + "] is empty");
            response.addError("Incoming parameters doc[" + doc + "] or pId[" + pId + "] is empty");
            this.writeTextToResponse(res, response);
            return null;
        }
        List<Object> references = new ArrayList();
        try {
            DocumentEnum DOC = DocumentEnum.getConstantByValue(doc);
            references = DOC.findReferences(pId);
        }
        catch (ConstantNotFoundException e) {
            LOGGER.info("Usages for document[" + doc + "] is not implemented", (Throwable)e);
            response.addError("Usages for document[" + doc + "] is not implemented");
            this.writeTextToResponse(res, response);
            return null;
        }
        JSONObject jsonReferences = new JSONObject();
        jsonReferences.put(REFERENCES_ATTR, references);
        response.setData(jsonReferences);
        this.writeTextToResponse(res, response);
        return null;
    }

    private void writeTextToResponse(HttpServletResponse res, JSONResponse jsonResponse) throws IOException, JSONException {
        res.setCharacterEncoding(UTF_8);
        res.setContentType(TEXT_X_JSON);
        PrintWriter writer = res.getWriter();
        writer.write(jsonResponse.toString());
        writer.flush();
    }
}

