/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.bredcrambs.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.aslayoutdata.data.PageLayout;
import net.anotheria.anosite.gen.aslayoutdata.service.ASLayoutDataServiceException;
import net.anotheria.anosite.gen.aslayoutdata.service.IASLayoutDataService;
import net.anotheria.anosite.gen.assitedata.data.EntryPoint;
import net.anotheria.anosite.gen.assitedata.data.NaviItem;
import net.anotheria.anosite.gen.assitedata.data.PageAlias;
import net.anotheria.anosite.gen.assitedata.data.PageTemplate;
import net.anotheria.anosite.gen.assitedata.data.Site;
import net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException;
import net.anotheria.anosite.gen.assitedata.service.IASSiteDataService;
import net.anotheria.anosite.gen.aswebdata.data.Attribute;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.service.ASWebDataServiceException;
import net.anotheria.anosite.gen.aswebdata.service.IASWebDataService;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.exception.ConstantNotFoundException;
import net.anotheria.util.StringUtils;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public enum DocumentEnum {
    PAGE("PAGEX"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfPage(pId);
        }
    }
    ,
    BOX("BOX"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfBox(pId);
        }
    }
    ,
    ATTRIBUTE("ATTRIBUTE"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfAttribute(pId);
        }
    }
    ,
    SITE("SITE"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfSite(pId);
        }
    }
    ,
    NAVIITEM("NAVIITEM"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfNaviItem(pId);
        }
    }
    ,
    PAGE_TEMPLATE("PAGETEMPLATE"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfPageTemplate(pId);
        }
    }
    ,
    MEDIA_LINK("MEDIALINK"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfMediaLink(pId);
        }
    }
    ,
    SCRIPT("SCRIPT"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfScript(pId);
        }
    }
    ,
    PAGE_ALIAS("PAGEALIAS"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfPageAlias(pId);
        }
    }
    ,
    LAYOUT("PAGELAYOUT"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfLayout(pId);
        }
    }
    ,
    STYLE("PAGESTYLE"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfStyle(pId);
        }
    }
    ,
    GENERIC_BOX_TYPE("GENERICBOXTYPE"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfGenericType(pId);
        }
    }
    ,
    CUSTOM_BOX_TYPE("CUSTOMBOXTYPE"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfCustomType(pId);
        }
    }
    ,
    GENERIC_BOX_HANDLER("GENERICBOXHANDLERDEF"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfGenericHandler(pId);
        }
    }
    ,
    CUSTOM_BOX_HANDLER("CUSTOMBOXHANDLERDEF"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfCustomHandler(pId);
        }
    }
    ,
    GENERIC_GUARD("GENERICGUARDDEF"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfGenericGuard(pId);
        }
    }
    ,
    CUSTOM_GUARD("CUSTOMGUARDDEF"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfCustomGuard(pId);
        }
    }
    ,
    LOCALIZATION_BUNDLE("LOCALIZATIONBUNDLE"){

        @Override
        public List<String> findReferences(String pId) {
            return DocumentEnum.findUsagesOfLocalizationBundle(pId);
        }
    };

    private static final Logger LOGGER;
    private static IASWebDataService webDataService;
    private static IASSiteDataService siteDataService;
    private static IASLayoutDataService layoutDataService;
    private String value;

    private DocumentEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public abstract List<String> findReferences(String var1);

    public static DocumentEnum getConstantByValue(String value) throws ConstantNotFoundException {
        for (DocumentEnum e : DocumentEnum.values()) {
            if (!e.getValue().equalsIgnoreCase(value)) continue;
            return e;
        }
        throw new ConstantNotFoundException("DocumentEnum value not found by value[" + value + "]");
    }

    private static List<String> findUsagesOfBox(String pId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            HashMap<String, Box> mapOfAllBoxes = new HashMap<String, Box>();
            for (Box box : webDataService.getBoxs()) {
                mapOfAllBoxes.put(box.getId(), box);
            }
            for (Pagex pagex : webDataService.getPagexs()) {
                result.addAll(DocumentEnum.findBoxUsages(pagex.getName(), pagex.getC1(), pId, (DataObject)pagex, "c1", mapOfAllBoxes));
                result.addAll(DocumentEnum.findBoxUsages(pagex.getName(), pagex.getC2(), pId, (DataObject)pagex, "c2", mapOfAllBoxes));
                result.addAll(DocumentEnum.findBoxUsages(pagex.getName(), pagex.getC3(), pId, (DataObject)pagex, "c3", mapOfAllBoxes));
                result.addAll(DocumentEnum.findBoxUsages(pagex.getName(), pagex.getHeader(), pId, (DataObject)pagex, "header", mapOfAllBoxes));
                result.addAll(DocumentEnum.findBoxUsages(pagex.getName(), pagex.getFooter(), pId, (DataObject)pagex, "footer", mapOfAllBoxes));
            }
            for (PageTemplate pageTemplate : siteDataService.getPageTemplates()) {
                result.addAll(DocumentEnum.findBoxUsages(pageTemplate.getName(), pageTemplate.getC1first(), pId, (DataObject)pageTemplate, "c1first", mapOfAllBoxes));
                result.addAll(DocumentEnum.findBoxUsages(pageTemplate.getName(), pageTemplate.getC1last(), pId, (DataObject)pageTemplate, "c1last", mapOfAllBoxes));
                result.addAll(DocumentEnum.findBoxUsages(pageTemplate.getName(), pageTemplate.getC2first(), pId, (DataObject)pageTemplate, "c2first", mapOfAllBoxes));
                result.addAll(DocumentEnum.findBoxUsages(pageTemplate.getName(), pageTemplate.getC2last(), pId, (DataObject)pageTemplate, "c2last", mapOfAllBoxes));
                result.addAll(DocumentEnum.findBoxUsages(pageTemplate.getName(), pageTemplate.getC3first(), pId, (DataObject)pageTemplate, "c3first", mapOfAllBoxes));
                result.addAll(DocumentEnum.findBoxUsages(pageTemplate.getName(), pageTemplate.getC3last(), pId, (DataObject)pageTemplate, "c3last", mapOfAllBoxes));
                result.addAll(DocumentEnum.findBoxUsages(pageTemplate.getName(), pageTemplate.getMeta(), pId, (DataObject)pageTemplate, "meta", mapOfAllBoxes));
                result.addAll(DocumentEnum.findBoxUsages(pageTemplate.getName(), pageTemplate.getHeader(), pId, (DataObject)pageTemplate, "header", mapOfAllBoxes));
                result.addAll(DocumentEnum.findBoxUsages(pageTemplate.getName(), pageTemplate.getFooter(), pId, (DataObject)pageTemplate, "footer", mapOfAllBoxes));
            }
            for (Map.Entry entry : mapOfAllBoxes.entrySet()) {
                List subboxList;
                String currentBoxId = (String)entry.getKey();
                if (currentBoxId.equalsIgnoreCase(pId)) continue;
                Box curentBox = (Box)entry.getValue();
                StringBuffer tempPath = new StringBuffer("</br><a href=\"aswebdataBoxEdit?pId=" + currentBoxId + "\" > Box [" + curentBox.getName() + "] </a> ->  <a href=\"aswebdataBoxSubboxesShow?ownerId=" + currentBoxId + "\"> Subboxes </a>");
                if (currentBoxId.equalsIgnoreCase(pId)) {
                    result.add(tempPath + "</br>");
                }
                if ((subboxList = curentBox.getSubboxes()).isEmpty()) continue;
                DocumentEnum.findBoxInSubboxesRecursively(subboxList, pId, tempPath, result, mapOfAllBoxes);
            }
        }
        catch (ASWebDataServiceException e) {
            LOGGER.error("can't retrieve pagex getPagex()", (Throwable)e);
        }
        catch (ASSiteDataServiceException e) {
            LOGGER.error("can't retrieve pagex getPageTemplates()", (Throwable)e);
        }
        return result;
    }

    private static List<String> findBoxUsages(String nameOfPage, List<String> list, String searchElemId, DataObject dataObject, String c, Map<String, Box> mapOfAllBoxes) {
        if (StringUtils.isEmpty((String)searchElemId) || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>();
        String module = "aswebdata";
        if (dataObject.getDefinedName() != null && dataObject.getDefinedName().equalsIgnoreCase("PageTemplate")) {
            module = "assitedata";
        }
        StringBuffer pathBefore = new StringBuffer("</br> <a href=\"" + module + dataObject.getDefinedName() + "Edit?pId=" + dataObject.getId() + "\" >" + dataObject.getDefinedName() + " [" + nameOfPage + "]  </a> -> <a href=\"" + module + dataObject.getDefinedName() + WordUtils.capitalize((String)c) + "Show?ownerId=" + dataObject.getId() + "\" > " + WordUtils.capitalize((String)c) + " </a>");
        for (String id : list) {
            List subboxList;
            Box box = mapOfAllBoxes.get(id);
            if (box == null) continue;
            if (id.equalsIgnoreCase(searchElemId)) {
                ret.add(pathBefore + "</br>");
            }
            if ((subboxList = box.getSubboxes()).isEmpty()) continue;
            DocumentEnum.findBoxInSubboxesRecursively(subboxList, searchElemId, pathBefore.append("-> <a href=\"aswebdataBoxEdit?pId=" + id + "\" > Box [" + box.getName() + "] </a> -> <a href=\"aswebdataBoxSubboxesShow?ownerId=" + id + "\"> Subboxes </a>"), ret, mapOfAllBoxes);
        }
        return ret;
    }

    private static void findBoxInSubboxesRecursively(List<String> list, String searchElementId, StringBuffer pathBefore, List<String> tempList, Map<String, Box> mapOfAllBoxes) {
        for (String id : list) {
            List subboxList;
            Box box = mapOfAllBoxes.get(id);
            if (box == null) continue;
            StringBuffer tempPath = new StringBuffer(" -> <a href=\"aswebdataBoxEdit?pId=" + id + "\" > Box [" + box.getName() + "] </a> ->  <a href=\"aswebdataBoxSubboxesShow?ownerId=" + id + "\"> Subboxes </a>");
            if (id.equalsIgnoreCase(searchElementId)) {
                tempList.add(pathBefore + " </br>");
            }
            if ((subboxList = box.getSubboxes()).isEmpty()) continue;
            DocumentEnum.findBoxInSubboxesRecursively(subboxList, searchElementId, pathBefore.append(tempPath), tempList, mapOfAllBoxes);
        }
    }

    private static List<String> findUsagesOfAttribute(String pId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            StringBuffer pathWithCurrentAttr;
            List subattrubutes;
            Attribute attribute;
            StringBuffer pathBefore;
            HashMap<String, Attribute> mapOfAllAttributes = new HashMap<String, Attribute>();
            for (Attribute attribute2 : webDataService.getAttributes()) {
                mapOfAllAttributes.put(attribute2.getId(), attribute2);
            }
            for (Pagex pagex : webDataService.getPagexs()) {
                pathBefore = new StringBuffer("</br> <a href=\"aswebdataPagexEdit?pId=" + pagex.getId() + "\" > Pagex [" + pagex.getName() + "]  </a> -> <a href=\"aswebdataPagexAttributesShow?ownerId=" + pagex.getId() + "\" > Attributes </a>");
                for (String attributeId : pagex.getAttributes()) {
                    attribute = (Attribute)mapOfAllAttributes.get(attributeId);
                    if (attribute == null) continue;
                    if (attributeId.equalsIgnoreCase(pId)) {
                        result.add(pathBefore + "</br>");
                    }
                    if ((subattrubutes = attribute.getSubattributes()).isEmpty()) continue;
                    pathWithCurrentAttr = new StringBuffer(" ->   <a href=\"aswebdataAttributeEdit?pId=" + attribute.getId() + "\" > Attribute [" + attribute.getName() + "]  </a> -><a href=\"aswebdataAttributeSubattributesShow?ownerId=" + attribute.getId() + "\" > Subattributes </a>");
                    DocumentEnum.findAttributeInSubattributesRecursively(subattrubutes, pId, pathBefore.append(pathWithCurrentAttr), result, mapOfAllAttributes);
                }
            }
            for (Box box : webDataService.getBoxs()) {
                pathBefore = new StringBuffer("</br> <a href=\"aswebdataBoxEdit?pId=" + box.getId() + "\" > Box [" + box.getName() + "]  </a> -> <a href=\"aswebdataBoxAttributesShow?ownerId=" + box.getId() + "\" > Attributes </a>");
                for (String attributeId : box.getAttributes()) {
                    attribute = (Attribute)mapOfAllAttributes.get(attributeId);
                    if (attribute == null) continue;
                    if (attributeId.equalsIgnoreCase(pId)) {
                        result.add(pathBefore + "</br>");
                    }
                    if ((subattrubutes = attribute.getSubattributes()).isEmpty()) continue;
                    pathWithCurrentAttr = new StringBuffer(" ->   <a href=\"aswebdataAttributeEdit?pId=" + attribute.getId() + "\" > Attribute [" + attribute.getName() + "]  </a> -><a href=\"aswebdataAttributeSubattributesShow?ownerId=" + attribute.getId() + "\" > Subattributes </a>");
                    DocumentEnum.findAttributeInSubattributesRecursively(subattrubutes, pId, pathBefore.append(pathWithCurrentAttr), result, mapOfAllAttributes);
                }
            }
            for (Map.Entry entry : mapOfAllAttributes.entrySet()) {
                if (((String)entry.getKey()).equalsIgnoreCase(pId)) continue;
                pathBefore = new StringBuffer("</br> <a href=\"aswebdataAttributeEdit?pId=" + ((Attribute)entry.getValue()).getId() + "\" > Attribute [" + ((Attribute)entry.getValue()).getName() + "]  </a> -> <a href=\"aswebdataAttributeSubattributesShow?ownerId=" + ((Attribute)entry.getValue()).getId() + "\" > Attributes </a>");
                for (String attributeId : ((Attribute)entry.getValue()).getSubattributes()) {
                    attribute = (Attribute)mapOfAllAttributes.get(attributeId);
                    if (attribute == null) continue;
                    if (attributeId.equalsIgnoreCase(pId)) {
                        result.add(pathBefore + "</br>");
                    }
                    if ((subattrubutes = attribute.getSubattributes()).isEmpty()) continue;
                    pathWithCurrentAttr = new StringBuffer(" ->   <a href=\"aswebdataAttributeEdit?pId=" + attribute.getId() + "\" > Attribute [" + attribute.getName() + "]  </a> -><a href=\"aswebdataAttributeSubattributesShow?ownerId=" + attribute.getId() + "\" > Subattributes </a>");
                    DocumentEnum.findAttributeInSubattributesRecursively(subattrubutes, pId, pathBefore.append(pathWithCurrentAttr), result, mapOfAllAttributes);
                }
            }
        }
        catch (ASWebDataServiceException e) {
            LOGGER.error("IASWebDataService failed.", (Throwable)e);
        }
        return result;
    }

    private static void findAttributeInSubattributesRecursively(List<String> listOfSubattributes, String searcheElementId, StringBuffer pathBefore, List<String> resList, Map<String, Attribute> mapOfAllAttributes) {
        for (String subAttributeId : listOfSubattributes) {
            List subattrubutes;
            Attribute attribute = mapOfAllAttributes.get(subAttributeId);
            if (attribute == null) continue;
            if (subAttributeId.equalsIgnoreCase(searcheElementId)) {
                resList.add(pathBefore + "</br>");
            }
            if ((subattrubutes = attribute.getSubattributes()).isEmpty()) continue;
            StringBuffer pathWithCurrentAttr = new StringBuffer(" ->   <a href=\"aswebdataAttributeEdit?pId=" + attribute.getId() + "\" > Attribute [" + attribute.getName() + "]  </a> -><a href=\"aswebdataAttributeSubattributesShow?ownerId=" + attribute.getId() + "\" > subattributes </a>");
            DocumentEnum.findAttributeInSubattributesRecursively(subattrubutes, searcheElementId, pathBefore.append(pathWithCurrentAttr), resList, mapOfAllAttributes);
        }
    }

    private static List<String> findUsagesOfMediaLink(String scriptId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (Pagex p : webDataService.getPagexs()) {
                for (String id : p.getMediaLinks()) {
                    if (!id.equalsIgnoreCase(scriptId)) continue;
                    result.add("</br><a href=\"aswebdataPagexEdit?pId=" + p.getId() + "\" > Page [" + p.getName() + "] </a> - <a href=\"aswebdataPagexScriptsShow?ownerId=" + p.getId() + "\" > MediaLinks </a>");
                }
            }
            for (Box b : webDataService.getBoxs()) {
                for (String id : b.getMediaLinks()) {
                    if (!id.equalsIgnoreCase(scriptId)) continue;
                    result.add("</br><a href=\"aswebdataBoxEdit?pId=" + b.getId() + "\" > Box [" + b.getName() + "] </a> - <a href=\"aswebdataBoxScriptsShow?ownerId=" + b.getId() + "\" > MediaLinks </a>");
                }
            }
            for (PageTemplate pt : siteDataService.getPageTemplates()) {
                for (String id : pt.getMediaLinks()) {
                    if (!id.equalsIgnoreCase(scriptId)) continue;
                    result.add("</br><a href=\"assitedataPageTemplateEdit?pId=" + pt.getId() + "\" > PageTemplete [" + pt.getName() + "] </a> - <a href=\"assitedataPageTemplateScriptsShow?ownerId=" + pt.getId() + "\" > MediaLinks </a>");
                }
            }
        }
        catch (ASWebDataServiceException e) {
            LOGGER.error("failed to use WebDataService.", (Throwable)e);
        }
        catch (ASSiteDataServiceException e) {
            LOGGER.error("failed to use SiteDataService", (Throwable)e);
        }
        return result;
    }

    private static List<String> findUsagesOfScript(String scriptId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (Pagex p : webDataService.getPagexs()) {
                for (String id : p.getScripts()) {
                    if (!id.equalsIgnoreCase(scriptId)) continue;
                    result.add("</br><a href=\"aswebdataPagexEdit?pId=" + p.getId() + "\" > Page [" + p.getName() + "] </a> - <a href=\"aswebdataPagexScriptsShow?ownerId=" + p.getId() + "\" > Scripts </a>");
                }
            }
            for (Box b : webDataService.getBoxs()) {
                for (String id : b.getScripts()) {
                    if (!id.equalsIgnoreCase(scriptId)) continue;
                    result.add("</br><a href=\"aswebdataBoxEdit?pId=" + b.getId() + "\" > Box [" + b.getName() + "] </a> - <a href=\"aswebdataBoxScriptsShow?ownerId=" + b.getId() + "\" > Scripts </a>");
                }
            }
            for (PageTemplate pt : siteDataService.getPageTemplates()) {
                for (String id : pt.getScripts()) {
                    if (!id.equalsIgnoreCase(scriptId)) continue;
                    result.add("</br><a href=\"assitedataPageTemplateEdit?pId=" + pt.getId() + "\" > PageTemplete [" + pt.getName() + "] </a> - <a href=\"assitedataPageTemplateScriptsShow?ownerId=" + pt.getId() + "\" > Scripts </a>");
                }
            }
        }
        catch (ASWebDataServiceException e) {
            LOGGER.error("failed to use WebDataService.", (Throwable)e);
        }
        catch (ASSiteDataServiceException e) {
            LOGGER.error("failed to use SiteDataService", (Throwable)e);
        }
        return result;
    }

    private static List<String> findUsagesOfCustomHandler(String handlerId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (Box b : webDataService.getBoxs()) {
                String searchedId;
                if (b == null || b.getHandler() == null || !(searchedId = "C-" + handlerId).equalsIgnoreCase(b.getHandler())) continue;
                result.add("</br><a href=\"aswebdataBoxEdit?pId=" + b.getId() + "\" > Box [" + b.getName() + "] </a>");
            }
        }
        catch (ASWebDataServiceException e) {
            LOGGER.error("failed to use WebDataService.", (Throwable)e);
        }
        return result;
    }

    private static List<String> findUsagesOfGenericHandler(String handlerId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (Box b : webDataService.getBoxs()) {
                String searchedId;
                if (b == null || b.getHandler() == null || !(searchedId = "G-" + handlerId).equalsIgnoreCase(b.getHandler())) continue;
                result.add("</br><a href=\"aswebdataBoxEdit?pId=" + b.getId() + "\" > Box [" + b.getName() + "] </a>");
            }
        }
        catch (ASWebDataServiceException e) {
            LOGGER.error("failed to use WebDataService.", (Throwable)e);
        }
        return result;
    }

    private static List<String> findUsagesOfCustomType(String typeId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (Box b : webDataService.getBoxs()) {
                String searchedId;
                if (b == null || b.getType() == null || !(searchedId = "C-" + typeId).equalsIgnoreCase(b.getType())) continue;
                result.add("</br><a href=\"aswebdataBoxEdit?pId=" + b.getId() + "\" > Box [" + b.getName() + "] </a>");
            }
        }
        catch (ASWebDataServiceException e) {
            LOGGER.error("failed to use WebDataService.", (Throwable)e);
        }
        return result;
    }

    private static List<String> findUsagesOfGenericType(String typeId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (Box b : webDataService.getBoxs()) {
                String searchedId;
                if (b == null || b.getType() == null || !(searchedId = "G-" + typeId).equalsIgnoreCase(b.getType())) continue;
                result.add("</br><a href=\"aswebdataBoxEdit?pId=" + b.getId() + "\" > Box [" + b.getName() + "]</a>");
            }
        }
        catch (ASWebDataServiceException e) {
            LOGGER.error("failed to use WebDataService.", (Throwable)e);
        }
        return result;
    }

    private static List<String> findUsagesOfGenericGuard(String guardId) {
        ArrayList<String> result = new ArrayList<String>();
        String searchedId = "G-" + guardId;
        try {
            for (Box b : webDataService.getBoxs()) {
                for (String guard : b.getGuards()) {
                    if (!searchedId.equalsIgnoreCase(guard)) continue;
                    result.add("</br><a href=\"aswebdataBoxEdit?pId=" + b.getId() + "\" > Box [" + b.getName() + "] </a> - <a href=\"aswebdataBoxGuardsShow?ownerId=" + b.getId() + "\" > Guards </a>");
                }
            }
            for (Attribute attribute : webDataService.getAttributes()) {
                for (String guard : attribute.getGuards()) {
                    if (!searchedId.equalsIgnoreCase(guard)) continue;
                    result.add("</br><a href=\"aswebdataAttributeEdit?pId=" + attribute.getId() + "\" > Attribute [" + attribute.getName() + "] </a> - <a href=\"aswebdataAttributeGuardsShow?ownerId=" + attribute.getId() + "\" > Guards </a>");
                }
            }
            for (NaviItem naviItem : siteDataService.getNaviItems()) {
                for (String guard : naviItem.getGuards()) {
                    if (!searchedId.equalsIgnoreCase(guard)) continue;
                    result.add("</br><a href=\"assitedataNaviItemEdit?pId=" + naviItem.getId() + "\" > NaviItem [" + naviItem.getName() + "] </a> - <a href=\"assitedataNaviItemGuardsShow?ownerId=" + naviItem.getId() + "\" > Guards </a>");
                }
            }
        }
        catch (ASWebDataServiceException e) {
            LOGGER.error("failed to use WebDataService.", (Throwable)e);
        }
        catch (ASSiteDataServiceException e) {
            LOGGER.error("failed to use SiteDataService.", (Throwable)e);
        }
        return result;
    }

    private static List<String> findUsagesOfCustomGuard(String guardId) {
        ArrayList<String> result = new ArrayList<String>();
        String searchedId = "C-" + guardId;
        try {
            for (Box b : webDataService.getBoxs()) {
                for (String guard : b.getGuards()) {
                    if (!searchedId.equalsIgnoreCase(guard)) continue;
                    result.add("</br><a href=\"aswebdataBoxEdit?pId=" + b.getId() + "\" > Box [" + b.getName() + "] </a> - <a href=\"aswebdataBoxGuardsShow?ownerId=" + b.getId() + "\" > Guards </a>");
                }
            }
            for (Attribute attribute : webDataService.getAttributes()) {
                for (String guard : attribute.getGuards()) {
                    if (!searchedId.equalsIgnoreCase(guard)) continue;
                    result.add("</br><a href=\"aswebdataAttributeEdit?pId=" + attribute.getId() + "\" > Attributes [" + attribute.getName() + "] </a> - <a href=\"aswebdataAttributeGuardsShow?ownerId=" + attribute.getId() + "\" > Guards </a>");
                }
            }
            for (NaviItem naviItem : siteDataService.getNaviItems()) {
                for (String guard : naviItem.getGuards()) {
                    if (!searchedId.equalsIgnoreCase(guard)) continue;
                    result.add("</br><a href=\"assitedataNaviItemEdit?pId=" + naviItem.getId() + "\" > NaviItem [" + naviItem.getName() + "] </a> - <a href=\"assitedataNaviItemGuardsShow?ownerId=" + naviItem.getId() + "\" > Guards </a>");
                }
            }
        }
        catch (ASWebDataServiceException e) {
            LOGGER.error("failed to use WebDataService.", (Throwable)e);
        }
        catch (ASSiteDataServiceException e) {
            LOGGER.error("failed to use SiteDataService.", (Throwable)e);
        }
        return result;
    }

    private static List<String> findUsagesOfPageAlias(String pageAliasId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (NaviItem naviItem : siteDataService.getNaviItems()) {
                if (naviItem == null || naviItem.getPageAlias() == null || !naviItem.getPageAlias().equalsIgnoreCase(pageAliasId)) continue;
                result.add("</br><a href=\"assitedataNaviItemEdit?pId=" + naviItem.getId() + "\" > NaviItem [" + naviItem.getName() + "] </a>");
            }
        }
        catch (ASSiteDataServiceException e) {
            LOGGER.error("failed to use SiteDataService.", (Throwable)e);
        }
        return result;
    }

    private static List<String> findUsagesOfPage(String pageId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (Site site : siteDataService.getSites()) {
                if (site == null || site.getSearchpage() == null || site.getStartpage() == null || !site.getStartpage().equalsIgnoreCase(pageId) && !site.getSearchpage().equalsIgnoreCase(pageId)) continue;
                result.add("</br><a href=\"assitedataSiteEdit?pId=" + site.getId() + "\" > Site [" + site.getName() + "] </a> ");
            }
            for (NaviItem naviItem : siteDataService.getNaviItems()) {
                if (naviItem == null || naviItem.getInternalLink() == null || !naviItem.getInternalLink().equalsIgnoreCase(pageId)) continue;
                result.add("</br><a href=\"assitedataNaviItemEdit?pId=" + naviItem.getId() + "\" > NaviItem [" + naviItem.getName() + "] </a> ");
            }
            for (EntryPoint entryPoint : siteDataService.getEntryPoints()) {
                if (entryPoint == null || entryPoint.getStartPage() == null || !entryPoint.getStartPage().equalsIgnoreCase(pageId)) continue;
                result.add("</br><a href=\"assitedataEntryPointEdit?pId=" + entryPoint.getId() + "\" > EntryPoint [" + entryPoint.getName() + "] </a> ");
            }
            for (PageAlias pageAlias : siteDataService.getPageAliass()) {
                if (pageAlias == null || pageAlias.getTargetPage() == null || !pageAlias.getTargetPage().equalsIgnoreCase(pageId)) continue;
                result.add("</br><a href=\"assitedataPageAliasEdit?pId=" + pageAlias.getId() + "\" > PageAlias [" + pageAlias.getName() + "] </a> ");
            }
        }
        catch (ASSiteDataServiceException e) {
            LOGGER.error("failed to use SiteDataService.", (Throwable)e);
        }
        return result;
    }

    private static List<String> findUsagesOfSite(String siteId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (PageTemplate pageTemplate : siteDataService.getPageTemplates()) {
                if (pageTemplate == null || pageTemplate.getSite() == null || !pageTemplate.getSite().equalsIgnoreCase(siteId)) continue;
                result.add("</br><a href=\"assitedataPageTemplateEdit?pId=" + pageTemplate.getId() + "\" > PageTemplate [" + pageTemplate.getName() + "] </a> ");
            }
            for (EntryPoint entryPoint : siteDataService.getEntryPoints()) {
                if (entryPoint == null || entryPoint.getStartSite() == null || !entryPoint.getStartSite().equalsIgnoreCase(siteId)) continue;
                result.add("</br><a href=\"assitedataEntryPointEdit?pId=" + entryPoint.getId() + "\" > EntryPoint [" + entryPoint.getName() + "] </a> ");
            }
            for (PageAlias pageAlias : siteDataService.getPageAliass()) {
                if (pageAlias == null || pageAlias.getTargetPage() == null || !pageAlias.getTargetPage().equalsIgnoreCase(siteId)) continue;
                result.add("</br><a href=\"assitedataPageAliasEdit?pId=" + pageAlias.getId() + "\" > PageAlias [" + pageAlias.getName() + "] </a> ");
            }
        }
        catch (ASSiteDataServiceException e) {
            LOGGER.error("failed to use SiteDataService.", (Throwable)e);
        }
        return result;
    }

    private static List<String> findUsagesOfPageTemplate(String pageTemplateId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (Pagex p : webDataService.getPagexs()) {
                if (p == null || p.getTemplate() == null || !p.getTemplate().equalsIgnoreCase(pageTemplateId)) continue;
                result.add("</br><a href=\"aswebdataPagexEdit?pId=" + p.getId() + "\" > Page [" + p.getName() + "] </a>");
            }
        }
        catch (ASWebDataServiceException e) {
            LOGGER.error("failed to use WebDataService.", (Throwable)e);
        }
        return result;
    }

    private static List<String> findUsagesOfLayout(String layoutId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (PageTemplate pageTemplate : siteDataService.getPageTemplates()) {
                if (pageTemplate == null || pageTemplate.getLayout() == null || !pageTemplate.getLayout().equalsIgnoreCase(layoutId)) continue;
                result.add("</br><a href=\"assitedataPageTemplateEdit?pId=" + pageTemplate.getId() + "\" > PageTemplate [" + pageTemplate.getName() + "] </a> ");
            }
        }
        catch (ASSiteDataServiceException e) {
            LOGGER.error("failed to use SiteDataService.", (Throwable)e);
        }
        return result;
    }

    private static List<String> findUsagesOfStyle(String styleId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (PageLayout pageLayout : layoutDataService.getPageLayouts()) {
                if (pageLayout == null || pageLayout.getStyle() == null || !pageLayout.getStyle().equalsIgnoreCase(styleId)) continue;
                result.add("</br><a href=\"aslayoutdataPageLayoutEdit?pId=" + pageLayout.getId() + "\" > Layout [" + pageLayout.getName() + "] </a> ");
            }
        }
        catch (ASLayoutDataServiceException e) {
            LOGGER.error("failed to use LayoutDataService.", (Throwable)e);
        }
        return result;
    }

    private static List<String> findUsagesOfNaviItem(String naviItemId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            HashMap<String, NaviItem> mapOfAllNaviItems = new HashMap<String, NaviItem>();
            for (NaviItem naviItem : siteDataService.getNaviItems()) {
                mapOfAllNaviItems.put(naviItem.getId(), naviItem);
            }
            for (Map.Entry entry : mapOfAllNaviItems.entrySet()) {
                for (String naviId : ((NaviItem)entry.getValue()).getSubNavi()) {
                    List subNaviList;
                    StringBuffer pathBefore = new StringBuffer("</br><a href=\"assitedataNaviItemEdit?pId=" + ((NaviItem)entry.getValue()).getId() + "\" > NaviItem [" + ((NaviItem)entry.getValue()).getName() + "] </a> -> <a href=\"assitedataNaviItemSubNaviShow?ownerId=" + ((NaviItem)entry.getValue()).getId() + "\" > SubNavi </a>");
                    NaviItem tempNaviItem = (NaviItem)mapOfAllNaviItems.get(naviId);
                    if (tempNaviItem == null) continue;
                    if (naviId.equalsIgnoreCase(naviItemId)) {
                        result.add(pathBefore + "</br>");
                    }
                    if ((subNaviList = tempNaviItem.getSubNavi()).isEmpty()) continue;
                    StringBuffer pathWithCurrentSubNavi = new StringBuffer(" -> </br><a href=\"assitedataNaviItemEdit?pId=" + tempNaviItem.getId() + "\" > NaviItem [" + tempNaviItem.getName() + "] </a> -><a href=\"assitedataNaviItemSubNaviShow?ownerId=" + tempNaviItem.getId() + "\" > SubNavi </a>");
                    DocumentEnum.findNaviItemInSubNaviRecursively(subNaviList, naviItemId, pathBefore.append(pathWithCurrentSubNavi), result, mapOfAllNaviItems);
                }
            }
            for (Site site : siteDataService.getSites()) {
                if (site == null || site.getTopNavi() == null || site.getMainNavi() == null) continue;
                if (!site.getTopNavi().isEmpty()) {
                    StringBuffer pathBeforeTopNavi = new StringBuffer("</br><a href=\"assitedataSiteEdit?pId=" + site.getId() + "\" > Site [" + site.getName() + "] </a> -> <a href=\"assitedataSiteTopNaviShow?ownerId=" + site.getId() + "\" > TopNavi </a>");
                    DocumentEnum.findNaviItemInSubNaviRecursively(site.getTopNavi(), naviItemId, pathBeforeTopNavi, result, mapOfAllNaviItems);
                }
                if (site.getMainNavi().isEmpty()) continue;
                StringBuffer pathBeforeMainNavi = new StringBuffer("</br><a href=\"assitedataSiteEdit?pId=" + site.getId() + "\" > Site [" + site.getName() + "] </a> -> <a href=\"assitedataSiteMainNaviShow?ownerId=" + site.getId() + "\" > TopNavi </a>");
                DocumentEnum.findNaviItemInSubNaviRecursively(site.getTopNavi(), naviItemId, pathBeforeMainNavi, result, mapOfAllNaviItems);
            }
        }
        catch (ASSiteDataServiceException e) {
            LOGGER.error("failed to use SiteDataService.", (Throwable)e);
        }
        return result;
    }

    private static void findNaviItemInSubNaviRecursively(List<String> listOfSubNavi, String searcheElementId, StringBuffer pathBefore, List<String> resList, Map<String, NaviItem> mapOfAllNaviItems) {
        for (String subNaviId : listOfSubNavi) {
            List subNaviList;
            NaviItem naviItem = mapOfAllNaviItems.get(subNaviId);
            if (naviItem == null) continue;
            if (subNaviId.equalsIgnoreCase(searcheElementId)) {
                resList.add(pathBefore + "</br>");
            }
            if ((subNaviList = naviItem.getSubNavi()).isEmpty()) continue;
            StringBuffer pathWithCurrentAttr = new StringBuffer(" ->  <a href=\"assitedataNaviItemEdit?pId=" + naviItem.getId() + "\" > NaviItem [" + naviItem.getName() + "] </a></br><a href=\"assitedataNaviItemSubNaviShow?ownerId=" + naviItem.getId() + "\" > SubNavi </a>");
            DocumentEnum.findNaviItemInSubNaviRecursively(subNaviList, searcheElementId, pathBefore.append(pathWithCurrentAttr), resList, mapOfAllNaviItems);
        }
    }

    private static List<String> findUsagesOfLocalizationBundle(String bundleId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            result.addAll(DocumentEnum.findUsagesOfLocalizationBundleInBoxes(bundleId));
            result.addAll(DocumentEnum.findUsagesOfLocalizationBundleInPages(bundleId));
            result.addAll(DocumentEnum.findUsagesOfLocalizationBundleInTemplates(bundleId));
        }
        catch (ASWebDataServiceException e) {
            LOGGER.error("failed to use ASWebDataService.", (Throwable)e);
        }
        catch (ASSiteDataServiceException e) {
            LOGGER.error("failed to use ASSiteDataService.", (Throwable)e);
        }
        return result;
    }

    private static List<String> findUsagesOfLocalizationBundleInBoxes(String bundleId) throws ASWebDataServiceException {
        ArrayList<String> responses = new ArrayList<String>();
        for (Box box : webDataService.getBoxs()) {
            String response = new ResponseBuilder().setContainerUrlType("aswebdataBox").setContainerType("Box").setContainerId(box.getId()).setContainerName(box.getName()).setContentType("Localizations").build();
            responses.addAll(DocumentEnum.findUsages(bundleId, box.getLocalizations(), response));
        }
        return responses;
    }

    private static List<String> findUsagesOfLocalizationBundleInPages(String bundleId) throws ASWebDataServiceException {
        ArrayList<String> responses = new ArrayList<String>();
        for (Pagex pagex : webDataService.getPagexs()) {
            String response = new ResponseBuilder().setContainerUrlType("aswebdataPagex").setContainerType("Page").setContainerId(pagex.getId()).setContainerName(pagex.getName()).setContentType("Localizations").build();
            responses.addAll(DocumentEnum.findUsages(bundleId, pagex.getLocalizations(), response));
        }
        return responses;
    }

    private static List<String> findUsagesOfLocalizationBundleInTemplates(String bundleId) throws ASSiteDataServiceException {
        ArrayList<String> responses = new ArrayList<String>();
        for (PageTemplate pageTemplate : siteDataService.getPageTemplates()) {
            String response = new ResponseBuilder().setContainerUrlType("assitedataPageTemplate").setContainerType("PageTemplate").setContainerId(pageTemplate.getId()).setContainerName(pageTemplate.getName()).setContentType("Localizations").build();
            responses.addAll(DocumentEnum.findUsages(bundleId, pageTemplate.getLocalizations(), response));
        }
        return responses;
    }

    private static List<String> findUsages(String contentId, List<String> containerElemIds, String response) {
        ArrayList<String> responses = new ArrayList<String>();
        for (String otherId : containerElemIds) {
            if (!otherId.equals(contentId)) continue;
            responses.add(response);
        }
        return responses;
    }

    static {
        LOGGER = LoggerFactory.getLogger(DocumentEnum.class);
        try {
            webDataService = (IASWebDataService)MetaFactory.get(IASWebDataService.class);
            siteDataService = (IASSiteDataService)MetaFactory.get(IASSiteDataService.class);
            layoutDataService = (IASLayoutDataService)MetaFactory.get(IASLayoutDataService.class);
        }
        catch (MetaFactoryException e) {
            LOGGER.error(MarkerFactory.getMarker((String)"FATAL"), "Services init failure", (Throwable)e);
        }
    }

    private static class ResponseBuilder {
        public static final String RESPONSE_TEMPLATE = "</br><a href=\"%sEdit?pId=%s\"> %s [%s] </a> -> <a href=\"%s%sShow?ownerId=%s\"> %s </a>";
        private String containerUrlType;
        private String containerType;
        private String containerId;
        private String containerName;
        private String contentType;

        private ResponseBuilder() {
        }

        public ResponseBuilder setContainerUrlType(String containerUrlType) {
            this.containerUrlType = containerUrlType;
            return this;
        }

        public ResponseBuilder setContainerType(String containerType) {
            this.containerType = containerType;
            return this;
        }

        public ResponseBuilder setContainerId(String containerId) {
            this.containerId = containerId;
            return this;
        }

        public ResponseBuilder setContainerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public ResponseBuilder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public String build() {
            return String.format(RESPONSE_TEMPLATE, this.containerUrlType, this.containerId, this.containerType, this.containerName, this.containerUrlType, this.contentType, this.containerId, this.contentType);
        }
    }
}

