/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.cms.action;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.anosite.cms.user.CMSUserManager;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.webutils.actions.BaseAction;

public class ChangePassAction
extends BaseAction {
    private static final String LOGIN_PAGE_PATH = "/cms/login";
    private static final String INDEX_PAGE_PATH = "/cms/index";
    private static final String P_IS_SUBMIT = "pIsSubmit";
    private static final String P_OLD_PASS = "pOldPass";
    private static final String P_NEW_PASS_1 = "pNewPass1";
    private static final String P_NEW_PASS_2 = "pNewPass2";
    private static final String BEAN_CHANGE_PASS_PAGE_MESSAGE = "Message";
    private static final String BEAN_USER_DEF_ID = "currentUserDefId";

    public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception {
        String userId = (String)this.getBeanFromSession(req, BEAN_USER_DEF_ID);
        String login = CMSUserManager.getLoginById(userId);
        if (req.getParameter(P_IS_SUBMIT) == null && this.isAuthorizationRequired()) {
            boolean authorized = this.checkAuthorization(req);
            if (!authorized) {
                res.sendRedirect(LOGIN_PAGE_PATH);
                return null;
            }
            this.addBeanToRequest(req, BEAN_CHANGE_PASS_PAGE_MESSAGE, "Fill this fields to change password.");
            return mapping.findCommand("success");
        }
        CMSUserManager manager = CMSUserManager.getInstance();
        String oldPass = req.getParameter(P_OLD_PASS);
        if (req.getParameter(P_IS_SUBMIT).equals("true") && manager.canLoginUser(login, oldPass)) {
            String newPass1 = req.getParameter(P_NEW_PASS_1);
            String newPass2 = req.getParameter(P_NEW_PASS_2);
            if (newPass1.isEmpty()) {
                this.addBeanToRequest(req, BEAN_CHANGE_PASS_PAGE_MESSAGE, "Enter new password, please.");
                return mapping.findCommand("success");
            }
            if (!newPass1.equals(newPass2)) {
                this.addBeanToRequest(req, BEAN_CHANGE_PASS_PAGE_MESSAGE, "Entered password doesn't match with confirmed.");
                return mapping.findCommand("success");
            }
            CMSUserManager.changeUserPassword(login, newPass1);
            CMSUserManager.scanUsers();
            res.sendRedirect(INDEX_PAGE_PATH);
            return null;
        }
        this.addBeanToRequest(req, BEAN_CHANGE_PASS_PAGE_MESSAGE, "Incorrect current password.");
        return mapping.findCommand("success");
    }

    protected boolean checkAuthorization(HttpServletRequest req) {
        String userId = (String)this.getBeanFromSession(req, "currentUserId");
        return userId != null;
    }

    protected boolean isAuthorizationRequired() {
        return true;
    }
}

