/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.cms.action;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundleDocument;
import net.anotheria.anosite.gen.asresourcedata.service.IASResourceDataService;
import net.anotheria.anosite.gen.shared.action.BaseToolsAction;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;

public class LocalizationBundleExportToTxtAction
extends BaseToolsAction {
    private final IASResourceDataService iasResourceDataService;

    public LocalizationBundleExportToTxtAction() {
        try {
            this.iasResourceDataService = (IASResourceDataService)MetaFactory.get(IASResourceDataService.class);
        }
        catch (MetaFactoryException e) {
            throw new RuntimeException("Unable to create service", e);
        }
    }

    protected boolean isAuthorizationRequired() {
        return true;
    }

    public ActionCommand anoDocExecute(ActionMapping aMapping, HttpServletRequest aReq, HttpServletResponse aRes) throws Exception {
        String locale = aReq.getParameter("locale");
        try {
            List localizationBundles = this.iasResourceDataService.getLocalizationBundles();
            StringBuilder sb = new StringBuilder();
            for (LocalizationBundle bundle : localizationBundles) {
                String[] values;
                LocalizationBundleDocument bundleDocument;
                StringProperty stringProperty;
                if (!(bundle instanceof LocalizationBundleDocument) || (stringProperty = (bundleDocument = (LocalizationBundleDocument)bundle).getStringProperty("messages_" + locale)) == null || stringProperty.getString() == null) continue;
                String messages = stringProperty.getString();
                for (String row : values = messages.split("\n")) {
                    if ((row = row.trim()).isEmpty()) continue;
                    sb.append(bundle.getId()).append(".").append(row).append("\n");
                }
            }
            aRes.getOutputStream().write(sb.toString().getBytes(StandardCharsets.UTF_8));
            aRes.getOutputStream().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String getTitle() {
        return "LocalizationBundleExportToTxt";
    }

    protected String getCurrentDocumentDefName() {
        return null;
    }

    protected String getCurrentModuleDefName() {
        return null;
    }
}

