/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.cms.action;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.anosite.cms.user.CMSUserManager;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.webutils.actions.AccessControlMafAction;

public class LoginAction
extends AccessControlMafAction {
    public static final String P_USER_LOGIN = "pUserLogin";
    public static final String P_PASSWORD = "pPassword";
    private static final String BEAN_USER_DEF_ID = "currentUserDefId";
    private CMSUserManager userManager = CMSUserManager.getInstance();

    public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception {
        String userId;
        String login;
        CMSUserManager.scanUsers();
        try {
            String authString = null;
            String cookieName = this.getAuthCookieName(req);
            for (Cookie c : req.getCookies()) {
                if (c == null || !c.getName().equals(cookieName)) continue;
                authString = this.getCryptTool().decryptFromHex(c.getValue()).trim();
                break;
            }
            if (authString != null) {
                int index = authString.indexOf(58);
                String login2 = authString.substring(0, index);
                String password = authString.substring(index + 1);
                String userId2 = CMSUserManager.getIdByLogin(login2);
                if (login2 != null && password != null && this.userManager.canLoginUser(login2, password)) {
                    this.addBeanToSession(req, "currentUserId", login2);
                    this.addBeanToSession(req, BEAN_USER_DEF_ID, userId2);
                    res.sendRedirect(this.getRedirectTarget(req));
                    return null;
                }
            }
        }
        catch (Exception e) {
            this.log.warn("read auth from cookie", (Throwable)e);
        }
        try {
            login = LoginAction.getStringParameter((HttpServletRequest)req, (String)P_USER_LOGIN);
            String password = LoginAction.getStringParameter((HttpServletRequest)req, (String)P_PASSWORD);
            if (!this.userManager.canLoginUser(login, password)) {
                throw new RuntimeException("Can't login.");
            }
            userId = CMSUserManager.getIdByLogin(login);
            res.addCookie(this.createAuthCookie(req, login, password));
        }
        catch (Exception e) {
            return mapping.success();
        }
        this.addBeanToSession(req, "currentUserId", login);
        this.addBeanToSession(req, BEAN_USER_DEF_ID, userId);
        res.sendRedirect(this.getRedirectTarget(req));
        return null;
    }

    private String getRedirectTarget(HttpServletRequest req) {
        String authParam = "auth=true";
        Object redT = (String)req.getSession().getAttribute("anoDocTargetAction");
        if (redT == null) {
            String servletPath = req.getServletPath();
            servletPath = servletPath.substring(0, servletPath.lastIndexOf(47));
            return req.getContextPath() + servletPath + "/index?" + authParam;
        }
        if (!((String)redT).startsWith("/")) {
            redT = "/" + (String)redT;
        }
        redT = ((String)redT).indexOf(63) == -1 ? (String)redT + "?" : (String)redT + "&";
        redT = (String)redT + authParam;
        return redT;
    }
}

