/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.cms.listener;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.anotheria.anosite.access.AnoSiteAccessAPIImpl;
import net.anotheria.anosite.config.AutoTransfer;
import net.anotheria.anosite.config.AutoTransferConfig;
import net.anotheria.anosite.gen.asresourcedata.data.Image;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.util.listener.IServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AutoTransferListener
implements IServiceListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnoSiteAccessAPIImpl.class);
    private String filename;

    public AutoTransferListener(String moduleId) {
        this.filename = moduleId;
    }

    public void documentUpdated(DataObject dataObject, DataObject dataObject1) {
        this.copyModule(dataObject1, false);
    }

    public void documentDeleted(DataObject dataObject) {
        this.copyModule(dataObject, true);
    }

    public void documentCreated(DataObject dataObject) {
        this.copyModule(dataObject, false);
    }

    public void documentImported(DataObject dataObject) {
        this.copyModule(dataObject, false);
    }

    public void persistenceChanged() {
    }

    private void copyModule(DataObject dataObject, boolean isDeleted) {
        AutoTransfer[] autoTransfers = AutoTransferConfig.getInstance().getAutoTransfers();
        if (autoTransfers != null) {
            for (AutoTransfer autoTransfer : autoTransfers) {
                if (dataObject instanceof Image) {
                    this.processImageDocument((Image)dataObject, autoTransfer, isDeleted);
                }
                String source = autoTransfer.getSourceDir() + "/content/" + this.filename + ".dat";
                String dest = autoTransfer.getCopyDir() + "/content/" + this.filename + ".dat";
                this.copyFiles(new File(source), new File(dest));
                File lockFile = new File(autoTransfer.getCopyDir() + "/content/locks/" + this.filename + ".lock");
                lockFile.delete();
            }
        }
    }

    private void processImageDocument(Image image, AutoTransfer autoTransfer, boolean isDeleted) {
        File imageSource = new File(autoTransfer.getSourceDir() + "/files/" + image.getImage());
        File imageDest = new File(autoTransfer.getCopyDir() + "/files/" + image.getImage());
        if (isDeleted) {
            imageDest.delete();
        } else {
            this.copyFiles(imageSource, imageDest);
        }
    }

    private void copyFiles(File source, File dest) {
        try (FileInputStream is = new FileInputStream(source);
             FileOutputStream os = new FileOutputStream(dest);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while performing auto transfer. ", (Throwable)e);
        }
    }
}

