/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.cms.listener;

import net.anotheria.anoplass.api.APICallContext;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.util.listener.IServiceListener;
import net.anotheria.util.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRUDLogListener
implements IServiceListener {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"cms-crud-log");
    private static final String SEPARATOR = " , ";

    public void documentUpdated(DataObject dataObject, DataObject dataObject1) {
        this.logData("UPDATE", this.createObjString(dataObject, dataObject1));
    }

    public void documentDeleted(DataObject dataObject) {
        this.logData("DELETE", this.createObjString(dataObject));
    }

    public void documentCreated(DataObject dataObject) {
        this.logData("CREATE", this.createObjString(dataObject));
    }

    public void documentImported(DataObject dataObject) {
        this.logData("IMPORT", this.createObjString(dataObject));
    }

    public void persistenceChanged() {
        this.logData("PERSISTENCE CHANGED", null);
    }

    private String createObjString(DataObject ... dataObjects) {
        Object result = "";
        int count = 0;
        for (DataObject obj : dataObjects) {
            result = (String)result + (count == 0 ? " DOCUMENT [ id : " + obj.getId() + " ] " : " DOCUMENT" + count + " [ id : " + obj.getId() + " ] ");
            ++count;
        }
        result = (String)result + " --> class(zz) : " + dataObjects[0].getClass().toString().substring(dataObjects[0].getClass().toString().lastIndexOf(".") + 1);
        return result;
    }

    private void logData(String operation, String objData) {
        String user = APICallContext.getCallContext().getCurrentUserId();
        String editor = APICallContext.getCallContext().getCurrentEditorId();
        String time = NumberUtils.makeISO8601TimestampString((long)System.currentTimeMillis());
        LOGGER.info(time + SEPARATOR + operation + " ,  uid : " + user + " , eid : " + editor + SEPARATOR + objData);
    }
}

