/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.cms.listener;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.anodoc.query2.QueryNotEqualProperty;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.cms.user.CMSUserManager;
import net.anotheria.anosite.gen.asuserdata.data.UserDef;
import net.anotheria.anosite.gen.asuserdata.service.ASUserDataServiceException;
import net.anotheria.anosite.gen.asuserdata.service.IASUserDataService;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.util.listener.IServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserListener
implements IServiceListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserListener.class);
    private static final IASUserDataService userDataService;

    public void documentUpdated(DataObject dataObject, DataObject dataObject1) {
        if (dataObject instanceof UserDef) {
            this.updateUser(dataObject, dataObject1);
        }
    }

    public void documentDeleted(DataObject dataObject) {
    }

    public void documentCreated(DataObject dataObject) {
        if (dataObject instanceof UserDef) {
            this.updateUser(null, dataObject);
        }
    }

    public void documentImported(DataObject dataObject) {
        if (dataObject instanceof UserDef) {
            this.updateUser(null, dataObject);
        }
    }

    public void persistenceChanged() {
    }

    private void updateUser(DataObject old, DataObject updated) {
        UserDef userDef = (UserDef)old;
        UserDef userDefNew = (UserDef)updated;
        boolean shouldUpdate = false;
        if (userDef != null && this.isDifferent(userDef.getLogin(), userDefNew.getLogin()) && this.isTryingToCreateExistedLogin(userDef)) {
            userDefNew.setLogin(userDefNew.getLogin() + userDefNew.getId());
            shouldUpdate = true;
        }
        if (this.isDifferent(userDef != null ? userDef.getPassword() : null, userDefNew.getPassword()) || !userDefNew.getPassword().contains(CMSUserManager.getHashMarker())) {
            userDefNew.setPassword(CMSUserManager.hashPassword(userDefNew.getPassword()));
            shouldUpdate = true;
        }
        if (shouldUpdate) {
            try {
                userDataService.updateUserDef(userDefNew);
            }
            catch (ASUserDataServiceException e) {
                LOGGER.error("ASUserDataService for UserListener failed", (Throwable)e);
                throw new RuntimeException("ASUserDataService for UserListener failed", e);
            }
        }
        CMSUserManager.scanUsers();
    }

    private <T> boolean isDifferent(T obj1, T obj2) {
        return obj1 != null && !obj1.equals(obj2) || obj2 != null && !obj2.equals(obj1);
    }

    private boolean isTryingToCreateExistedLogin(UserDef userDef) {
        try {
            ArrayList<Object> props = new ArrayList<Object>();
            props.add(new QueryProperty("login", (Object)userDef.getLogin()));
            props.add(new QueryNotEqualProperty("id", (Object)userDef.getId()));
            List existedUserDefs = userDataService.getUserDefsByProperty(props.toArray(new QueryProperty[props.size()]));
            return existedUserDefs != null && !existedUserDefs.isEmpty();
        }
        catch (ASUserDataServiceException e) {
            LOGGER.error("ASUserDataService for UserListener failed", (Throwable)e);
            throw new RuntimeException("ASUserDataService for UserListener failed", e);
        }
    }

    static {
        try {
            userDataService = (IASUserDataService)MetaFactory.get(IASUserDataService.class);
        }
        catch (MetaFactoryException e) {
            LOGGER.error("MetaFactory for UserListener failed", (Throwable)e);
            throw new RuntimeException("MetaFactory for UserListener failed", e);
        }
    }
}

