/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.cms.translation;

import com.theokanning.openai.completion.chat.ChatCompletionChoice;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.ChatMessageRole;
import com.theokanning.openai.service.OpenAiService;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.anotheria.anosite.cms.translation.IASGTranslationService;
import net.anotheria.anosite.config.LocalizationAutoTranslationTokenConfig;
import net.anotheria.anosite.gen.shared.service.BasicService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IASGTranslationTranslationServiceImpl
extends BasicService
implements IASGTranslationService {
    private static IASGTranslationTranslationServiceImpl instance;
    private static final Logger log;
    private static final String PROMPT = "You will get a localizations in format 'key'='translation'. Translate it from %s to %s without any explanations.\nLocalizations:\n \"\"\"\n%s\n\"\"\"";
    private LocalizationAutoTranslationTokenConfig config = LocalizationAutoTranslationTokenConfig.getInstance();
    private OpenAiService openAiService = new OpenAiService(this.config.getToken(), Duration.ofSeconds(240L));

    @Override
    public String translate(String originLanguage, String targetLanguage, String bundleContent) {
        String result = "";
        String formattedPrompt = String.format(PROMPT, originLanguage, targetLanguage, bundleContent);
        ArrayList<ChatMessage> chatMessageList = new ArrayList<ChatMessage>();
        chatMessageList.add(new ChatMessage(ChatMessageRole.SYSTEM.value(), formattedPrompt));
        ChatCompletionRequest chatCompletionRequest = ChatCompletionRequest.builder().model("gpt-3.5-turbo").messages(chatMessageList).user("testing").temperature(Double.valueOf(0.0)).build();
        int maxAttempts = 15;
        int currentAttempt = 1;
        while (currentAttempt <= maxAttempts) {
            try {
                Iterator iterator;
                List choices = this.openAiService.createChatCompletion(chatCompletionRequest).getChoices();
                if (choices.isEmpty() || !(iterator = choices.iterator()).hasNext()) continue;
                ChatCompletionChoice choice = (ChatCompletionChoice)iterator.next();
                return choice.getMessage().getContent();
            }
            catch (RuntimeException ex) {
                if (ex.getMessage().toLowerCase().contains("http") || ex.getMessage().toLowerCase().contains("timeout") || ex.getMessage().toLowerCase().contains("that model is currently overloaded with other requests")) {
                    log.error("Cannot translate localizations. Exception: {}.\n Attempt #{}", (Object)ex.getMessage(), (Object)currentAttempt);
                    ++currentAttempt;
                    continue;
                }
                log.error("Cannot translate localizations. Exception: {}.", (Object)ex.getMessage());
                break;
            }
        }
        return result;
    }

    static IASGTranslationTranslationServiceImpl getInstance() {
        if (instance == null) {
            instance = new IASGTranslationTranslationServiceImpl();
        }
        return instance;
    }

    static {
        log = LoggerFactory.getLogger(IASGTranslationTranslationServiceImpl.class);
    }
}

