/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.cms.user;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.anotheria.util.StringUtils;

public class CMSUser {
    private String username;
    private String password;
    private List<String> roles = new ArrayList<String>();

    public CMSUser() {
    }

    public CMSUser(String aUserName, String aPassword) {
        this();
        this.username = aUserName;
        this.password = aPassword;
    }

    public CMSUser(String aUserName, String aPassword, List<String> someRoles) {
        this(aUserName, aPassword);
        if (someRoles != null) {
            this.roles.addAll(someRoles);
        }
    }

    public CMSUser(String aUserName, String aPassword, String commaSeparatedListWithRoles) {
        this(aUserName, aPassword, CMSUser.parseRoles(commaSeparatedListWithRoles));
    }

    public boolean isUserInRole(String role) {
        return this.roles.indexOf(role) != -1 || this.roles.indexOf("*") != -1;
    }

    public String toString() {
        return "Username: " + this.getUsername() + ", Password: " + this.getPassword() + ", Roles: " + this.getRoles();
    }

    private static List<String> parseRoles(String rolesString) {
        return rolesString == null ? new ArrayList<String>() : Arrays.asList(StringUtils.tokenize((String)rolesString.trim(), (char)','));
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void addRole(String aRole) {
        this.roles.add(aRole);
    }
}

