/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.cms.user;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.cms.user.CMSUser;
import net.anotheria.anosite.gen.asuserdata.data.RoleDef;
import net.anotheria.anosite.gen.asuserdata.data.RoleDefBuilder;
import net.anotheria.anosite.gen.asuserdata.data.UserDef;
import net.anotheria.anosite.gen.asuserdata.data.UserDefBuilder;
import net.anotheria.anosite.gen.asuserdata.service.ASUserDataServiceException;
import net.anotheria.anosite.gen.asuserdata.service.IASUserDataService;
import net.anotheria.util.crypt.MD5Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSUserManager {
    private static Logger LOGGER = LoggerFactory.getLogger(CMSUserManager.class);
    private static Map<String, CMSUser> users;
    private static IASUserDataService userDataService;
    private static CMSUserManager instance;
    private static boolean inited;

    private CMSUserManager() {
        if (!inited) {
            throw new RuntimeException("CMS user manager is not initialized");
        }
    }

    public static CMSUserManager getInstance() {
        if (instance == null) {
            instance = new CMSUserManager();
        }
        return instance;
    }

    public boolean canLoginUser(String login, String password) {
        CMSUser user = users.get(login);
        password = CMSUserManager.hashPassword(password);
        if (user == null) {
            return false;
        }
        return user.getPassword().equals(password);
    }

    public boolean userInRole(String login, String role) {
        return this.isKnownUser(login) && users.get(login).isUserInRole(role);
    }

    public boolean isKnownUser(String login) {
        return users.containsKey(login);
    }

    public static void init() {
        if (inited) {
            return;
        }
        users = new ConcurrentHashMap<String, CMSUser>();
        try {
            userDataService = (IASUserDataService)MetaFactory.get(IASUserDataService.class);
            CMSUserManager.createNecessaryDefaultRolesAndUsers();
            CMSUserManager.scanUsers();
            inited = true;
        }
        catch (MetaFactoryException e) {
            LOGGER.error("init failed", (Throwable)e);
            throw new RuntimeException("MetaFactory failed", e);
        }
    }

    private static void createNecessaryDefaultRolesAndUsers() {
        try {
            CMSUserManager.addDefaultRole("developer");
            CMSUserManager.addDefaultRole("cmsuser");
            CMSUserManager.addDefaultRole("editor");
            CMSUserManager.addDefaultRole("producer");
            CMSUserManager.addDefaultRole("admin");
            CMSUserManager.addDefaultUser("admin", "admin", "admin");
        }
        catch (ASUserDataServiceException e) {
            LOGGER.error("ASUserDataService failed", (Throwable)e);
            throw new RuntimeException("ASUserDataService failed", e);
        }
    }

    private static void addDefaultUser(String login, String password, String role) throws ASUserDataServiceException {
        List userDefs = userDataService.getUserDefsByProperty("login", (Object)login);
        if (userDefs == null || userDefs.isEmpty()) {
            List roleDefs = userDataService.getRoleDefsByProperty("name", (Object)role);
            if (roleDefs == null || roleDefs.isEmpty()) {
                LOGGER.error("There is no admin role for admin user in CMS");
                throw new RuntimeException("admin role for admin user is undefined");
            }
            RoleDef adminRole = (RoleDef)roleDefs.get(0);
            UserDefBuilder userDefBuilder = new UserDefBuilder();
            userDefBuilder.login(login);
            userDefBuilder.password(password);
            userDefBuilder.status(Arrays.asList(adminRole.getId()));
            userDataService.createUserDef(userDefBuilder.build());
        }
    }

    private static void addDefaultRole(String role) throws ASUserDataServiceException {
        List roleDefs = userDataService.getRoleDefsByProperty("name", (Object)role);
        if (roleDefs == null || roleDefs.isEmpty()) {
            RoleDefBuilder roleDefBuilder = new RoleDefBuilder();
            roleDefBuilder.name(role);
            userDataService.createRoleDef(roleDefBuilder.build());
        }
    }

    public static void changeUserPassword(String login, String newPassword) {
        try {
            UserDef user = CMSUserManager.getUserDefByLogin(login);
            user.setPassword(CMSUserManager.hashPassword(newPassword));
            userDataService.updateUserDef(user);
        }
        catch (ASUserDataServiceException e) {
            LOGGER.error("change user password failed", (Throwable)e);
            throw new RuntimeException("ASUserDataService failed", e);
        }
    }

    public static String hashPassword(String plainTextPassword) {
        return MD5Util.getMD5Hash((String)plainTextPassword) + CMSUserManager.getHashMarker();
    }

    public static String getHashMarker() {
        return "//hash";
    }

    public static String getIdByLogin(String login) {
        return CMSUserManager.getUserDefByLogin(login).getId();
    }

    public static String getLoginById(String id) {
        try {
            return userDataService.getUserDef(id).getLogin();
        }
        catch (ASUserDataServiceException e) {
            LOGGER.error("get user def by login failed", (Throwable)e);
            throw new RuntimeException("ASUserDataService failed", e);
        }
    }

    private static UserDef getUserDefByLogin(String login) {
        try {
            List userDefs = userDataService.getUserDefsByProperty("login", (Object)login);
            if (userDefs.isEmpty()) {
                throw new RuntimeException("User with login[" + login + "] not found");
            }
            return (UserDef)userDefs.get(0);
        }
        catch (ASUserDataServiceException e) {
            LOGGER.error("get user def by login failed", (Throwable)e);
            throw new RuntimeException("ASUserDataService failed", e);
        }
    }

    public static void scanUsers() {
        try {
            List usersList = userDataService.getUserDefs();
            users.clear();
            for (UserDef userDef : usersList) {
                String username = userDef.getLogin();
                String password = userDef.getPassword();
                List rolesIds = userDef.getStatus();
                ArrayList<String> roles = new ArrayList<String>();
                if (rolesIds != null && !rolesIds.isEmpty()) {
                    for (String roleId : rolesIds) {
                        RoleDef roleDef = userDataService.getRoleDef(roleId);
                        if (roleDef == null) continue;
                        roles.add(roleDef.getName());
                    }
                }
                CMSUser userToAdd = new CMSUser(username, password, roles);
                users.put(userToAdd.getUsername(), userToAdd);
            }
        }
        catch (ASUserDataServiceException e) {
            LOGGER.error("scan users failed", (Throwable)e);
            throw new RuntimeException("ASUserDataService failed", e);
        }
    }
}

