/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.config;

import java.io.Serializable;
import java.util.Arrays;
import net.anotheria.anosite.config.AutoTransfer;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.configureme.annotations.DontConfigure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigureMe(name="auto-transfer-config")
public final class AutoTransferConfig
implements Serializable {
    @DontConfigure
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoTransferConfig.class);
    @DontConfigure
    private static final Object LOCK = new Object();
    @DontConfigure
    private static volatile AutoTransferConfig instance;
    @Configure
    private AutoTransfer[] autoTransfers;

    private AutoTransferConfig() {
        try {
            ConfigurationManager.INSTANCE.configure((Object)this);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("AutoTransferConfig() configuration fail [" + e.getMessage() + "]");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.warn("AutoTransferConfig() configured with [" + this.toString() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AutoTransferConfig getInstance() {
        if (instance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = new AutoTransferConfig();
                }
            }
        }
        return instance;
    }

    public AutoTransfer[] getAutoTransfers() {
        return this.autoTransfers;
    }

    public void setAutoTransfers(AutoTransfer[] autoTransfers) {
        this.autoTransfers = autoTransfers;
    }

    public String toString() {
        return "AutoTransferConfig{autoTransfers=" + Arrays.toString(this.autoTransfers) + "}";
    }
}

