/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.config;

import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.configureme.annotations.DontConfigure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigureMe(name="ano-site-localization-auto-translation-config")
public class LocalizationAutoTranslationConfig {
    @DontConfigure
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalizationAutoTranslationConfig.class);
    private static LocalizationAutoTranslationConfig INSTANCE;
    @Configure
    private String openAIToken;
    @Configure
    @SerializedName(value="@languages")
    private LanguageParameter[] languages;
    @DontConfigure
    private Map<String, String> languagesMap = new HashMap<String, String>();

    private LocalizationAutoTranslationConfig() {
        try {
            ConfigurationManager.INSTANCE.configure((Object)this);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Configuration fail[" + e.getMessage() + "]. Relaying on defaults.");
        }
        for (LanguageParameter language : this.languages) {
            this.languagesMap.put(language.key, language.value);
        }
    }

    public String getOpenAIToken() {
        return this.openAIToken;
    }

    public void setOpenAIToken(String openAIToken) {
        this.openAIToken = openAIToken;
    }

    public void setLanguages(LanguageParameter[] languages) {
        this.languages = languages;
    }

    public Map<String, String> getLanguagesMap() {
        return this.languagesMap;
    }

    public void setLanguagesMap(Map<String, String> languagesMap) {
        this.languagesMap = languagesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalizationAutoTranslationConfig getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<LocalizationAutoTranslationConfig> clazz = LocalizationAutoTranslationConfig.class;
        synchronized (LocalizationAutoTranslationConfig.class) {
            INSTANCE = new LocalizationAutoTranslationConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public String toString() {
        return "LocalizationAutoTranslationConfig{openAIToken='" + this.openAIToken + "', languagesMapConfig=" + this.languages + "}";
    }

    @ConfigureMe
    public static class LanguageParameter {
        @Configure
        private String key;
        @Configure
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return "LanguageParameter{key='" + this.key + "', value='" + this.value + "'}";
        }
    }
}

