/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.config;

import java.io.Serializable;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.configureme.annotations.DontConfigure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigureMe(name="ano-site-resource-delivery-config")
public final class ResourceDeliveryConfig
implements Serializable {
    @DontConfigure
    private static final long serialVersionUID = -366101733489839363L;
    @DontConfigure
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ResourceDeliveryConfig.class.getName());
    @DontConfigure
    private static ResourceDeliveryConfig INSTANCE;
    @Configure
    private boolean useForCMSEnabled = false;
    @Configure
    private String servletMapping = "rd";
    @Configure
    private boolean useAppVersionInURL = false;
    @Configure
    private String versionPrefix = "V-";
    @Configure
    private boolean resourceNeverExpire = false;

    public static synchronized ResourceDeliveryConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ResourceDeliveryConfig();
        }
        return INSTANCE;
    }

    private ResourceDeliveryConfig() {
        try {
            ConfigurationManager.INSTANCE.configure((Object)this);
            LOGGER.info("ResourceDeliveryConfig() Configured. Configuration[" + this.toString() + "].");
        }
        catch (Exception e) {
            LOGGER.warn("ResourceDeliveryConfig() Configuration failed. Configuring with defaults[" + this.toString() + "].");
        }
    }

    public boolean isUseForCMSEnabled() {
        return this.useForCMSEnabled;
    }

    public void setUseForCMSEnabled(boolean aUseForCMSEnabled) {
        this.useForCMSEnabled = aUseForCMSEnabled;
    }

    public String getServletMapping() {
        return this.servletMapping;
    }

    public void setServletMapping(String aServletMapping) {
        this.servletMapping = aServletMapping;
    }

    public boolean isUseAppVersionInURL() {
        return this.useAppVersionInURL;
    }

    public void setUseAppVersionInURL(boolean aUseAppVersionInURL) {
        this.useAppVersionInURL = aUseAppVersionInURL;
    }

    public boolean isResourceNeverExpire() {
        return this.resourceNeverExpire;
    }

    public void setResourceNeverExpire(boolean aResourceNeverExpire) {
        this.resourceNeverExpire = aResourceNeverExpire;
    }

    public String getVersionPrefix() {
        return this.versionPrefix;
    }

    public void setVersionPrefix(String aVersionPrefix) {
        this.versionPrefix = aVersionPrefix;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceDeliveryConfig [");
        builder.append("useForCMSEnabled=" + this.useForCMSEnabled);
        builder.append(", servletMapping=" + this.servletMapping);
        builder.append(", useAppVersionInURL=" + this.useAppVersionInURL);
        builder.append(", versionPrefix=" + this.versionPrefix);
        builder.append(", resourceNeverExpire=" + this.resourceNeverExpire);
        builder.append("]");
        return builder.toString();
    }
}

