/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.assitedata.data.EntryPoint;
import net.anotheria.anosite.gen.assitedata.data.Site;
import net.anotheria.anosite.gen.assitedata.service.IASSiteDataService;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.service.IASWebDataService;
import net.anotheria.anosite.gen.shared.data.PageAliasTypeEnum;
import net.anotheria.anosite.gen.shared.service.AnoDocConfigurator;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.asg.exception.ConstantNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class EntryPointFilter
implements Filter {
    private static Logger LOGGER = LoggerFactory.getLogger(EntryPointFilter.class);
    private IASWebDataService webDataService;
    private IASSiteDataService siteDataService;

    public void destroy() {
    }

    public void doFilter(ServletRequest sreq, ServletResponse sres, FilterChain chain) throws IOException, ServletException {
        if (!(sreq instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest req = (HttpServletRequest)sreq;
        req.setCharacterEncoding(AnoDocConfigurator.getEncoding());
        String domain = req.getServerName();
        EntryPoint forDomain = null;
        EntryPoint defaultEntry = null;
        try {
            PageAliasTypeEnum command;
            List entryPoints = this.siteDataService.getEntryPoints();
            for (EntryPoint p : entryPoints) {
                if (defaultEntry == null && p.getDefaultEntry()) {
                    defaultEntry = p;
                }
                List domains = p.getDomains();
                for (String d : domains) {
                    if (!d.equals(domain)) continue;
                    forDomain = p;
                    break;
                }
                if (forDomain == null) continue;
                break;
            }
            EntryPoint myEntryPoint = forDomain == null ? defaultEntry : forDomain;
            Pagex targetPage = null;
            if (myEntryPoint == null) {
                List sites = this.siteDataService.getSites();
                if (sites == null || sites.size() == 0) {
                    LOGGER.error("No sites found, dont know where to send user.");
                } else {
                    Site firstSite = (Site)sites.get(0);
                    if (firstSite.getStartpage() == null || firstSite.getStartpage().length() == 0) {
                        LOGGER.error("First site doesnt have a startpage.");
                    } else {
                        targetPage = this.webDataService.getPagex(firstSite.getStartpage());
                    }
                }
            } else {
                targetPage = myEntryPoint.getStartPage() != null && myEntryPoint.getStartPage().length() > 0 ? this.webDataService.getPagex(myEntryPoint.getStartPage()) : this.webDataService.getPagex(this.siteDataService.getSite(myEntryPoint.getStartSite()).getStartpage());
            }
            if (targetPage == null) {
                chain.doFilter(sreq, sres);
                return;
            }
            String urlQuery = req.getQueryString();
            urlQuery = urlQuery != null && urlQuery.length() > 0 ? "?" + urlQuery : "";
            String pageUrl = targetPage.getName() + ".html" + urlQuery;
            try {
                command = myEntryPoint != null ? PageAliasTypeEnum.getConstantByValue((int)myEntryPoint.getType()) : PageAliasTypeEnum.REDIRECT;
            }
            catch (ConstantNotFoundException e) {
                command = PageAliasTypeEnum.REDIRECT;
            }
            switch (command) {
                case MASK: {
                    LOGGER.info("EntryPoint forwarding to: " + pageUrl);
                    req.getRequestDispatcher(pageUrl).forward(sreq, sres);
                    return;
                }
            }
            String targetUrl = req.getContextPath() + req.getServletPath() + pageUrl;
            LOGGER.info("EntryPoint redirecting to: " + targetUrl);
            ((HttpServletResponse)sres).sendRedirect(targetUrl);
            return;
        }
        catch (ASGRuntimeException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        try {
            this.webDataService = (IASWebDataService)MetaFactory.get(IASWebDataService.class);
            this.siteDataService = (IASSiteDataService)MetaFactory.get(IASSiteDataService.class);
        }
        catch (MetaFactoryException e) {
            LOGGER.error(MarkerFactory.getMarker((String)"FATAL"), "ASG services init failure", (Throwable)e);
            throw new ServletException("ASG services init failure", (Throwable)e);
        }
    }
}

