/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import net.anotheria.anodoc.util.context.BrandConfig;
import net.anotheria.anodoc.util.context.ContextManager;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.asbrand.data.Brand;
import net.anotheria.anosite.gen.asbrand.service.ASBrandServiceException;
import net.anotheria.anosite.gen.asbrand.service.IASBrandService;
import net.anotheria.anosite.gen.shared.service.AnoDocConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class LanguageFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LanguageFilter.class);
    private IASBrandService brandService;

    public void destroy() {
    }

    public void doFilter(ServletRequest rq, ServletResponse rs, FilterChain chain) throws IOException, ServletException {
        String lang;
        if (!(rq instanceof HttpServletRequest)) {
            chain.doFilter(rq, rs);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)rq;
        req.setCharacterEncoding(AnoDocConfigurator.getEncoding());
        HttpSession session = req.getSession();
        String pLang = req.getParameter("lang");
        if (pLang != null) {
            session.setAttribute("anosite.sa..lang", (Object)pLang);
        }
        if ((lang = (String)session.getAttribute("anosite.sa..lang")) != null) {
            ContextManager.getCallContext().setCurrentLanguage(lang);
        } else {
            lang = ContextManager.getCallContext().getCurrentLanguage();
        }
        Locale toSet = new Locale(lang);
        session.setAttribute("anosite.sa..lang", (Object)lang);
        this.prepareBrand(req);
        chain.doFilter(rq, rs);
    }

    private void prepareBrand(HttpServletRequest req) {
        List brands2;
        BrandConfig brandConfig = ContextManager.getCallContext().getBrandConfig();
        if (brandConfig != null && brandConfig.getUrlsToMap().contains(req.getServerName())) {
            req.getSession().setAttribute("anosite.sa..brand", (Object)brandConfig.getName());
            return;
        }
        Brand brand = null;
        try {
            brands2 = this.brandService.getBrands();
            for (Brand b : brands2) {
                if (!b.getUrlsToMap().contains(req.getServerName())) continue;
                brand = b;
                break;
            }
        }
        catch (ASBrandServiceException brands2) {
            // empty catch block
        }
        if (brand == null) {
            try {
                brands2 = this.brandService.getBrandsByProperty("defaultBrand", (Object)true);
                if (brands2 == null || brands2.size() == 0) {
                    LOGGER.warn("Default brand not found");
                } else if (brands2.size() > 1) {
                    LOGGER.warn("Default brand more than 1.");
                } else {
                    brand = (Brand)brands2.get(0);
                }
            }
            catch (ASBrandServiceException e) {
                LOGGER.error("Unable to get default brand. {}", (Object)e.getMessage());
            }
        }
        if (brand == null) {
            LOGGER.error("Brand is null for " + req.getServerName());
            return;
        }
        brandConfig = new BrandConfig(brand.getName(), brand.getDefaultBrand(), brand.getUrlsToMap(), brand.getLocalizations(), brand.getMediaLinks(), brand.getAttributes());
        ContextManager.getCallContext().setBrandConfig(brandConfig);
        req.getSession().setAttribute("anosite.sa..brand", (Object)brandConfig.getName());
    }

    public void init(FilterConfig arg0) throws ServletException {
        AnoDocConfigurator.configure();
        try {
            this.brandService = (IASBrandService)MetaFactory.get(IASBrandService.class);
        }
        catch (MetaFactoryException e) {
            LOGGER.error(MarkerFactory.getMarker((String)"FATAL"), "ASG services init failure", (Throwable)e);
            throw new ServletException("ASG services init failure", (Throwable)e);
        }
    }
}

