/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.assitedata.data.PageAlias;
import net.anotheria.anosite.gen.assitedata.service.IASSiteDataService;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.service.IASWebDataService;
import net.anotheria.anosite.gen.shared.data.PageAliasTypeEnum;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class PageAliasFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageAliasFilter.class);
    private IASWebDataService webDataService;
    private IASSiteDataService siteDataService;

    public void init(FilterConfig config) throws ServletException {
        try {
            this.webDataService = (IASWebDataService)MetaFactory.get(IASWebDataService.class);
            this.siteDataService = (IASSiteDataService)MetaFactory.get(IASSiteDataService.class);
        }
        catch (MetaFactoryException e) {
            LOGGER.error(MarkerFactory.getMarker((String)"FATAL"), "ASG services init failure", (Throwable)e);
            throw new ServletException("ASG services init failure", (Throwable)e);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest sreq, ServletResponse sres, FilterChain chain) throws IOException, ServletException {
        if (!(sreq instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest req = (HttpServletRequest)sreq;
        String pathStr = req.getServletPath();
        LOGGER.info("Resolving alias for path: " + pathStr);
        if (pathStr == null || pathStr.length() < 2) {
            chain.doFilter(sreq, sres);
            return;
        }
        List<PathEntity> path = this.parsePath(pathStr);
        try {
            List aliases = this.siteDataService.getPageAliass();
            for (PageAlias alias : aliases) {
                for (String aliasPathStr : alias.getPathes()) {
                    List<PathEntity> aliasPath = this.parsePath(aliasPathStr);
                    if (!this.matchPaths(aliasPath, path)) continue;
                    LOGGER.info("found page alias hit " + pathStr + " to page: " + alias.getTargetPage());
                    Pagex target = this.webDataService.getPagex(alias.getTargetPage());
                    Object urlQuery = this.convertPathToQuery(aliasPath, path) + "&" + alias.getParameters().trim();
                    LOGGER.info("Query: " + (String)urlQuery);
                    if (StringUtils.isEmpty((String)urlQuery)) {
                        urlQuery = req.getQueryString();
                    }
                    if (StringUtils.isEmpty((String)urlQuery)) {
                        urlQuery = "";
                    } else if (!((String)urlQuery).startsWith("?")) {
                        urlQuery = "?" + (String)urlQuery;
                    }
                    String targetUrl = target.getName() + ".html" + (String)urlQuery;
                    LOGGER.info("Alias: " + targetUrl);
                    PageAliasTypeEnum command = PageAliasTypeEnum.getConstantByValue((int)alias.getType());
                    switch (command) {
                        case MASK: {
                            req.getRequestDispatcher("/" + targetUrl).forward(sreq, sres);
                            return;
                        }
                        case REDIRECT: {
                            ((HttpServletResponse)sres).sendRedirect(req.getContextPath() + "/" + targetUrl);
                            return;
                        }
                    }
                    ((HttpServletResponse)sres).sendRedirect(req.getContextPath() + "/" + targetUrl);
                    return;
                }
            }
        }
        catch (ASGRuntimeException e) {
            LOGGER.error("doFilter", (Throwable)e);
        }
        chain.doFilter(sreq, sres);
    }

    private List<PathEntity> parsePath(String pathStr) {
        if (pathStr.startsWith("/")) {
            pathStr = StringUtils.remove((String)pathStr, (int)0, (int)1);
        }
        if (pathStr.endsWith("/")) {
            pathStr = StringUtils.remove((String)pathStr, (int)(pathStr.length() - 1), (int)1);
        }
        ArrayList<PathEntity> ret = new ArrayList<PathEntity>();
        List pathTockens = StringUtils.tokenize2list((String)pathStr, (char)'/');
        for (String tocken : pathTockens) {
            boolean convertable = StringUtils.isSurroundedWith((String)tocken, (char)'<', (char)'>');
            String name = convertable ? StringUtils.removeSurround((String)tocken) : tocken;
            ret.add(new PathEntity(name, convertable));
        }
        return ret;
    }

    private boolean matchPaths(List<PathEntity> patternPath, List<PathEntity> path) {
        if (patternPath.size() != path.size()) {
            return false;
        }
        for (int i = 0; i < patternPath.size(); ++i) {
            if (patternPath.get(i).conform(path.get(i))) continue;
            return false;
        }
        return true;
    }

    private String convertPathToQuery(List<PathEntity> patternPath, List<PathEntity> path) {
        ArrayList<CallSite> parameters = new ArrayList<CallSite>();
        for (int i = 0; i < patternPath.size(); ++i) {
            if (!patternPath.get(i).isConvertable()) continue;
            parameters.add((CallSite)((Object)(patternPath.get(i).getName() + "=" + path.get(i).getName())));
        }
        return StringUtils.concatenateTokens(parameters, (String)"&");
    }

    private static class PathEntity {
        String name;
        boolean convertable;

        public PathEntity(String aName, boolean aConvertable) {
            this.name = aName;
            this.convertable = aConvertable;
        }

        public String getName() {
            return this.name;
        }

        public boolean isConvertable() {
            return this.convertable;
        }

        public boolean conform(PathEntity other) {
            return this.convertable || this.name.equals(other.name);
        }

        public String toString() {
            return "PathEntity [name=" + this.name + ", convertable=" + this.convertable + "]";
        }
    }
}

