/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.asresourcedata.data.Image;
import net.anotheria.anosite.gen.asresourcedata.service.ASResourceDataServiceException;
import net.anotheria.anosite.gen.asresourcedata.service.IASResourceDataService;
import net.anotheria.util.StringUtils;
import net.anotheria.webutils.filehandling.servlet.FileDeliveryServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliasFileDeliveryServlet
extends FileDeliveryServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliasFileDeliveryServlet.class);
    private static final long serialVersionUID = -9048929437969384125L;
    private IASResourceDataService service;

    public AliasFileDeliveryServlet() {
        try {
            this.service = (IASResourceDataService)MetaFactory.get(IASResourceDataService.class);
        }
        catch (MetaFactoryException e) {
            LOGGER.error("AliasFileDeliveryServlet()", (Throwable)e);
            throw new RuntimeException("AliasFileDeliveryServlet()", e);
        }
    }

    protected String getRequestedResourceName(HttpServletRequest req) throws ServletException {
        String name = super.getRequestedResourceName(req);
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        try {
            for (Image image : this.service.getImages()) {
                if (!image.getAlias().equals(name)) continue;
                return image.getImage();
            }
        }
        catch (ASResourceDataServiceException e) {
            LOGGER.error("getRequestedResourceName()", (Throwable)e);
            throw new ServletException("getRequestedResourceName()", (Throwable)e);
        }
        return null;
    }
}

