/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.servlet;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.anodoc.util.context.BrandConfig;
import net.anotheria.anodoc.util.context.ContextManager;
import net.anotheria.anoplass.api.APICallContext;
import net.anotheria.anoplass.api.APIFinder;
import net.anotheria.anoplass.api.session.APISession;
import net.anotheria.anoplass.api.session.APISessionImpl;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.access.AnoSiteAccessAPI;
import net.anotheria.anosite.access.AnoSiteAccessAPIException;
import net.anotheria.anosite.api.configuration.SystemConfigurationAPI;
import net.anotheria.anosite.config.ResourceDeliveryConfig;
import net.anotheria.anosite.content.bean.AttributeBean;
import net.anotheria.anosite.content.bean.AttributeMap;
import net.anotheria.anosite.content.bean.BoxBean;
import net.anotheria.anosite.content.bean.BoxTypeBean;
import net.anotheria.anosite.content.bean.BreadCrumbItemBean;
import net.anotheria.anosite.content.bean.MediaLinkBean;
import net.anotheria.anosite.content.bean.NaviItemBean;
import net.anotheria.anosite.content.bean.PageBean;
import net.anotheria.anosite.content.bean.ScriptBean;
import net.anotheria.anosite.content.bean.SiteBean;
import net.anotheria.anosite.content.bean.StylesheetBean;
import net.anotheria.anosite.content.servlet.BrowsingHistory;
import net.anotheria.anosite.content.servlet.InternalBoxBeanListResponse;
import net.anotheria.anosite.content.servlet.InternalBoxBeanListWithRedirectResponse;
import net.anotheria.anosite.content.servlet.InternalBoxBeanResponse;
import net.anotheria.anosite.content.servlet.InternalBoxBeanWithRedirectResponse;
import net.anotheria.anosite.content.servlet.InternalPageBeanResponse;
import net.anotheria.anosite.content.servlet.InternalPageBeanWithRedirectResponse;
import net.anotheria.anosite.content.servlet.InternalRedirectResponse;
import net.anotheria.anosite.content.servlet.InternalResponse;
import net.anotheria.anosite.content.servlet.InternalResponseContinue;
import net.anotheria.anosite.content.variables.VariablesUtility;
import net.anotheria.anosite.gen.asbrand.service.IASBrandService;
import net.anotheria.anosite.gen.asfeature.data.Feature;
import net.anotheria.anosite.gen.asfeature.service.ASFeatureServiceException;
import net.anotheria.anosite.gen.asfeature.service.IASFeatureService;
import net.anotheria.anosite.gen.asfederateddata.data.BoxType;
import net.anotheria.anosite.gen.asfederateddata.service.IASFederatedDataService;
import net.anotheria.anosite.gen.aslayoutdata.service.IASLayoutDataService;
import net.anotheria.anosite.gen.asresourcedata.data.FileLink;
import net.anotheria.anosite.gen.asresourcedata.data.Image;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle;
import net.anotheria.anosite.gen.asresourcedata.data.TextResource;
import net.anotheria.anosite.gen.asresourcedata.service.ASResourceDataServiceException;
import net.anotheria.anosite.gen.asresourcedata.service.IASResourceDataService;
import net.anotheria.anosite.gen.assitedata.data.MediaLink;
import net.anotheria.anosite.gen.assitedata.data.NaviItem;
import net.anotheria.anosite.gen.assitedata.data.PageAlias;
import net.anotheria.anosite.gen.assitedata.data.PageTemplate;
import net.anotheria.anosite.gen.assitedata.data.Script;
import net.anotheria.anosite.gen.assitedata.data.Site;
import net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException;
import net.anotheria.anosite.gen.assitedata.service.IASSiteDataService;
import net.anotheria.anosite.gen.aswebdata.data.Attribute;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.service.ASWebDataServiceException;
import net.anotheria.anosite.gen.aswebdata.service.IASWebDataService;
import net.anotheria.anosite.gen.aswizarddata.data.WizardDef;
import net.anotheria.anosite.gen.aswizarddata.service.ASWizardDataServiceException;
import net.anotheria.anosite.gen.aswizarddata.service.IASWizardDataService;
import net.anotheria.anosite.gen.shared.data.LinkTypesUtils;
import net.anotheria.anosite.gen.shared.data.MediaDescUtils;
import net.anotheria.anosite.guard.ConditionalGuard;
import net.anotheria.anosite.guard.GuardFactory;
import net.anotheria.anosite.handler.AbstractRedirectResponse;
import net.anotheria.anosite.handler.BoxHandler;
import net.anotheria.anosite.handler.BoxHandlerFactory;
import net.anotheria.anosite.handler.BoxHandlerResponse;
import net.anotheria.anosite.handler.ResponseAbort;
import net.anotheria.anosite.handler.ResponseContinue;
import net.anotheria.anosite.handler.ResponseRedirectAfterProcessing;
import net.anotheria.anosite.handler.ResponseRedirectImmediately;
import net.anotheria.anosite.handler.ResponseStop;
import net.anotheria.anosite.handler.exception.BoxHandleException;
import net.anotheria.anosite.localization.LocalizationEnvironment;
import net.anotheria.anosite.localization.LocalizationMap;
import net.anotheria.anosite.shared.AnositeConfig;
import net.anotheria.anosite.shared.InternalResponseCode;
import net.anotheria.anosite.shared.presentation.servlet.BaseAnoSiteServlet;
import net.anotheria.anosite.wizard.api.WizardAPI;
import net.anotheria.anosite.wizard.api.exception.WizardAPIException;
import net.anotheria.anosite.wizard.handler.WizardHandler;
import net.anotheria.anosite.wizard.handler.WizardHandlerFactory;
import net.anotheria.anosite.wizard.handler.exceptions.WizardHandlerException;
import net.anotheria.anosite.wizard.handler.exceptions.WizardHandlerSubmitException;
import net.anotheria.anosite.wizard.handler.response.WizardHandlerResponse;
import net.anotheria.anosite.wizard.handler.response.WizardResponseAbort;
import net.anotheria.anosite.wizard.handler.response.WizardResponseCancel;
import net.anotheria.anosite.wizard.handler.response.WizardResponseChangeStep;
import net.anotheria.anosite.wizard.handler.response.WizardResponseContinue;
import net.anotheria.anosite.wizard.handler.response.WizardResponseFinish;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.moskito.core.blueprint.BlueprintCallExecutor;
import net.anotheria.moskito.core.blueprint.BlueprintProducer;
import net.anotheria.moskito.core.blueprint.BlueprintProducersFactory;
import net.anotheria.util.IdCodeGenerator;
import net.anotheria.util.StringUtils;
import net.anotheria.util.concurrency.IdBasedLock;
import net.anotheria.util.concurrency.IdBasedLockManager;
import net.anotheria.util.concurrency.SafeIdBasedLockManager;
import net.anotheria.util.maven.MavenVersion;
import net.anotheria.webutils.util.VersionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class ContentPageServlet
extends BaseAnoSiteServlet {
    private static Logger LOGGER = LoggerFactory.getLogger(ContentPageServlet.class);
    private static final long serialVersionUID = -2697998321193246382L;
    public static final String OVERRIDE_PAGE_TITLE = "CP.OverridePageTitle";
    public static final String BEAN_ANOSITE_VERBOSITY = "anosite.verbose";
    public static final Charset MY_FS_CHARSET = Charset.forName("UTF-8");
    private static final ResourceDeliveryConfig rdConfig = ResourceDeliveryConfig.getInstance();
    private static final String FILE_PATH_PART = "/file/";
    private static final String HTML_SUFFIX = ".html";
    private static final String W_HTML_SUFFIX = ".whtml";
    private transient IASWebDataService webDataService;
    private transient IASSiteDataService siteDataService;
    private transient IASFederatedDataService federatedDataService;
    private transient IASLayoutDataService layoutDataService;
    private transient IASResourceDataService resourceDataService;
    private transient IASFeatureService featureService;
    private transient IASWizardDataService wizardDataService;
    private transient IASBrandService brandService;
    private transient WizardAPI wizardAPI;
    private transient BlueprintCallExecutor pageExecutor;
    private transient BlueprintCallExecutor boxExecutor;
    private transient BlueprintCallExecutor wizardExecutor;
    private AnositeConfig config = AnositeConfig.getInstance();
    private static SimpleDateFormat generatedFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
    private transient IdBasedLockManager lockManager;
    private AnoSiteAccessAPI accessAPI;
    private transient SystemConfigurationAPI systemConfigurationAPI;
    private String page404 = "404.html";
    private String page500 = "500.html";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        LOGGER.info("Init ContentPageServlet");
        try {
            this.webDataService = (IASWebDataService)MetaFactory.get(IASWebDataService.class);
            this.siteDataService = (IASSiteDataService)MetaFactory.get(IASSiteDataService.class);
            this.federatedDataService = (IASFederatedDataService)MetaFactory.get(IASFederatedDataService.class);
            this.layoutDataService = (IASLayoutDataService)MetaFactory.get(IASLayoutDataService.class);
            this.resourceDataService = (IASResourceDataService)MetaFactory.get(IASResourceDataService.class);
            this.wizardDataService = (IASWizardDataService)MetaFactory.get(IASWizardDataService.class);
            this.featureService = (IASFeatureService)MetaFactory.get(IASFeatureService.class);
            this.brandService = (IASBrandService)MetaFactory.get(IASBrandService.class);
            this.wizardAPI = (WizardAPI)APIFinder.findAPI(WizardAPI.class);
            this.accessAPI = (AnoSiteAccessAPI)APIFinder.findAPI(AnoSiteAccessAPI.class);
            this.systemConfigurationAPI = (SystemConfigurationAPI)APIFinder.findAPI(SystemConfigurationAPI.class);
        }
        catch (MetaFactoryException e) {
            LOGGER.error(MarkerFactory.getMarker((String)"FATAL"), "Init ASG services failure", (Throwable)e);
            throw new ServletException("Init ASG services failure", (Throwable)e);
        }
        this.pageExecutor = new PageBeanCreator();
        this.boxExecutor = new BoxBeanCreator();
        this.wizardExecutor = new WizardExecutor();
        config.getServletContext().setAttribute("anosite.aa..random", (Object)IdCodeGenerator.generateCode((int)10));
        this.page404 = config.getInitParameter("page404");
        if (StringUtils.isEmpty((String)this.page404)) {
            this.page404 = "404.html";
        }
        this.page500 = config.getInitParameter("page500");
        if (StringUtils.isEmpty((String)this.page500)) {
            this.page500 = "500.html";
        }
        this.lockManager = new SafeIdBasedLockManager();
    }

    protected void moskitoDoGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.process(req, res, false);
        }
        catch (ASGRuntimeException e) {
            LOGGER.error("moskitoDoGet", (Throwable)e);
            throw new ServletException("ASG Runtime Exception: " + e.getMessage());
        }
        catch (BoxHandleException e) {
            LOGGER.error("moskitoDoGet", (Throwable)e);
            throw new ServletException("Box Handle Exception: " + e.getMessage());
        }
        catch (WizardHandlerException e) {
            LOGGER.error("moskitoDoPost", (Throwable)e);
            throw new ServletException("Wizard Handle Exception: " + e.getMessage());
        }
    }

    protected void moskitoDoPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.process(req, res, true);
        }
        catch (ASGRuntimeException e) {
            LOGGER.error("moskitoDoPost", (Throwable)e);
            throw new ServletException("ASG Runtime Exception: " + e.getMessage());
        }
        catch (BoxHandleException e) {
            LOGGER.error("moskitoDoPost", (Throwable)e);
            throw new ServletException("Box Handle Exception: " + e.getMessage());
        }
        catch (WizardHandlerException e) {
            LOGGER.error("moskitoDoPost", (Throwable)e);
            throw new ServletException("Wizard Handle Exception: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HttpServletRequest req, HttpServletResponse res, boolean submit) throws ServletException, IOException, ASGRuntimeException, BoxHandleException, WizardHandlerException {
        IdBasedLock lock = null;
        try {
            boolean isWizardRequest = this.isRequestToResource(req, W_HTML_SUFFIX);
            if (isWizardRequest) {
                String sId = APICallContext.getCallContext().getCurrentSession().getId();
                String lockId = this.extractPageName(req) + "_" + sId;
                lock = this.lockManager.obtainLock((Object)lockId);
                lock.lock();
            }
            this.processRequest(req, res, submit);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    protected void processRequest(HttpServletRequest req, HttpServletResponse res, boolean submit) throws ServletException, IOException, ASGRuntimeException, BoxHandleException, WizardHandlerException {
        InternalResponse pageResponse;
        boolean secureRequired;
        boolean redirectToLocalizedPage;
        boolean handleWizard;
        boolean errorPage;
        this.prepareTextResources(req);
        req.setAttribute(BEAN_ANOSITE_VERBOSITY, (Object)(this.config.verbose() ? Boolean.TRUE : Boolean.FALSE));
        Object requestURI = req.getRequestURI();
        String queryString = req.getQueryString();
        requestURI = queryString == null || queryString.length() == 0 ? (String)requestURI + "?dummy=dummy" : (String)requestURI + "?" + queryString;
        req.setAttribute("anosite.ra..currentUri", requestURI);
        this.checkSwitchMode(req);
        String pageName = this.extractPageName(req);
        boolean bl = errorPage = pageName != null && (pageName.equals("404") || pageName.equals("500"));
        if (errorPage) {
            this.setErrorCode(pageName, res);
        }
        boolean isPageRequest = this.isRequestToResource(req, HTML_SUFFIX);
        boolean isWizardRequest = this.isRequestToResource(req, W_HTML_SUFFIX);
        Pagex page = isPageRequest || !isWizardRequest ? this.resolvePageByName(pageName) : null;
        WizardDef wizard = page == null && isWizardRequest ? this.getWizardByName(pageName) : null;
        boolean bl2 = handleWizard = wizard != null;
        if (page == null && handleWizard) {
            try {
                String wizardPageId = this.wizardAPI.getCurrentStepPageId(wizard.getId());
                try {
                    if (!StringUtils.isEmpty((String)wizardPageId)) {
                        page = this.webDataService.getPagex(wizardPageId);
                    }
                }
                catch (ASWebDataServiceException e) {
                    LOGGER.trace("ignore", (Throwable)e);
                }
            }
            catch (WizardAPIException e) {
                LOGGER.trace("ignore", (Throwable)((Object)e));
            }
        }
        if (page == null) {
            boolean foundOnFs;
            boolean bl3 = foundOnFs = !submit && this.fallBackToFileSystem(req, res);
            if (foundOnFs) {
                return;
            }
            if (errorPage) {
                throw new ServletException("Page: " + pageName + " not found.");
            }
            APICallContext.getCallContext().getCurrentSession().setAttribute("404.sourcePageName", (Object)pageName);
            res.sendRedirect(req.getContextPath() + "/" + this.page404);
            return;
        }
        if (wizard == null && (wizard = this.getCurrentPageWizard(page)) != null) {
            res.sendRedirect(req.getContextPath() + "/" + wizard.getName() + W_HTML_SUFFIX);
            return;
        }
        if (page != null) {
            APICallContext.getCallContext().getCurrentSession().setAttribute("anosite.sa..pageName", (Object)page.getName());
        }
        boolean bl4 = redirectToLocalizedPage = page != null && !StringUtils.isEmpty((String)page.getLocalizedName()) && !page.getLocalizedName().equals(pageName);
        if (redirectToLocalizedPage) {
            String urlQuery = req.getQueryString();
            urlQuery = urlQuery != null && urlQuery.length() > 0 ? "?" + urlQuery : "";
            String pageUrl = page.getLocalizedName() + HTML_SUFFIX + urlQuery;
            res.sendRedirect(pageUrl);
            return;
        }
        boolean secure = req.isSecure();
        boolean bl5 = secureRequired = page.getHttpsonly() && this.config.enforceHttps() || this.config.httpsOnly();
        if (!secure && secureRequired) {
            Object redirectTarget = "https://";
            redirectTarget = (String)redirectTarget + req.getServerName();
            redirectTarget = (String)redirectTarget + (String)requestURI;
            redirectTarget = URLEncoder.encode((String)redirectTarget, "UTF-8");
            LOGGER.debug("making secure switch to " + (String)redirectTarget);
            res.sendRedirect((String)redirectTarget);
            return;
        }
        if (secure && !secureRequired && this.config.enforceHttp()) {
            Object redirectTarget = "http://";
            redirectTarget = (String)redirectTarget + req.getServerName();
            redirectTarget = (String)redirectTarget + (String)requestURI;
            redirectTarget = URLEncoder.encode((String)redirectTarget, "UTF-8");
            LOGGER.debug("making unsecure switch to " + (String)redirectTarget);
            res.sendRedirect((String)redirectTarget);
            return;
        }
        Map actionScope = ((APISessionImpl)APICallContext.getCallContext().getCurrentSession()).getActionScope();
        for (String key : actionScope.keySet()) {
            req.setAttribute(key, actionScope.get(key));
        }
        ((APISessionImpl)APICallContext.getCallContext().getCurrentSession()).resetActionScope();
        PageTemplate template = this.siteDataService.getPageTemplate(page.getTemplate());
        this.prepareTemplateLocalization(template.getLocalizations());
        HashMap<String, BoxHandler> handlerCache = new HashMap<String, BoxHandler>();
        if (!submit && "true".equals(req.getParameter("submitFlag"))) {
            submit = true;
        }
        try {
            if (submit) {
                if (!this.accessAPI.isAllowedForPage(page.getId())) {
                    res.sendRedirect(req.getContextPath() + "/403.html");
                    return;
                }
                InternalResponse response = this.processSubmit(req, res, page, template, handlerCache);
                if (response.getCode() == InternalResponseCode.CONTINUE_AND_REDIRECT) {
                    res.sendRedirect(((InternalRedirectResponse)InternalRedirectResponse.class.cast(response)).getUrl());
                    return;
                }
                if (!response.canContinue()) {
                    return;
                }
                if (handleWizard) {
                    if (!this.accessAPI.isAllowedForWizard(wizard.getId())) {
                        res.sendRedirect(req.getContextPath() + "/403.html");
                        return;
                    }
                    response = this.processSubmitWizard(req, res, wizard);
                    if (response.getCode() == InternalResponseCode.CONTINUE_AND_REDIRECT) {
                        res.sendRedirect(((InternalRedirectResponse)InternalRedirectResponse.class.cast(response)).getUrl());
                        return;
                    }
                }
                if (!response.canContinue()) {
                    return;
                }
            }
        }
        catch (AnoSiteAccessAPIException e) {
            LOGGER.error(e.getMessage(), (Throwable)((Object)e));
            throw new ServletException((Throwable)((Object)e));
        }
        if (handleWizard) {
            try {
                if (!this.accessAPI.isAllowedForWizard(wizard.getId())) {
                    res.sendRedirect(req.getContextPath() + "/403.html");
                    return;
                }
                BlueprintProducer wizardProducer = BlueprintProducersFactory.getBlueprintProducer((String)("Wizard-" + wizard.getId() + "-" + wizard.getName()), (String)"wizard", (String)"ano-site");
                InternalResponse wizardResponse = (InternalResponse)InternalResponse.class.cast(wizardProducer.execute(this.wizardExecutor, new Object[]{req, res, wizard}));
                if (wizardResponse.getCode() == InternalResponseCode.ABORT) {
                    res.sendRedirect(req.getContextPath() + "/" + this.page500);
                }
                if (!wizardResponse.canContinue()) {
                    LOGGER.debug("Wizard " + wizard + " response can't continue");
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not handle WizardDef with ID: " + wizard.getId(), (Throwable)e);
                throw new ASGRuntimeException("Could not create WizardBean for WizardDef with ID:" + wizard.getId() + ": " + e.getMessage() + "! See logs for more details.");
            }
        }
        req.setAttribute("stylesheet", (Object)new StylesheetBean(this.layoutDataService.getPageLayout(template.getLayout()).getStyle()));
        SiteBean siteBean = this.createSiteBean(template, req);
        req.setAttribute("site", (Object)siteBean);
        try {
            if (!this.accessAPI.isAllowedForPage(page.getId())) {
                res.sendRedirect(req.getContextPath() + "/403.html");
                return;
            }
            BlueprintProducer pageProducer = BlueprintProducersFactory.getBlueprintProducer((String)("Page-" + page.getId() + "-" + page.getName()), (String)"page", (String)"ano-site");
            pageResponse = (InternalResponse)pageProducer.execute(this.pageExecutor, new Object[]{req, res, page, template});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        if (pageResponse.getCode() == InternalResponseCode.ABORT) {
            res.sendRedirect(req.getContextPath() + "/" + this.page500);
        }
        if (!pageResponse.canContinue()) {
            LOGGER.warn("Page " + page.getName() + " [" + page.getId() + "] pageResponse " + pageResponse + " response can't continue");
            return;
        }
        String titleOverride = (String)req.getAttribute(OVERRIDE_PAGE_TITLE);
        PageBean pageBean = ((InternalPageBeanResponse)pageResponse).getPageBean();
        pageBean.setGenerated(generatedFormat.format(page.getLastUpdateTimestamp()));
        if (pageBean.getTitle() == null || pageBean.getTitle().length() == 0) {
            pageBean.setTitle(siteBean.getTitle());
        }
        if (titleOverride != null && titleOverride.length() > 0) {
            pageBean.setTitle(titleOverride);
        }
        if (pageBean.getKeywords() == null || pageBean.getKeywords().length() == 0) {
            pageBean.setKeywords(siteBean.getKeywords());
        }
        if (pageBean.getDescription() == null || pageBean.getDescription().length() == 0) {
            pageBean.setDescription(siteBean.getDescription());
        }
        req.setAttribute("page", (Object)pageBean);
        Site site = this.siteDataService.getSite(template.getSite());
        List<NaviItemBean> topNavi = this.createNaviItemList(site.getTopNavi(), req);
        req.setAttribute("topNavi", topNavi);
        req.setAttribute("topNaviSize", (Object)topNavi.size());
        List<NaviItemBean> mainNavi = this.createNaviItemList(site.getMainNavi(), req);
        req.setAttribute("mainNavi", mainNavi);
        req.setAttribute("mainNaviSize", (Object)mainNavi.size());
        List<BreadCrumbItemBean> breadcrumb = this.prepareBreadcrumb(page, site);
        req.setAttribute("breadcrumbs", breadcrumb);
        if (pageResponse.getCode() == InternalResponseCode.CONTINUE_AND_REDIRECT) {
            String redirectUrl = ((InternalPageBeanWithRedirectResponse)pageResponse).getRedirectUrl();
            res.sendRedirect(redirectUrl);
            return;
        }
        String pageLayout = template.getLayout();
        Object layoutPage = this.layoutDataService.getPageLayout(pageLayout).getLayoutpage();
        if (!((String)layoutPage).startsWith("/")) {
            layoutPage = "/net/anotheria/anosite/layout/templates/" + (String)layoutPage;
        }
        if (!((String)layoutPage).endsWith(".jsp")) {
            layoutPage = (String)layoutPage + ".jsp";
        }
        if (!"true".equals(req.getParameter("xmlrequest")) && !res.isCommitted()) {
            RequestDispatcher dispatcher = req.getRequestDispatcher((String)layoutPage);
            dispatcher.forward((ServletRequest)req, (ServletResponse)res);
        }
    }

    private void checkSwitchMode(HttpServletRequest req) {
        String switchModeParameter = req.getParameter("pSwitchMode");
        if (StringUtils.isEmpty((String)switchModeParameter)) {
            return;
        }
        if (switchModeParameter.equals("editMode")) {
            req.getSession().setAttribute("anosite.sa..editModeFlag", (Object)Boolean.TRUE);
        }
        if (switchModeParameter.equals("viewMode")) {
            req.getSession().removeAttribute("anosite.sa..editModeFlag");
        }
    }

    private boolean isRequestToResource(HttpServletRequest req, String resourcePrefix) {
        if (StringUtils.isEmpty((String)resourcePrefix)) {
            return false;
        }
        boolean defaultValue = true;
        String requestUrl = req.getRequestURI();
        if (StringUtils.isEmpty((String)requestUrl)) {
            return true;
        }
        int indexOfDot = requestUrl.indexOf(46);
        if (indexOfDot > 0 && indexOfDot != requestUrl.length() - 1) {
            return resourcePrefix.equals(requestUrl.substring(indexOfDot, requestUrl.length()));
        }
        return true;
    }

    private WizardDef getCurrentPageWizard(Pagex page) {
        try {
            List wizards = this.wizardDataService.getWizardDefs();
            for (WizardDef wiz : wizards) {
                for (String pageId : wiz.getWizardSteps()) {
                    if (!page.getId().equals(pageId)) continue;
                    return wiz;
                }
            }
        }
        catch (ASWizardDataServiceException e) {
            LOGGER.trace("ignored", (Throwable)e);
        }
        return null;
    }

    private InternalResponse processSubmitWizard(HttpServletRequest req, HttpServletResponse res, WizardDef wizard) throws WizardHandlerSubmitException {
        WizardHandler handler = WizardHandlerFactory.createHandler(wizard.getHandler());
        WizardHandlerResponse response = handler.submit(req, res, wizard);
        switch (response.getResponseCode()) {
            case CONTINUE: {
                return new InternalResponseContinue();
            }
            case CONTINUE_AND_REDIRECT: {
                if (response instanceof WizardResponseFinish) {
                    return new InternalRedirectResponse(((WizardResponseFinish)WizardResponseFinish.class.cast(response)).getRedirectUrl());
                }
                if (response instanceof WizardResponseChangeStep) {
                    return new InternalRedirectResponse(req.getContextPath() + req.getRequestURI());
                }
                LOGGER.warn("wizard  " + wizard + " trying to rewrite redirect, denied");
                return new InternalResponseContinue();
            }
            case CANCEL_AND_REDIRECT: {
                if (response instanceof WizardResponseCancel) {
                    try {
                        res.sendRedirect(((WizardResponseCancel)WizardResponseCancel.class.cast(response)).getRedirectUrl());
                    }
                    catch (IOException e) {
                        LOGGER.error("Redirect failed, target: ", (Throwable)e);
                    }
                }
                return new InternalResponse(InternalResponseCode.STOP);
            }
            case STOP: {
                return new InternalResponse(InternalResponseCode.STOP);
            }
            case ABORT: {
                if (response instanceof WizardResponseAbort) {
                    WizardResponseAbort abort = (WizardResponseAbort)WizardResponseAbort.class.cast(response);
                    Exception cause = abort != null ? abort.getCause() : null;
                    String message = abort != null ? abort.getCauseMessage() : null;
                    throw new WizardHandlerSubmitException("Execution aborted " + message != null ? message : "", cause != null ? cause : new RuntimeException("No Exception given"));
                }
                throw new RuntimeException("Execution aborted: " + response);
            }
        }
        throw new AssertionError((Object)("Unexpected case in response: " + response.getResponseCode()));
    }

    private WizardDef getWizardByName(String wizardName) {
        try {
            List wizards = this.wizardDataService.getWizardDefsByProperty("name", (Object)wizardName);
            if (wizards == null || wizards.isEmpty()) {
                LOGGER.debug("Withards are not  configured!");
                return null;
            }
            return (WizardDef)wizards.get(0);
        }
        catch (ASWizardDataServiceException e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void setErrorCode(String pageName, HttpServletResponse res) {
        int errorCode;
        int n = errorCode = pageName == null ? 404 : 0;
        errorCode = pageName != null && pageName.equals("404") ? 404 : (pageName != null && pageName.equals("500") ? 500 : errorCode);
        res.setStatus(errorCode);
    }

    private List<String> getBoxIdsForRenderingStep(Pagex page, PageTemplate template, int step) {
        switch (step) {
            case 0: {
                return template.getMeta();
            }
            case 1: {
                return template.getHeader();
            }
            case 2: {
                return page.getHeader();
            }
            case 3: {
                return template.getC1first();
            }
            case 4: {
                return template.getC2first();
            }
            case 5: {
                return template.getC3first();
            }
            case 6: {
                return page.getC1();
            }
            case 7: {
                return page.getC2();
            }
            case 8: {
                return page.getC3();
            }
            case 9: {
                return template.getC1last();
            }
            case 10: {
                return template.getC2last();
            }
            case 11: {
                return template.getC3last();
            }
            case 12: {
                return template.getFooter();
            }
            case 13: {
                return page.getFooter();
            }
        }
        throw new RuntimeException("Error, step " + step + " is unknown!");
    }

    private InternalResponse processSubmit(HttpServletRequest req, HttpServletResponse res, Pagex page, PageTemplate template, HashMap<String, BoxHandler> handlerCache) throws ASGRuntimeException, BoxHandleException {
        int step;
        InternalResponse progress = new InternalResponseContinue();
        for (step = 0; progress.canContinue() && step < 14; ++step) {
            progress = this.processSubmit(req, res, this.getBoxIdsForRenderingStep(page, template, step), handlerCache, progress);
        }
        LOGGER.debug("Returning at step: " + step + " : " + progress);
        return progress;
    }

    private InternalResponse processSubmit(HttpServletRequest req, HttpServletResponse res, List<String> boxIds, HashMap<String, BoxHandler> handlerCache, InternalResponse previous) throws ASGRuntimeException, BoxHandleException {
        if (boxIds == null || boxIds.size() == 0) {
            return previous;
        }
        boolean doRedirect = false;
        String redirectTarget = null;
        for (String id : boxIds) {
            List subboxesIds;
            InternalResponse subResponse;
            Box box = this.webDataService.getBox(id);
            if (this.disabledByGuards(req, box)) continue;
            String handlerId = box.getHandler();
            if (handlerId != null && handlerId.length() > 0) {
                BoxHandler handler = BoxHandlerFactory.createHandler(handlerId);
                BoxHandlerResponse response = handler.submit(req, res, box);
                switch (response.getResponseCode()) {
                    case CONTINUE: {
                        break;
                    }
                    case CONTINUE_AND_REDIRECT: {
                        if (!(previous instanceof InternalRedirectResponse)) {
                            doRedirect = true;
                            redirectTarget = ((AbstractRedirectResponse)response).getRedirectTarget();
                            break;
                        }
                        LOGGER.warn("box " + box + " trying to rewrite redirect, denied");
                        break;
                    }
                    case CANCEL_AND_REDIRECT: {
                        redirectTarget = ((AbstractRedirectResponse)response).getRedirectTarget();
                        try {
                            res.sendRedirect(redirectTarget);
                        }
                        catch (IOException e) {
                            LOGGER.error("Redirect failed, target: " + redirectTarget, (Throwable)e);
                        }
                        return new InternalResponse(InternalResponseCode.STOP);
                    }
                    case STOP: {
                        return new InternalResponse(InternalResponseCode.STOP);
                    }
                    case ABORT: {
                        Exception e = ((ResponseAbort)response).getCause();
                        if (e == null) {
                            throw new RuntimeException("No exception given");
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException("Execution aborted: " + e.getMessage() + " (" + e.getClass() + ")", e);
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected case in response: " + response.getResponseCode()));
                    }
                }
                handlerCache.put(box.getId(), handler);
            }
            if ((subResponse = this.processSubmit(req, res, subboxesIds = box.getSubboxes(), handlerCache, previous)).getCode() == InternalResponseCode.CONTINUE_AND_REDIRECT && previous.getCode() == InternalResponseCode.CONTINUE) {
                previous = subResponse;
            }
            if (subResponse.canContinue()) continue;
            return new InternalResponse(InternalResponseCode.STOP);
        }
        if (doRedirect) {
            return new InternalRedirectResponse(redirectTarget);
        }
        return previous;
    }

    private List<BreadCrumbItemBean> prepareBreadcrumb(Pagex page, Site site) {
        ArrayList<BreadCrumbItemBean> ret = new ArrayList<BreadCrumbItemBean>();
        APISession session = APICallContext.getCallContext().getCurrentSession();
        BrowsingHistory naviHistory = (BrowsingHistory)session.getAttribute("as.history.navi");
        if (naviHistory == null) {
            naviHistory = new BrowsingHistory();
            session.setAttribute("as.history.navi", (Object)naviHistory);
        }
        try {
            String pageAliasId;
            PageAlias alias;
            List linkingItems = this.siteDataService.getNaviItemsByProperty("internalLink", (Object)page.getId());
            if (linkingItems.size() == 0) {
                return ret;
            }
            NaviItem linkingItem = (NaviItem)linkingItems.get(0);
            naviHistory.addHistoryItem(linkingItem.getId());
            if (site.getStartpage().length() > 0) {
                linkingItems = this.siteDataService.getNaviItemsByProperty("internalLink", (Object)site.getStartpage());
                NaviItem linkToStartPage = (NaviItem)linkingItems.get(0);
                BreadCrumbItemBean startpageBean = new BreadCrumbItemBean();
                startpageBean.setTitle(linkToStartPage.getName());
                Object sLink = this.webDataService.getPagex(linkToStartPage.getInternalLink()).getName() + HTML_SUFFIX;
                if (linkToStartPage.getPageAlias().length() > 0 && ((String)(sLink = (alias = this.siteDataService.getPageAlias(pageAliasId = linkToStartPage.getPageAlias())).getName())).startsWith("/")) {
                    sLink = ((String)sLink).substring(1, ((String)sLink).length());
                }
                startpageBean.setLink((String)sLink);
                ret.add(startpageBean);
                if (linkToStartPage.equals(linkingItem)) {
                    startpageBean.setClickable(false);
                    return ret;
                }
                startpageBean.setClickable(true);
            }
            ArrayList<BreadCrumbItemBean> items = new ArrayList<BreadCrumbItemBean>();
            block4: while (linkingItem != null) {
                BreadCrumbItemBean b = new BreadCrumbItemBean();
                b.setClickable(items.size() > 0);
                b.setTitle(linkingItem.getName());
                try {
                    LOGGER.info(linkingItem.getName() + ":" + linkingItem.getInternalLink() + "," + linkingItem.getExternalLink());
                    Object link = this.webDataService.getPagex(linkingItem.getInternalLink()).getName() + HTML_SUFFIX;
                    if (linkingItem.getPageAlias().length() > 0 && ((String)(link = (alias = this.siteDataService.getPageAlias(pageAliasId = linkingItem.getPageAlias())).getName())).startsWith("/")) {
                        link = ((String)link).substring(1, ((String)link).length());
                    }
                    if (linkingItem.getExternalLink().length() > 0) {
                        link = linkingItem.getExternalLink();
                    }
                    b.setLink((String)link);
                }
                catch (NoSuchDocumentException e) {
                    b.setLink("");
                    b.setClickable(false);
                }
                items.add(b);
                String searchId = linkingItem.getId();
                linkingItem = null;
                List tosearch = this.siteDataService.getNaviItems();
                String previousNaviItemId = naviHistory.getPreviousItem();
                if (previousNaviItemId != null) {
                    for (NaviItem i : tosearch) {
                        if (i.getSubNavi().contains(searchId)) {
                            // empty if block
                        }
                        if (!i.getSubNavi().contains(searchId) || !i.getId().equals(previousNaviItemId)) continue;
                        linkingItem = i;
                        break;
                    }
                }
                if (linkingItem != null) continue;
                for (NaviItem i : tosearch) {
                    if (!i.getSubNavi().contains(searchId)) continue;
                    linkingItem = i;
                    continue block4;
                }
            }
            Collections.reverse(items);
            ret.addAll(items);
        }
        catch (Exception e) {
            BreadCrumbItemBean b = new BreadCrumbItemBean();
            b.setTitle("Error: " + e.getMessage());
            b.setClickable(false);
            ret.add(b);
        }
        return ret;
    }

    private InternalResponse createBoxBean(HttpServletRequest req, HttpServletResponse res, Box box) throws ASGRuntimeException, BoxHandleException {
        BoxBean ret = new BoxBean();
        APICallContext.getCallContext().setAttribute(BoxBean.CALL_CONTEXT_SCOPE_NAME, (Object)ret);
        ret.setName(box.getName());
        ret.setId(box.getId());
        ret.setCssClass(box.getCssClass());
        ret.setMediaLinks(this.createMediaLinkBeanList(box.getMediaLinks(), req));
        ret.setScripts(this.createScriptBeanList(box.getScripts(), req));
        AttributeMap attributeMap = this.createAttributeMap(req, res, box.getAttributes());
        APICallContext.getCallContext().setAttribute(AttributeMap.BOX_ATTRIBUTES_CALL_CONTEXT_SCOPE_NAME, (Object)attributeMap);
        ret.setAttributes(attributeMap);
        this.prepareBoxLocalization(ret, box.getLocalizations());
        ret.setContent(VariablesUtility.replaceVariables(req, box.getContent()));
        ret.setParameter1(VariablesUtility.replaceVariables(req, box.getParameter1()));
        ret.setParameter2(VariablesUtility.replaceVariables(req, box.getParameter2()));
        ret.setParameter3(VariablesUtility.replaceVariables(req, box.getParameter3()));
        ret.setParameter4(VariablesUtility.replaceVariables(req, box.getParameter4()));
        ret.setParameter5(VariablesUtility.replaceVariables(req, box.getParameter5()));
        ret.setParameter6(VariablesUtility.replaceVariables(req, box.getParameter6()));
        ret.setParameter7(VariablesUtility.replaceVariables(req, box.getParameter7()));
        ret.setParameter8(VariablesUtility.replaceVariables(req, box.getParameter8()));
        ret.setParameter9(VariablesUtility.replaceVariables(req, box.getParameter9()));
        ret.setParameter10(VariablesUtility.replaceVariables(req, box.getParameter10()));
        ret.setType(this.createBoxTypeBean(box.getType()));
        BoxHandlerResponse handlerResponse = null;
        if (box.getHandler() != null && box.getHandler().length() > 0) {
            BoxHandler handler = BoxHandlerFactory.createHandler(box.getHandler());
            handlerResponse = handler.process(req, res, box, ret);
        }
        if (handlerResponse == null) {
            handlerResponse = new ResponseContinue();
        }
        if (handlerResponse.getResponseCode() == InternalResponseCode.CANCEL_AND_REDIRECT) {
            try {
                res.sendRedirect(((ResponseRedirectImmediately)handlerResponse).getRedirectTarget());
            }
            catch (IOException e) {
                LOGGER.warn("Couldn't send redirect to " + ((ResponseRedirectImmediately)handlerResponse).getRedirectTarget() + ", aborting execution.", (Throwable)e);
            }
            handlerResponse = new ResponseStop();
        }
        InternalResponse response = null;
        switch (handlerResponse.getResponseCode()) {
            case CONTINUE: 
            case ERROR_AND_CONTINUE: {
                response = new InternalBoxBeanResponse(InternalResponseCode.CONTINUE, ret);
                break;
            }
            case CONTINUE_AND_REDIRECT: {
                response = new InternalBoxBeanWithRedirectResponse(ret, ((ResponseRedirectAfterProcessing)handlerResponse).getRedirectTarget());
                break;
            }
            case STOP: {
                response = new InternalResponse(handlerResponse);
                break;
            }
            case ABORT: {
                response = new InternalResponse(handlerResponse);
                Exception e = ((ResponseAbort)handlerResponse).getCause();
                LOGGER.error("createBoxBean() for Box[" + box.getId() + "] failure: ", (Throwable)e);
                throw new ASGRuntimeException((Throwable)e);
            }
        }
        if (response == null) {
            LOGGER.error("Response is null!");
            throw new RuntimeException("Unhandled handler response: " + handlerResponse);
        }
        if (!response.canContinue()) {
            return response;
        }
        if (box.getSubboxes() != null && box.getSubboxes().size() > 0) {
            InternalResponse subBoxResponse = this.createBoxBeanList(req, res, box.getSubboxes());
            switch (subBoxResponse.getCode()) {
                case CONTINUE: 
                case ERROR_AND_CONTINUE: {
                    ret.setSubboxes(((InternalBoxBeanListResponse)subBoxResponse).getBeans());
                    break;
                }
                case STOP: {
                    return subBoxResponse;
                }
                case ABORT: {
                    return subBoxResponse;
                }
                case CONTINUE_AND_REDIRECT: {
                    ret.setSubboxes(((InternalBoxBeanListResponse)subBoxResponse).getBeans());
                    if (response.getCode() == InternalResponseCode.CONTINUE_AND_REDIRECT) break;
                    response = new InternalBoxBeanWithRedirectResponse(ret, ((InternalBoxBeanListWithRedirectResponse)subBoxResponse).getRedirectUrl());
                }
            }
        }
        return response;
    }

    private boolean disabledByGuards(HttpServletRequest req, Box box) {
        List gIds = box.getGuards();
        for (String gid : gIds) {
            ConditionalGuard g = null;
            try {
                g = GuardFactory.getConditionalGuard(gid);
                if (g.isConditionFullfilled((DataObject)box, req)) continue;
                return true;
            }
            catch (Exception e) {
                LOGGER.warn("Caught error in guard processing ( guard: " + g + ", gid: " + gid + ", boxid: " + box.getId() + ")", (Throwable)e);
            }
        }
        return false;
    }

    private boolean disabledByFeature(HttpServletRequest req, Box box) {
        String featureId = box.getFeature();
        if (featureId == null || featureId.length() == 0) {
            return false;
        }
        Feature feature = null;
        try {
            feature = this.featureService.getFeature(featureId);
        }
        catch (ASFeatureServiceException e) {
            return false;
        }
        catch (NoSuchDocumentException e) {
            return false;
        }
        if (!feature.getEnabled()) {
            return true;
        }
        if (this.systemConfigurationAPI.getCurrentSystem().startsWith("PROD") && !feature.getActiveInProduction()) {
            return true;
        }
        List gIds = feature.getGuards();
        for (String gid : gIds) {
            ConditionalGuard g = null;
            try {
                g = GuardFactory.getConditionalGuard(gid);
                if (g.isConditionFullfilled((DataObject)box, req)) continue;
                return true;
            }
            catch (Exception e) {
                LOGGER.warn("Caught error in guard processing ( guard: " + g + ", gid: " + gid + ", boxid: " + box.getId() + ")", (Throwable)e);
            }
        }
        return false;
    }

    private boolean disabledByGuards(HttpServletRequest req, MediaLink mediaLink) {
        List gIds = mediaLink.getGuards();
        for (String gid : gIds) {
            ConditionalGuard g = null;
            try {
                g = GuardFactory.getConditionalGuard(gid);
                if (g.isConditionFullfilled((DataObject)mediaLink, req)) continue;
                return true;
            }
            catch (Exception e) {
                LOGGER.warn("Caught error in guard processing ( guard: " + g + ", gid: " + gid + ", mediaLinkId: " + mediaLink.getId() + ")", (Throwable)e);
            }
        }
        return false;
    }

    private boolean disabledByGuards(HttpServletRequest req, Script script) {
        List gIds = script.getGuards();
        for (String gid : gIds) {
            ConditionalGuard g = null;
            try {
                g = GuardFactory.getConditionalGuard(gid);
                if (g.isConditionFullfilled((DataObject)script, req)) continue;
                return true;
            }
            catch (Exception e) {
                LOGGER.warn("Caught error in guard processing ( guard: " + g + ", gid: " + gid + ", scriptId: " + script.getId() + ")", (Throwable)e);
            }
        }
        return false;
    }

    private InternalResponse createBoxBeanList(HttpServletRequest req, HttpServletResponse res, List<String> boxIds) throws ASGRuntimeException {
        ArrayList<BoxBean> ret = new ArrayList<BoxBean>();
        String redirectUrl = null;
        for (String boxId : boxIds) {
            Box box = this.webDataService.getBox(boxId);
            try {
                if (!this.accessAPI.isAllowedForBox(box.getId())) {
                    continue;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error in AccessAPI. Box: " + box + ", BoxId: " + boxId + ")", (Throwable)e);
            }
            if (this.disabledByGuards(req, box) || this.disabledByFeature(req, box)) continue;
            InternalResponse response = null;
            BlueprintProducer boxProducer = BlueprintProducersFactory.getBlueprintProducer((String)("Box-" + box.getId() + "-" + box.getName()), (String)"box", (String)"ano-site");
            try {
                response = (InternalResponse)boxProducer.execute(this.boxExecutor, new Object[]{req, res, box});
            }
            catch (Exception e) {
                LOGGER.error("Could not create BoxBean for Box with ID: " + box.getId(), (Throwable)e);
                throw new ASGRuntimeException("Could not create BoxBean for Box with ID: " + box.getId() + ": " + e.getMessage() + "! See logs for more details.");
            }
            if (!response.canContinue()) {
                return response;
            }
            ret.add(((InternalBoxBeanResponse)response).getBean());
            if (response.getCode() != InternalResponseCode.CONTINUE_AND_REDIRECT || redirectUrl != null) continue;
            redirectUrl = ((InternalBoxBeanWithRedirectResponse)response).getRedirectUrl();
        }
        return redirectUrl == null ? new InternalBoxBeanListResponse(ret) : new InternalBoxBeanListWithRedirectResponse(ret, redirectUrl);
    }

    private BoxTypeBean createBoxTypeBean(String boxTypeId) throws ASGRuntimeException {
        BoxType type = null;
        if (!StringUtils.isEmpty((String)boxTypeId)) {
            type = this.federatedDataService.getBoxType(boxTypeId);
        } else {
            LOGGER.debug("BoxType is not defined. Using \"Plain\" as default.");
            List types = this.federatedDataService.getBoxTypesByProperty("name", (Object)"Plain");
            if (types.size() != 1) {
                LOGGER.debug("Could not use default BoxType with name \"Plain\": either it doesn't exist or duplicated!");
                throw new ASGRuntimeException("BoxType is not defined! Please set property \"type\" of Box in the CMS.");
            }
            type = (BoxType)types.get(0);
        }
        BoxTypeBean bean = new BoxTypeBean();
        bean.setName(type.getName());
        bean.setRenderer(type.getRendererpage());
        return bean;
    }

    private List<NaviItemBean> createNaviItemList(List<String> idList, HttpServletRequest req) throws ASSiteDataServiceException, ASWebDataServiceException, ASResourceDataServiceException {
        ArrayList<NaviItemBean> ret = new ArrayList<NaviItemBean>(idList.size());
        for (String id : idList) {
            NaviItemBean bean = new NaviItemBean();
            boolean do_break = false;
            NaviItem item = null;
            try {
                item = this.siteDataService.getNaviItem(id);
            }
            catch (NoSuchDocumentException nsde) {
                LOGGER.warn("Couldn't retrieve navi item with id " + id + ", ignored.");
                break;
            }
            try {
                if (!this.accessAPI.isAllowedForNaviItem(item.getId())) {
                    continue;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error in AccessAPI. NaviItem: " + item + ", NaviItemId: " + id + ")", (Throwable)e);
            }
            List gIds = item.getGuards();
            for (String gid : gIds) {
                ConditionalGuard g = null;
                try {
                    g = GuardFactory.getConditionalGuard(gid);
                    if (g.isConditionFullfilled((DataObject)item, req)) continue;
                    do_break = true;
                    break;
                }
                catch (Exception e) {
                    LOGGER.warn("Error in guard, caught (guard: " + g + ", gid: " + gid + ", naviitem: " + item + ", itemId: " + id + ")", (Throwable)e);
                }
            }
            if (do_break) continue;
            bean.setPopup(item.getPopup());
            bean.setName(item.getName());
            bean.setTitle(item.getTitle());
            bean.setIcon(item.getIcon());
            bean.setClassName(item.getClassName());
            if (item.getInternalLink().length() > 0) {
                String pageId = item.getInternalLink();
                Pagex page = this.webDataService.getPagex(pageId);
                String pageLocalizedName = page.getLocalizedName();
                String pageName = StringUtils.isEmpty((String)pageLocalizedName) ? page.getName() : pageLocalizedName;
                bean.setLink(pageName + HTML_SUFFIX);
                if (this.extractPageName(req).equals(pageName)) {
                    bean.setSelected(true);
                }
            } else {
                bean.setLink("#");
            }
            if (item.getPageAlias().length() > 0) {
                String pageAliasId = item.getPageAlias();
                PageAlias alias = this.siteDataService.getPageAlias(pageAliasId);
                String link = alias.getName();
                if (link.startsWith("/")) {
                    link = link.substring(1, link.length());
                }
                bean.setLink(link);
            }
            if (item.getExternalLink().length() > 0) {
                bean.setLink(item.getExternalLink());
            }
            ret.add(bean);
            List subNaviIds = item.getSubNavi();
            if (subNaviIds.size() <= 0) continue;
            List<NaviItemBean> subNavi = this.createNaviItemList(subNaviIds, req);
            if (!bean.isSelected()) {
                for (NaviItemBean subBean : subNavi) {
                    if (!subBean.isSelected()) continue;
                    bean.setSelected(true);
                    break;
                }
            }
            bean.setSubNavi(subNavi);
        }
        return ret;
    }

    private String getNewPageRedirectTargetIfApplies(InternalResponse response, String previousRedirectTarget) {
        if (previousRedirectTarget != null) {
            return previousRedirectTarget;
        }
        if (response.getCode() == InternalResponseCode.CONTINUE_AND_REDIRECT) {
            return ((InternalBoxBeanListWithRedirectResponse)response).getRedirectUrl();
        }
        return null;
    }

    private InternalResponse getNewPageResponse(InternalResponse current, InternalResponse previous) {
        if (previous.getCode() == InternalResponseCode.CONTINUE_AND_REDIRECT) {
            return previous;
        }
        return current;
    }

    private InternalResponse handleWizardProcess(HttpServletRequest req, HttpServletResponse res, WizardDef wizard) throws WizardHandlerException {
        WizardHandler handler = WizardHandlerFactory.createHandler(wizard.getHandler());
        WizardHandlerResponse response = handler.preProcess(req, res, wizard);
        response = response == null ? WizardResponseContinue.INSTANCE : response;
        InternalResponse result = this.handleWizardProcessResponse(req, res, wizard, response);
        if (!result.canContinue()) {
            LOGGER.debug("wizard pre-process :  RESPONSE can't continue. Process won't be executed");
            return result;
        }
        response = handler.process(req, res, wizard);
        response = response == null ? WizardResponseContinue.INSTANCE : response;
        return this.handleWizardProcessResponse(req, res, wizard, response);
    }

    private InternalResponse handleWizardProcessResponse(HttpServletRequest req, HttpServletResponse res, WizardDef wizard, WizardHandlerResponse response) throws WizardHandlerException {
        switch (response.getResponseCode()) {
            case ERROR_AND_CONTINUE: {
                return new InternalResponseContinue();
            }
            case CONTINUE: {
                return new InternalResponseContinue();
            }
            case CONTINUE_AND_REDIRECT: {
                if (response instanceof WizardResponseFinish) {
                    return new InternalRedirectResponse(((WizardResponseFinish)WizardResponseFinish.class.cast(response)).getRedirectUrl());
                }
                if (response instanceof WizardResponseChangeStep) {
                    try {
                        res.sendRedirect(req.getContextPath() + req.getRequestURI());
                    }
                    catch (IOException e) {
                        LOGGER.error("Redirect failed, target: ", (Throwable)e);
                    }
                    return new InternalResponse(InternalResponseCode.STOP);
                }
                LOGGER.warn("wizard  " + wizard + " trying to rewrite redirect, denied");
                return new InternalResponseContinue();
            }
            case CANCEL_AND_REDIRECT: {
                if (response instanceof WizardResponseCancel) {
                    try {
                        res.sendRedirect(((WizardResponseCancel)WizardResponseCancel.class.cast(response)).getRedirectUrl());
                    }
                    catch (IOException e) {
                        LOGGER.error("Redirect failed, target: ", (Throwable)e);
                    }
                }
                return new InternalResponse(InternalResponseCode.STOP);
            }
            case STOP: {
                return new InternalResponse(InternalResponseCode.STOP);
            }
            case ABORT: {
                if (response instanceof WizardResponseAbort) {
                    WizardResponseAbort abort = (WizardResponseAbort)WizardResponseAbort.class.cast(response);
                    Exception cause = abort != null ? abort.getCause() : null;
                    String message = abort != null ? abort.getCauseMessage() : null;
                    LOGGER.error("Could not create wizardBean for wizard{" + wizard.getId() + "}" + message != null ? message : "", (Throwable)cause);
                    throw new WizardHandlerException("Execution aborted " + message != null ? message : "", cause != null ? cause : new RuntimeException("No Exception given"));
                }
                throw new RuntimeException("Execution aborted: " + response);
            }
        }
        throw new AssertionError((Object)("Unexpected case in response: " + response.getResponseCode()));
    }

    private InternalResponse createPageBean(HttpServletRequest req, HttpServletResponse res, Pagex page, PageTemplate template) throws ASGRuntimeException {
        this.preparePageLocalization(page.getLocalizations());
        BrandConfig brandConfig = ContextManager.getCallContext().getBrandConfig();
        if (brandConfig != null) {
            this.prepareBrandLocalization(brandConfig.getLocalizations());
        }
        PageBean ret = new PageBean();
        ret.setTitle(VariablesUtility.replaceVariables(req, page.getTitle()));
        ret.setKeywords(VariablesUtility.replaceVariables(req, page.getKeywords()));
        ret.setDescription(VariablesUtility.replaceVariables(req, page.getDescription()));
        ret.setName(page.getName());
        ret.setLocalizedName(page.getLocalizedName());
        req.setAttribute("anosite.page.pageName", (Object)page.getName());
        req.setAttribute("anosite.page.pageTitle", (Object)page.getTitle());
        req.setAttribute("anosite.page.pageDescription", (Object)page.getDescription());
        ret.addMediaLinks(this.createMediaLinkBeanList(template.getMediaLinks(), req));
        ret.addMediaLinks(this.createMediaLinkBeanList(page.getMediaLinks(), req));
        ret.addScripts(this.createScriptBeanList(template.getScripts(), req));
        ret.addScripts(this.createScriptBeanList(page.getScripts(), req));
        List attributes = page.getAttributes();
        if (brandConfig != null) {
            attributes.addAll(brandConfig.getAttributes());
        }
        AttributeMap attributeMap = this.createAttributeMap(req, res, attributes);
        APICallContext.getCallContext().setAttribute(AttributeMap.PAGE_ATTRIBUTES_CALL_CONTEXT_SCOPE_NAME, (Object)attributeMap);
        ret.setAttributes(attributeMap);
        InternalResponse response = new InternalResponseContinue();
        InternalResponse call = null;
        String redirectTarget = null;
        List<BoxBean> boxes = null;
        call = this.createBoxBeanList(req, res, template.getMeta());
        if (!call.canContinue()) {
            return new InternalResponse(call.getCode());
        }
        redirectTarget = this.getNewPageRedirectTargetIfApplies(call, redirectTarget);
        response = this.getNewPageResponse(call, response);
        boxes = ((InternalBoxBeanListResponse)call).getBeans();
        ret.addMetaBoxes(boxes);
        ret.addMediaLinks(this.searchMediaLinks(boxes));
        ret.addScripts(this.searchScripts(boxes));
        call = this.createBoxBeanList(req, res, template.getHeader());
        if (!call.canContinue()) {
            return new InternalResponse(call.getCode());
        }
        redirectTarget = this.getNewPageRedirectTargetIfApplies(call, redirectTarget);
        response = this.getNewPageResponse(call, response);
        boxes = ((InternalBoxBeanListResponse)call).getBeans();
        ret.addHeaderBoxes(boxes);
        ret.addMediaLinks(this.searchMediaLinks(boxes));
        ret.addScripts(this.searchScripts(boxes));
        call = this.createBoxBeanList(req, res, page.getHeader());
        if (!call.canContinue()) {
            return new InternalResponse(call.getCode());
        }
        redirectTarget = this.getNewPageRedirectTargetIfApplies(call, redirectTarget);
        response = this.getNewPageResponse(call, response);
        boxes = ((InternalBoxBeanListResponse)call).getBeans();
        ret.addHeaderBoxes(boxes);
        ret.addMediaLinks(this.searchMediaLinks(boxes));
        ret.addScripts(this.searchScripts(boxes));
        call = this.createBoxBeanList(req, res, template.getC1first());
        if (!call.canContinue()) {
            return new InternalResponse(call.getCode());
        }
        redirectTarget = this.getNewPageRedirectTargetIfApplies(call, redirectTarget);
        response = this.getNewPageResponse(call, response);
        boxes = ((InternalBoxBeanListResponse)call).getBeans();
        ret.addColumn1(boxes);
        ret.addMediaLinks(this.searchMediaLinks(boxes));
        ret.addScripts(this.searchScripts(boxes));
        call = this.createBoxBeanList(req, res, page.getC1());
        if (!call.canContinue()) {
            return new InternalResponse(call.getCode());
        }
        redirectTarget = this.getNewPageRedirectTargetIfApplies(call, redirectTarget);
        response = this.getNewPageResponse(call, response);
        boxes = ((InternalBoxBeanListResponse)call).getBeans();
        ret.addColumn1(boxes);
        ret.addMediaLinks(this.searchMediaLinks(boxes));
        ret.addScripts(this.searchScripts(boxes));
        call = this.createBoxBeanList(req, res, template.getC1last());
        if (!call.canContinue()) {
            return new InternalResponse(call.getCode());
        }
        redirectTarget = this.getNewPageRedirectTargetIfApplies(call, redirectTarget);
        response = this.getNewPageResponse(call, response);
        boxes = ((InternalBoxBeanListResponse)call).getBeans();
        ret.addColumn1(boxes);
        ret.addMediaLinks(this.searchMediaLinks(boxes));
        ret.addScripts(this.searchScripts(boxes));
        call = this.createBoxBeanList(req, res, template.getC2first());
        if (!call.canContinue()) {
            return new InternalResponse(call.getCode());
        }
        redirectTarget = this.getNewPageRedirectTargetIfApplies(call, redirectTarget);
        response = this.getNewPageResponse(call, response);
        boxes = ((InternalBoxBeanListResponse)call).getBeans();
        ret.addColumn2(boxes);
        ret.addMediaLinks(this.searchMediaLinks(boxes));
        ret.addScripts(this.searchScripts(boxes));
        call = this.createBoxBeanList(req, res, page.getC2());
        if (!call.canContinue()) {
            return new InternalResponse(call.getCode());
        }
        redirectTarget = this.getNewPageRedirectTargetIfApplies(call, redirectTarget);
        response = this.getNewPageResponse(call, response);
        boxes = ((InternalBoxBeanListResponse)call).getBeans();
        ret.addColumn2(boxes);
        ret.addMediaLinks(this.searchMediaLinks(boxes));
        ret.addScripts(this.searchScripts(boxes));
        call = this.createBoxBeanList(req, res, template.getC2last());
        if (!call.canContinue()) {
            return new InternalResponse(call.getCode());
        }
        redirectTarget = this.getNewPageRedirectTargetIfApplies(call, redirectTarget);
        response = this.getNewPageResponse(call, response);
        boxes = ((InternalBoxBeanListResponse)call).getBeans();
        ret.addColumn2(boxes);
        ret.addMediaLinks(this.searchMediaLinks(boxes));
        ret.addScripts(this.searchScripts(boxes));
        call = this.createBoxBeanList(req, res, template.getC3first());
        if (!call.canContinue()) {
            return new InternalResponse(call.getCode());
        }
        redirectTarget = this.getNewPageRedirectTargetIfApplies(call, redirectTarget);
        response = this.getNewPageResponse(call, response);
        boxes = ((InternalBoxBeanListResponse)call).getBeans();
        ret.addColumn3(boxes);
        ret.addMediaLinks(this.searchMediaLinks(boxes));
        ret.addScripts(this.searchScripts(boxes));
        call = this.createBoxBeanList(req, res, page.getC3());
        if (!call.canContinue()) {
            return new InternalResponse(call.getCode());
        }
        redirectTarget = this.getNewPageRedirectTargetIfApplies(call, redirectTarget);
        response = this.getNewPageResponse(call, response);
        boxes = ((InternalBoxBeanListResponse)call).getBeans();
        ret.addColumn3(boxes);
        ret.addMediaLinks(this.searchMediaLinks(boxes));
        ret.addScripts(this.searchScripts(boxes));
        call = this.createBoxBeanList(req, res, template.getC3last());
        if (!call.canContinue()) {
            return new InternalResponse(call.getCode());
        }
        redirectTarget = this.getNewPageRedirectTargetIfApplies(call, redirectTarget);
        response = this.getNewPageResponse(call, response);
        boxes = ((InternalBoxBeanListResponse)call).getBeans();
        ret.addColumn3(boxes);
        ret.addMediaLinks(this.searchMediaLinks(boxes));
        ret.addScripts(this.searchScripts(boxes));
        call = this.createBoxBeanList(req, res, template.getFooter());
        if (!call.canContinue()) {
            return new InternalResponse(call.getCode());
        }
        redirectTarget = this.getNewPageRedirectTargetIfApplies(call, redirectTarget);
        response = this.getNewPageResponse(call, response);
        boxes = ((InternalBoxBeanListResponse)call).getBeans();
        ret.addFooterBoxes(boxes);
        ret.addMediaLinks(this.searchMediaLinks(boxes));
        ret.addScripts(this.searchScripts(boxes));
        call = this.createBoxBeanList(req, res, page.getFooter());
        if (!call.canContinue()) {
            return new InternalResponse(call.getCode());
        }
        redirectTarget = this.getNewPageRedirectTargetIfApplies(call, redirectTarget);
        response = this.getNewPageResponse(call, response);
        boxes = ((InternalBoxBeanListResponse)call).getBeans();
        ret.addFooterBoxes(boxes);
        ret.addMediaLinks(this.searchMediaLinks(boxes));
        ret.addScripts(this.searchScripts(boxes));
        if (brandConfig != null) {
            ret.addMediaLinks(this.createMediaLinkBeanList(brandConfig.getBrandMediaLinkIds(), req));
        }
        return redirectTarget == null ? new InternalPageBeanResponse(ret) : new InternalPageBeanWithRedirectResponse(ret, redirectTarget);
    }

    private List<MediaLinkBean> createMediaLinkBeanList(List<String> mediaLinkIds, HttpServletRequest req) throws ASGRuntimeException {
        String linkPrefix = this.getRDPrefix();
        ArrayList<MediaLinkBean> ret = new ArrayList<MediaLinkBean>(mediaLinkIds.size());
        for (String id : mediaLinkIds) {
            MediaLink item = this.siteDataService.getMediaLink(id);
            if (this.disabledByGuards(req, item)) continue;
            MediaLinkBean bean = new MediaLinkBean();
            bean.setId(item.getId());
            bean.setName(item.getName());
            boolean needUseRDServlet = false;
            if (!(StringUtils.isEmpty((String)item.getHref()) || item.getHref().startsWith("http:") || item.getHref().startsWith("https:") || item.getRel() != 3 && item.getRev() != 3)) {
                needUseRDServlet = true;
            }
            bean.setHref((String)(needUseRDServlet ? linkPrefix + item.getHref() : item.getHref()));
            if (!StringUtils.isEmpty((String)item.getFile())) {
                bean.setHref(this.getCMSFileUrl(item.getFile(), req));
            }
            bean.setType(item.getType());
            bean.setMedia(item.getMedia() > 0 ? MediaDescUtils.getName((int)item.getMedia()) : "all");
            bean.setRel(item.getRel() > 1 ? LinkTypesUtils.getName((int)item.getRel()) : "");
            bean.setRev(item.getRev() > 1 ? LinkTypesUtils.getName((int)item.getRev()) : "");
            bean.setCharset(item.getCharset());
            bean.setHreflang(item.getHreflang());
            bean.setBrowserFiltering(item.getBrowserFiltering());
            bean.setOnload(item.getOnload());
            ret.add(bean);
        }
        return ret;
    }

    private String getRDPrefix() {
        Object prefix = "";
        if (rdConfig.isUseForCMSEnabled()) {
            prefix = rdConfig.getServletMapping() + "/";
            if (rdConfig.isUseAppVersionInURL()) {
                MavenVersion mVersion = VersionUtil.getWebappVersion((ServletContext)this.getServletContext());
                prefix = mVersion != null ? (String)prefix + rdConfig.getVersionPrefix() + mVersion.getVersion() + "_" + mVersion.getFileTimestamp() + "/" : (String)prefix + rdConfig.getVersionPrefix() + "unknown/";
            }
        }
        return prefix;
    }

    private List<MediaLinkBean> searchMediaLinks(List<BoxBean> boxBeans) {
        ArrayList<MediaLinkBean> ret = new ArrayList<MediaLinkBean>();
        for (BoxBean box : boxBeans) {
            ret.addAll(box.getMediaLinks());
            ret.addAll(this.searchMediaLinks(box.getSubboxes()));
        }
        return ret;
    }

    private List<ScriptBean> createScriptBeanList(List<String> scriptIds, HttpServletRequest req) throws ASGRuntimeException {
        String linkPrefix = this.getRDPrefix();
        ArrayList<ScriptBean> ret = new ArrayList<ScriptBean>(scriptIds.size());
        for (String id : scriptIds) {
            Script item = this.siteDataService.getScript(id);
            if (this.disabledByGuards(req, item)) continue;
            ScriptBean bean = new ScriptBean(item.getId());
            bean.setName(item.getName());
            boolean needUseRDServlet = false;
            if (!StringUtils.isEmpty((String)item.getLink())) {
                needUseRDServlet = true;
            }
            bean.setLink((String)(needUseRDServlet ? linkPrefix + item.getLink() : item.getLink()));
            if (!StringUtils.isEmpty((String)item.getFile())) {
                bean.setLink(this.getCMSFileUrl(item.getFile(), req));
            }
            bean.setContent(item.getContent());
            bean.setBrowserFiltering(item.getBrowserFiltering());
            ret.add(bean);
        }
        return ret;
    }

    private List<ScriptBean> searchScripts(List<BoxBean> boxBeans) {
        ArrayList<ScriptBean> ret = new ArrayList<ScriptBean>();
        for (BoxBean box : boxBeans) {
            ret.addAll(box.getScripts());
            ret.addAll(this.searchScripts(box.getSubboxes()));
        }
        return ret;
    }

    private String getCMSFileUrl(String cmsFileId, HttpServletRequest req) throws ASGRuntimeException {
        FileLink f = this.resourceDataService.getFileLink(cmsFileId);
        return req.getContextPath() + FILE_PATH_PART + f.getFile();
    }

    private SiteBean createSiteBean(PageTemplate template, HttpServletRequest req) {
        SiteBean ret = new SiteBean();
        try {
            Site site = this.siteDataService.getSite(template.getSite());
            ret.setSubtitle(site.getSubtitle());
            ret.setTitle(site.getTitle());
            ret.setKeywords(VariablesUtility.replaceVariables(req, site.getKeywords()));
            ret.setDescription(VariablesUtility.replaceVariables(req, site.getDescription()));
            ret.setLanguageSelector(site.getLanguageselector());
            if (site.getStartpage() != null && site.getStartpage().length() > 0) {
                ret.setLinkToStartPage(this.webDataService.getPagex(site.getStartpage()).getName() + HTML_SUFFIX);
            }
            if (site.getSearchpage() != null && site.getSearchpage().length() > 0) {
                ret.setSearchTarget(this.webDataService.getPagex(site.getSearchpage()).getName() + HTML_SUFFIX);
            }
            this.populateLogo(req.getContextPath() + FILE_PATH_PART, ret, site.getSiteLogo());
        }
        catch (Exception e) {
            LOGGER.warn("createSiteBean(" + template + ",request)", (Throwable)e);
        }
        return ret;
    }

    private void populateLogo(String pathPart, SiteBean created, String logoId) {
        if (this.isNotNullOrEmpty(logoId)) {
            try {
                Image img = this.resourceDataService.getImage(logoId);
                if (img != null && this.isNotNullOrEmpty(img.getImage())) {
                    created.setLogo(pathPart + img.getImage());
                }
            }
            catch (ASResourceDataServiceException e) {
                LOGGER.warn("SiteLogo Image with id:{" + logoId + "} does not exist!");
            }
        }
    }

    private boolean isNotNullOrEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    private String extractPageName(HttpServletRequest req) {
        return ContentPageServlet.extractArtifactName(req);
    }

    private Pagex resolvePageByName(String pageName) throws ServletException {
        Pagex page = this.getPageByLocalizedName(pageName);
        return page == null ? this.getPageByName(pageName) : page;
    }

    private Pagex getPageByName(String pageName) throws ServletException {
        try {
            return (Pagex)this.webDataService.getPagexsByProperty("name", (Object)pageName).get(0);
        }
        catch (Exception e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("getPageByName(" + pageName + ")", (Throwable)e);
            }
            return null;
        }
    }

    private Pagex getPageByLocalizedName(String pageName) throws ServletException {
        try {
            String localizedNameProperty = "localizedName_" + ContextManager.getCallContext().getCurrentLanguage();
            List pages = this.webDataService.getPagexsByProperty(localizedNameProperty, (Object)pageName);
            return pages.isEmpty() ? null : (Pagex)pages.get(0);
        }
        catch (Exception e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("getPageByLocalizedName(" + pageName + ")", (Throwable)e);
            }
            return null;
        }
    }

    private void prepareTextResources(HttpServletRequest req) throws ASResourceDataServiceException {
        List resources = this.resourceDataService.getTextResources();
        for (TextResource r : resources) {
            req.setAttribute("res." + r.getName(), (Object)VariablesUtility.replaceVariables(req, r.getValue()));
        }
    }

    private void prepareTemplateLocalization(List<String> localizationBundlesIds) throws ASResourceDataServiceException, ASGRuntimeException {
        LocalizationMap.getCurrentLocalizationMap().addLocalizationBundles(LocalizationEnvironment.TEMPLATE, this.getLocalizationBundles(localizationBundlesIds));
    }

    private void preparePageLocalization(List<String> localizationBundlesIds) throws ASResourceDataServiceException, ASGRuntimeException {
        LocalizationMap.getCurrentLocalizationMap().addLocalizationBundles(LocalizationEnvironment.PAGE, this.getLocalizationBundles(localizationBundlesIds));
    }

    private void prepareBrandLocalization(List<String> localizationBundlesIds) throws ASResourceDataServiceException, ASGRuntimeException {
        LocalizationMap.getCurrentLocalizationMap().addLocalizationBundles(LocalizationEnvironment.BRAND, this.getLocalizationBundles(localizationBundlesIds));
    }

    private void prepareBoxLocalization(BoxBean box, List<String> localizationBundlesIds) throws ASResourceDataServiceException, ASGRuntimeException {
        LocalizationMap.getCurrentLocalizationMap().addLocalizationBundles(LocalizationEnvironment.BOX, this.getLocalizationBundles(localizationBundlesIds));
    }

    private List<LocalizationBundle> getLocalizationBundles(List<String> localizationBundlesIds) throws ASResourceDataServiceException, ASGRuntimeException {
        ArrayList<LocalizationBundle> ret = new ArrayList<LocalizationBundle>();
        for (String bundleId : localizationBundlesIds) {
            ret.add(this.resourceDataService.getLocalizationBundle(bundleId));
        }
        return ret;
    }

    private AttributeMap createAttributeMap(HttpServletRequest req, HttpServletResponse res, List<String> attributeIds) throws ASGRuntimeException {
        if (attributeIds == null || attributeIds.isEmpty()) {
            return new AttributeMap();
        }
        List<Attribute> attributes = this.createAttributes(req, res, attributeIds);
        AttributeMap ret = new AttributeMap();
        for (Attribute a : attributes) {
            ret.setAttribute(new AttributeBean(a.getKey(), a.getName(), a.getValue()));
        }
        return ret;
    }

    private List<Attribute> createAttributes(HttpServletRequest req, HttpServletResponse res, List<String> ids) throws ASGRuntimeException {
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        for (String id : ids) {
            boolean doBreak = false;
            Attribute a = this.webDataService.getAttribute(id);
            List gIds = a.getGuards();
            for (String gid : gIds) {
                ConditionalGuard g = null;
                try {
                    g = GuardFactory.getConditionalGuard(gid);
                    if (g.isConditionFullfilled((DataObject)a, req)) continue;
                    doBreak = true;
                    break;
                }
                catch (Exception e) {
                    LOGGER.warn("exception in guard: " + g + ", attr id: " + id + ", caught.", (Throwable)e);
                }
            }
            if (doBreak) continue;
            if (a.getSubattributes().size() == 0) {
                ret.add(a);
                continue;
            }
            ret.addAll(this.createAttributes(req, res, a.getSubattributes()));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fallBackToFileSystem(HttpServletRequest req, HttpServletResponse res) {
        int pathIndex = StringUtils.isEmpty((String)req.getContextPath()) ? 0 : req.getContextPath().length();
        String path = this.getServletContext().getRealPath(req.getRequestURI().substring(pathIndex));
        File f = new File(path);
        LOGGER.debug("Loading uri: " + req.getRequestURL() + " from file " + path + ", exists: " + f.exists());
        if (!f.exists()) {
            return false;
        }
        FileInputStream fIn = null;
        try {
            fIn = new FileInputStream(f);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fIn, MY_FS_CHARSET));
            int r = -1;
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)res.getOutputStream(), MY_FS_CHARSET);
            BufferedWriter writer = new BufferedWriter(out);
            while ((r = reader.read()) != -1) {
                writer.write(r);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            LOGGER.error("fallBackToFileSystem(URI: " + req.getRequestURL() + ")", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fIn != null) {
                try {
                    fIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    class WizardExecutor
    implements BlueprintCallExecutor {
        WizardExecutor() {
        }

        public Object execute(Object ... parameters) throws Exception {
            return ContentPageServlet.this.handleWizardProcess((HttpServletRequest)HttpServletRequest.class.cast(parameters[0]), (HttpServletResponse)HttpServletResponse.class.cast(parameters[1]), (WizardDef)WizardDef.class.cast(parameters[2]));
        }
    }

    class BoxBeanCreator
    implements BlueprintCallExecutor {
        BoxBeanCreator() {
        }

        public Object execute(Object ... parameters) throws ASGRuntimeException, BoxHandleException {
            return ContentPageServlet.this.createBoxBean((HttpServletRequest)parameters[0], (HttpServletResponse)parameters[1], (Box)parameters[2]);
        }
    }

    class PageBeanCreator
    implements BlueprintCallExecutor {
        PageBeanCreator() {
        }

        public Object execute(Object ... parameters) throws ASGRuntimeException {
            return ContentPageServlet.this.createPageBean((HttpServletRequest)parameters[0], (HttpServletResponse)parameters[1], (Pagex)parameters[2], (PageTemplate)parameters[3]);
        }
    }
}

