/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.anotheria.anosite.config.ResourceDeliveryConfig;
import net.anotheria.moskito.web.MoskitoHttpServlet;
import net.anotheria.util.log.LogMessageUtil;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDeliveryServlet
extends MoskitoHttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceDeliveryServlet.class);
    private static final long serialVersionUID = -8935110768011959639L;
    private static ResourceDeliveryConfig config = ResourceDeliveryConfig.getInstance();
    public static final Locale LOCALE_US = Locale.US;
    public static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    public static final String RFC1123_PATTERN = "EEE, dd MMM yyyyy HH:mm:ss z";

    protected void moskitoDoGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path;
        String pathInfo = req.getPathInfo();
        String string = path = pathInfo.startsWith("/") ? pathInfo.substring(1) : pathInfo;
        if (path.startsWith(config.getVersionPrefix())) {
            int idx = path.indexOf("/");
            if (idx == -1) {
                res.setStatus(400);
                return;
            }
            path = path.substring(idx + 1);
        }
        ContentType type = null;
        if (path.toLowerCase().endsWith(".css")) {
            type = ContentType.CSS;
        }
        if (path.toLowerCase().endsWith(".js")) {
            type = ContentType.JS;
        }
        if (path.toLowerCase().endsWith(".jpg")) {
            type = ContentType.JPG;
        }
        if (path.toLowerCase().endsWith(".jpeg")) {
            type = ContentType.JPEG;
        }
        if (path.toLowerCase().endsWith(".png")) {
            type = ContentType.PNG;
        }
        if (path.toLowerCase().endsWith(".gif")) {
            type = ContentType.GIF;
        }
        if (path.toLowerCase().endsWith(".eot")) {
            type = ContentType.EOT;
        }
        if (path.toLowerCase().endsWith(".ttf")) {
            type = ContentType.TRUE_TYPE;
        }
        if (path.toLowerCase().endsWith(".otf")) {
            type = ContentType.OPEN_TYPE;
        }
        if (path.toLowerCase().endsWith(".woff")) {
            type = ContentType.WOFF;
        }
        if (path.toLowerCase().endsWith(".svg")) {
            type = ContentType.SVG;
        }
        if (type == null) {
            res.setStatus(400);
            return;
        }
        File resource = new File(this.getServletContext().getRealPath("") + File.separator + path);
        if (!resource.exists()) {
            res.sendError(404, pathInfo);
            return;
        }
        this.setHeaders(res, type, resource.lastModified());
        this.stream(resource, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stream(File resourceFile, HttpServletResponse res) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(resourceFile);
            ServletOutputStream out = res.getOutputStream();
            IOUtils.copyLarge((InputStream)in, (OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            try {
                String message = LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{resourceFile, res});
                LOGGER.warn(message, (Throwable)e);
                res.setStatus(500);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    private void setHeaders(HttpServletResponse res, ContentType contentType, long lastModifiedDate) {
        res.setContentType(contentType.getType());
        SimpleDateFormat df = new SimpleDateFormat(RFC1123_PATTERN, LOCALE_US);
        df.setTimeZone(GMT_ZONE);
        res.setHeader("Last-Modified", df.format(new Date(lastModifiedDate)));
        Calendar cal = Calendar.getInstance();
        if (config.isResourceNeverExpire()) {
            cal.add(1, 1);
        } else {
            cal.add(6, 3);
        }
        res.addHeader("Expires", df.format(cal.getTime()));
    }

    public static enum ContentType {
        CSS("text/css"),
        JS("text/javascript"),
        PNG("image/png"),
        JPG("image/jpg"),
        JPEG("image/jpeg"),
        GIF("image/gif"),
        EOT("application/vnd.ms-fontobject"),
        TRUE_TYPE("font/ttf"),
        OPEN_TYPE("font/opentype"),
        WOFF("font/x-woff"),
        SVG("image/svg+xml");

        private final String type;

        private ContentType(String aType) {
            this.type = aType;
        }

        public String getType() {
            return this.type;
        }
    }
}

