/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.servlet;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.aslayoutdata.data.PageStyle;
import net.anotheria.anosite.gen.aslayoutdata.service.ASLayoutDataServiceException;
import net.anotheria.anosite.gen.aslayoutdata.service.IASLayoutDataService;
import net.anotheria.moskito.web.MoskitoHttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class StyleSheetServlet
extends MoskitoHttpServlet {
    private static final Logger fatalLogger = LoggerFactory.getLogger(StyleSheetServlet.class);
    private static final long serialVersionUID = 1L;
    private IASLayoutDataService layoutDataService;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.layoutDataService = (IASLayoutDataService)MetaFactory.get(IASLayoutDataService.class);
        }
        catch (MetaFactoryException e) {
            fatalLogger.error(MarkerFactory.getMarker((String)"FATAL"), "ASG service init failure", (Throwable)e);
            throw new ServletException("ASG services init failure", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moskitoDoGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        int indexOfDot;
        String path = req.getPathInfo();
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if ((indexOfDot = path.indexOf(46)) != -1) {
            path = path.substring(0, indexOfDot);
        }
        try {
            PageStyle style = this.layoutDataService.getPageStyle(path);
            ServletOutputStream out = null;
            try {
                res.setContentType("text/css");
                out = res.getOutputStream();
                out.write(style.getCss().getBytes());
                out.flush();
                out.close();
                out = null;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (ASLayoutDataServiceException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

