/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anosite.content.servlet.resource;

import jakarta.servlet.ServletException;
import java.util.List;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.anosite.content.servlet.resource.ResourceServlet;
import net.anotheria.anosite.content.servlet.resource.type.ResourceReadType;
import net.anotheria.anosite.gen.asresourcedata.data.FileLink;
import net.anotheria.anosite.gen.asresourcedata.service.ASResourceDataServiceException;

public class CMSFileServlet
extends ResourceServlet {
    @Override
    protected String getFileName(ResourceReadType type, String propertyValue) throws ServletException {
        if (type == ResourceReadType.BY_DIRECT_FILE_NAME) {
            return propertyValue;
        }
        switch (type) {
            case BY_ID: {
                try {
                    FileLink file = this.getResourceService().getFileLink(propertyValue);
                    if (file != null) {
                        return file.getFile();
                    }
                    CMSFileServlet.getLog().warn("FileLink " + type.getValue() + "[" + propertyValue + "] ::: missing");
                    return null;
                }
                catch (NoSuchDocumentException nSde) {
                    CMSFileServlet.getLog().warn("FileLink " + type.getValue() + "[" + propertyValue + "] ::: missing");
                    return null;
                }
                catch (ASResourceDataServiceException e) {
                    CMSFileServlet.getLog().error("ASResourceDataServiceException failed", (Throwable)e);
                    throw new ServletException("Internal Server Error", (Throwable)e);
                }
            }
            case BY_NAME: {
                try {
                    List files = this.getResourceService().getFileLinksByProperty("name", (Object)propertyValue);
                    if (files != null && !files.isEmpty() && files.get(0) != null) {
                        return ((FileLink)files.get(0)).getFile();
                    }
                    CMSFileServlet.getLog().warn("FileLink " + type.getValue() + "[" + propertyValue + "] ::: missing");
                    return null;
                }
                catch (ASResourceDataServiceException e) {
                    CMSFileServlet.getLog().error("ASResourceDataServiceException failed", (Throwable)e);
                    throw new ServletException("Internal Server Error", (Throwable)e);
                }
            }
        }
        throw new RuntimeException(type + " NOT supported!");
    }
}

